/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContent;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContentDecompressor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.Buffer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.UpgradeRejectedException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.headers.HeadersAdaptor;

class WebSocketHandshakeInboundHandler
extends ChannelInboundHandlerAdapter {
    private final Handler<AsyncResult<HeadersAdaptor>> wsHandler;
    private final WebSocketClientHandshaker handshaker;
    private ChannelHandlerContext chctx;
    private FullHttpResponse response;
    private ChannelFuture fut;

    WebSocketHandshakeInboundHandler(WebSocketClientHandshaker handshaker, Handler<AsyncResult<HeadersAdaptor>> wsHandler) {
        this.handshaker = handshaker;
        this.wsHandler = wsHandler;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.chctx = ctx;
        this.fut = this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.wsHandler.handle(Future.failedFuture(new WebSocketHandshakeException("Connection closed while handshake in process")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse resp = (HttpResponse)msg;
            this.response = new DefaultFullHttpResponse(resp.protocolVersion(), resp.status());
            this.response.headers().add(resp.headers());
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            try {
                if (this.response != null) {
                    this.response.content().writeBytes(content.content());
                    if (msg instanceof LastHttpContent) {
                        this.response.trailingHeaders().add(((LastHttpContent)msg).trailingHeaders());
                        ChannelPipeline pipeline = this.chctx.pipeline();
                        pipeline.remove((ChannelHandler)this);
                        ChannelHandler handler = pipeline.get(HttpContentDecompressor.class);
                        if (handler != null) {
                            ctx.pipeline().remove(handler);
                        }
                        this.handshakeComplete(this.response);
                    }
                }
            }
            finally {
                content.release();
            }
        }
    }

    private void handshakeComplete(FullHttpResponse response) {
        int sc = response.status().code();
        if (sc != 101) {
            String msg = "WebSocket upgrade failure: " + sc;
            ByteBuf content = response.content();
            UpgradeRejectedException failure = new UpgradeRejectedException(msg, sc, new HeadersAdaptor(response.headers()), content != null ? Buffer.buffer(content) : null);
            this.wsHandler.handle(Future.failedFuture(failure));
        } else {
            this.fut.addListener(future -> {
                Future<Object> res;
                if (future.isSuccess()) {
                    try {
                        this.handshaker.finishHandshake(this.chctx.channel(), response);
                        res = Future.succeededFuture(new HeadersAdaptor(response.headers()));
                    }
                    catch (WebSocketHandshakeException e) {
                        res = Future.failedFuture(e);
                    }
                } else {
                    res = Future.failedFuture(future.cause());
                }
                this.wsHandler.handle(res);
            });
        }
    }
}

