/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net;

import java.util.Base64;
import java.util.Map;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.handler.logging.ByteBufFormat;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.impl.JsonUtil;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.NetworkOptions;

public class NetworkOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, NetworkOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "activityLogDataFormat": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setActivityLogDataFormat(ByteBufFormat.valueOf((String)((String)member.getValue())));
                    break;
                }
                case "logActivity": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setLogActivity((Boolean)member.getValue());
                    break;
                }
                case "receiveBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReceiveBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "reuseAddress": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setReuseAddress((Boolean)member.getValue());
                    break;
                }
                case "reusePort": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setReusePort((Boolean)member.getValue());
                    break;
                }
                case "sendBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSendBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "trafficClass": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTrafficClass(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(NetworkOptions obj, JsonObject json) {
        NetworkOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(NetworkOptions obj, Map<String, Object> json) {
        if (obj.getActivityLogDataFormat() != null) {
            json.put("activityLogDataFormat", obj.getActivityLogDataFormat().name());
        }
        json.put("logActivity", obj.getLogActivity());
        json.put("receiveBufferSize", obj.getReceiveBufferSize());
        json.put("reuseAddress", obj.isReuseAddress());
        json.put("reusePort", obj.isReusePort());
        json.put("sendBufferSize", obj.getSendBufferSize());
        json.put("trafficClass", obj.getTrafficClass());
    }
}

