/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.grpc;

import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.BinaryLog;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.BindableService;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.CompressorRegistry;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.DecompressorRegistry;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.HandlerRegistry;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerBuilder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerInterceptor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerServiceDefinition;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerStreamTracer;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerTransportFilter;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import org.apache.pulsar.functions.runtime.shaded.javax.annotation.Nullable;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Vertx;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpServerOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.ServerID;
import org.apache.pulsar.jetcd.shaded.io.vertx.grpc.VertxServer;

public class VertxServerBuilder
extends ServerBuilder<VertxServerBuilder> {
    private final ServerID id;
    private final VertxInternal vertx;
    private final NettyServerBuilder builder;
    private final HttpServerOptions options = new HttpServerOptions();
    private Consumer<Runnable> commandDecorator;

    public static VertxServerBuilder forPort(Vertx vertx, int port) {
        return new VertxServerBuilder(vertx, port);
    }

    public static VertxServerBuilder forAddress(Vertx vertx, SocketAddress address) {
        return new VertxServerBuilder(vertx, address);
    }

    public static VertxServerBuilder forAddress(Vertx vertx, String host, int port) {
        return new VertxServerBuilder(vertx, new InetSocketAddress(host, port));
    }

    private VertxServerBuilder(Vertx vertx, int port) {
        this.id = new ServerID(port, "0.0.0.0");
        this.vertx = (VertxInternal)vertx;
        this.builder = NettyServerBuilder.forPort((int)port);
    }

    private VertxServerBuilder(Vertx vertx, SocketAddress address) {
        this.id = new ServerID(((InetSocketAddress)address).getPort(), ((InetSocketAddress)address).getHostString());
        this.vertx = (VertxInternal)vertx;
        this.builder = NettyServerBuilder.forAddress((SocketAddress)address);
    }

    public NettyServerBuilder nettyBuilder() {
        return this.builder;
    }

    public VertxServerBuilder directExecutor() {
        throw new UnsupportedOperationException();
    }

    public VertxServerBuilder executor(@Nullable Executor executor) {
        throw new UnsupportedOperationException();
    }

    public VertxServerBuilder addService(ServerServiceDefinition service) {
        this.builder.addService(service);
        return this;
    }

    public VertxServerBuilder addService(BindableService bindableService) {
        this.builder.addService(bindableService);
        return this;
    }

    public VertxServerBuilder fallbackHandlerRegistry(@Nullable HandlerRegistry fallbackRegistry) {
        this.builder.fallbackHandlerRegistry(fallbackRegistry);
        return this;
    }

    public VertxServerBuilder useTransportSecurity(File certChain, File privateKey) {
        this.builder.useTransportSecurity(certChain, privateKey);
        return this;
    }

    public VertxServerBuilder addTransportFilter(ServerTransportFilter filter) {
        this.builder.addTransportFilter(filter);
        return this;
    }

    public VertxServerBuilder addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.builder.addStreamTracerFactory(factory);
        return this;
    }

    public VertxServerBuilder decompressorRegistry(@Nullable DecompressorRegistry registry) {
        this.builder.decompressorRegistry(registry);
        return this;
    }

    public VertxServerBuilder compressorRegistry(@Nullable CompressorRegistry registry) {
        this.builder.compressorRegistry(registry);
        return this;
    }

    public VertxServerBuilder intercept(ServerInterceptor interceptor) {
        this.builder.intercept(interceptor);
        return this;
    }

    public VertxServerBuilder useTransportSecurity(InputStream certChain, InputStream privateKey) {
        this.builder.useTransportSecurity(certChain, privateKey);
        return this;
    }

    public VertxServerBuilder handshakeTimeout(long timeout, TimeUnit unit) {
        this.builder.handshakeTimeout(timeout, unit);
        return this;
    }

    public VertxServerBuilder maxInboundMessageSize(int bytes) {
        this.builder.maxInboundMessageSize(bytes);
        return this;
    }

    public VertxServerBuilder setBinaryLog(BinaryLog binaryLog) {
        this.builder.setBinaryLog(binaryLog);
        return this;
    }

    public VertxServerBuilder maxInboundMetadataSize(int bytes) {
        this.builder.maxInboundMetadataSize(bytes);
        return this;
    }

    public VertxServerBuilder useSsl(Handler<HttpServerOptions> handler) {
        handler.handle(this.options);
        return this;
    }

    public VertxServerBuilder commandDecorator(Consumer<Runnable> commandDecorator) {
        this.commandDecorator = commandDecorator;
        return this;
    }

    public VertxServer build() {
        ContextInternal context = this.vertx.getOrCreateContext();
        return new VertxServer(this.id, this.options, this.builder, context, this.commandDecorator);
    }
}

