/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.oauth2.FlowBase;
import org.apache.pulsar.client.impl.auth.oauth2.KeyFile;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.ClientCredentialsExchangeRequest;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.ClientCredentialsExchanger;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenClient;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenExchangeException;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientCredentialsFlow
extends FlowBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientCredentialsFlow.class);
    public static final String CONFIG_PARAM_ISSUER_URL = "issuerUrl";
    public static final String CONFIG_PARAM_AUDIENCE = "audience";
    public static final String CONFIG_PARAM_KEY_FILE = "privateKey";
    public static final String CONFIG_PARAM_SCOPE = "scope";
    private static final long serialVersionUID = 1L;
    private final String audience;
    private final String privateKey;
    private final String scope;
    private transient ClientCredentialsExchanger exchanger;
    private boolean initialized = false;

    public ClientCredentialsFlow(URL issuerUrl, String audience, String privateKey, String scope) {
        super(issuerUrl);
        this.audience = audience;
        this.privateKey = privateKey;
        this.scope = scope;
    }

    @Override
    public void initialize() throws PulsarClientException {
        super.initialize();
        assert (this.metadata != null);
        URL tokenUrl = this.metadata.getTokenEndpoint();
        this.exchanger = new TokenClient(tokenUrl);
        this.initialized = true;
    }

    @Override
    public TokenResult authenticate() throws PulsarClientException {
        TokenResult tr;
        KeyFile keyFile;
        try {
            keyFile = ClientCredentialsFlow.loadPrivateKey(this.privateKey);
        }
        catch (IOException e) {
            throw new PulsarClientException.AuthenticationException("Unable to read private key: " + e.getMessage());
        }
        ClientCredentialsExchangeRequest req = ClientCredentialsExchangeRequest.builder().clientId(keyFile.getClientId()).clientSecret(keyFile.getClientSecret()).audience(this.audience).scope(this.scope).build();
        if (!this.initialized) {
            this.initialize();
        }
        try {
            tr = this.exchanger.exchangeClientCredentials(req);
        }
        catch (IOException | TokenExchangeException e) {
            throw new PulsarClientException.AuthenticationException("Unable to obtain an access token: " + e.getMessage());
        }
        return tr;
    }

    @Override
    public void close() throws Exception {
        this.exchanger.close();
    }

    public static ClientCredentialsFlow fromParameters(Map<String, String> params) {
        URL issuerUrl = ClientCredentialsFlow.parseParameterUrl(params, CONFIG_PARAM_ISSUER_URL);
        String privateKeyUrl = ClientCredentialsFlow.parseParameterString(params, CONFIG_PARAM_KEY_FILE);
        String scope = params.get(CONFIG_PARAM_SCOPE);
        String audience = params.get(CONFIG_PARAM_AUDIENCE);
        return ClientCredentialsFlow.builder().issuerUrl(issuerUrl).audience(audience).privateKey(privateKeyUrl).scope(scope).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyFile loadPrivateKey(String privateKeyURL) throws IOException {
        KeyFile keyFile;
        URLConnection urlConnection = new org.apache.pulsar.client.api.url.URL(privateKeyURL).openConnection();
        try {
            KeyFile privateKey;
            String protocol = urlConnection.getURL().getProtocol();
            String contentType = urlConnection.getContentType();
            if ("data".equals(protocol) && !"application/json".equals(contentType)) {
                throw new IllegalArgumentException("Unsupported media type or encoding format: " + urlConnection.getContentType());
            }
            try (InputStreamReader r = new InputStreamReader((InputStream)urlConnection.getContent(), StandardCharsets.UTF_8);){
                privateKey = KeyFile.fromJson(r);
            }
            keyFile = privateKey;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.close(urlConnection);
                throw throwable;
            }
            catch (IllegalAccessException | InstantiationException | URISyntaxException e) {
                throw new IOException("Invalid privateKey format", e);
            }
        }
        IOUtils.close(urlConnection);
        return keyFile;
    }

    @Generated
    public static ClientCredentialsFlowBuilder builder() {
        return new ClientCredentialsFlowBuilder();
    }

    @Generated
    public static class ClientCredentialsFlowBuilder {
        @Generated
        private URL issuerUrl;
        @Generated
        private String audience;
        @Generated
        private String privateKey;
        @Generated
        private String scope;

        @Generated
        ClientCredentialsFlowBuilder() {
        }

        @Generated
        public ClientCredentialsFlowBuilder issuerUrl(URL issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        @Generated
        public ClientCredentialsFlowBuilder audience(String audience) {
            this.audience = audience;
            return this;
        }

        @Generated
        public ClientCredentialsFlowBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Generated
        public ClientCredentialsFlowBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public ClientCredentialsFlow build() {
            return new ClientCredentialsFlow(this.issuerUrl, this.audience, this.privateKey, this.scope);
        }

        @Generated
        public String toString() {
            return "ClientCredentialsFlow.ClientCredentialsFlowBuilder(issuerUrl=" + this.issuerUrl + ", audience=" + this.audience + ", privateKey=" + this.privateKey + ", scope=" + this.scope + ")";
        }
    }
}

