/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.netty;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.apache.pulsar.common.util.netty.NettyFutureUtil;
import org.apache.pulsar.functions.runtime.shaded.io.netty.bootstrap.ServerBootstrap;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.Epoll;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.EpollChannelOption;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.EpollDatagramChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.EpollMode;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.socket.DatagramChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.socket.ServerSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.incubator.channel.uring.IOUring;
import org.apache.pulsar.functions.runtime.shaded.io.netty.incubator.channel.uring.IOUringDatagramChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import org.apache.pulsar.functions.runtime.shaded.io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.incubator.channel.uring.IOUringSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.affinity.CpuAffinity;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoopUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventLoopUtil.class);
    private static final String ENABLE_IO_URING = "pulsar.enableUring";

    public static EventLoopGroup newEventLoopGroup(int nThreads, boolean enableBusyWait, ThreadFactory threadFactory) {
        if (Epoll.isAvailable()) {
            String enableIoUring = System.getProperty(ENABLE_IO_URING);
            if (StringUtils.equalsAnyIgnoreCase(enableIoUring, "1", "true")) {
                IOUring.ensureAvailability();
                return new IOUringEventLoopGroup(nThreads, threadFactory);
            }
            if (!enableBusyWait) {
                return new EpollEventLoopGroup(nThreads, threadFactory);
            }
            EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(nThreads, threadFactory, () -> (selectSupplier, hasTasks) -> -3);
            for (int i = 0; i < nThreads; ++i) {
                eventLoopGroup.next().submit(() -> {
                    try {
                        CpuAffinity.acquireCore();
                    }
                    catch (Throwable t) {
                        log.warn("Failed to acquire CPU core for thread {} {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
                    }
                });
            }
            return eventLoopGroup;
        }
        return new NioEventLoopGroup(nThreads, threadFactory);
    }

    public static Class<? extends SocketChannel> getClientSocketChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof IOUringEventLoopGroup) {
            return IOUringSocketChannel.class;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> getServerSocketChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof IOUringEventLoopGroup) {
            return IOUringServerSocketChannel.class;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends DatagramChannel> getDatagramChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof IOUringEventLoopGroup) {
            return IOUringDatagramChannel.class;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollDatagramChannel.class;
        }
        return NioDatagramChannel.class;
    }

    public static void enableTriggeredMode(ServerBootstrap bootstrap) {
        if (Epoll.isAvailable()) {
            bootstrap.childOption(EpollChannelOption.EPOLL_MODE, EpollMode.LEVEL_TRIGGERED);
        }
    }

    public static CompletableFuture<Void> shutdownGracefully(EventLoopGroup eventLoopGroup) {
        return NettyFutureUtil.toCompletableFutureVoid(eventLoopGroup.shutdownGracefully());
    }
}

