/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.protocol.schema.SchemaHash;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;

class SinkSchemaInfoProvider
implements SchemaInfoProvider {
    AtomicLong latestVersion = new AtomicLong(0L);
    ConcurrentHashMap<SchemaVersion, SchemaInfo> schemaInfos = new ConcurrentHashMap();
    ConcurrentHashMap<SchemaHash, SchemaVersion> schemaVersions = new ConcurrentHashMap();

    SinkSchemaInfoProvider() {
    }

    public SchemaVersion addSchemaIfNeeded(Schema<?> schema) {
        SchemaHash schemaHash = SchemaHash.of(schema);
        return this.schemaVersions.computeIfAbsent(schemaHash, s -> this.createNewSchemaInfo(schema.getSchemaInfo()));
    }

    private SchemaVersion createNewSchemaInfo(SchemaInfo schemaInfo) {
        long l = this.latestVersion.incrementAndGet();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(l);
        BytesSchemaVersion schemaVersion = BytesSchemaVersion.of(buffer.array());
        this.schemaInfos.put(schemaVersion, schemaInfo);
        return schemaVersion;
    }

    @Override
    public CompletableFuture<SchemaInfo> getSchemaByVersion(byte[] schemaVersion) {
        return CompletableFuture.completedFuture(this.schemaInfos.get(BytesSchemaVersion.of(schemaVersion)));
    }

    @Override
    public CompletableFuture<SchemaInfo> getLatestSchema() {
        long l = this.latestVersion.get();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(l);
        BytesSchemaVersion schemaVersion = BytesSchemaVersion.of(buffer.array());
        return CompletableFuture.completedFuture(this.schemaInfos.get(schemaVersion));
    }

    @Override
    public String getTopicName() {
        return "__INTERNAL__";
    }
}

