/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.json.jackson;

import java.io.IOException;
import java.time.Instant;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.impl.JsonUtil;

class ByteArrayDeserializer
extends JsonDeserializer<byte[]> {
    ByteArrayDeserializer() {
    }

    @Override
    public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        try {
            return JsonUtil.BASE64_DECODER.decode(text);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "Expected a base64 encoded byte array", (Object)text, Instant.class);
        }
    }
}

