/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.core.common;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Splitter;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Strings;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.cache.CacheLoader;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.cache.LoadingCache;
import org.apache.pulsar.packages.management.core.common.PackageType;

public class PackageName {
    private final PackageType type;
    private final String namespace;
    private final String tenant;
    private final String name;
    private final String version;
    private final String completePackageName;
    private final String completeName;
    private static final LoadingCache<String, PackageName> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<String, PackageName>(){

        @Override
        public PackageName load(String name) throws Exception {
            return new PackageName(name);
        }
    });

    public static PackageName get(String type, String tenant, String namespace, String name, String version) {
        String pkgName = type + "://" + tenant + "/" + namespace + "/" + name + "@" + version;
        return PackageName.get(pkgName);
    }

    public static PackageName get(String type, String name, String version) {
        String pkgName = type + "://" + name + "@" + version;
        return PackageName.get(pkgName);
    }

    public static PackageName get(String packageName) {
        try {
            return cache.get(packageName);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private PackageName(String packageName) {
        if (!packageName.contains("://")) {
            throw new IllegalArgumentException("Invalid package name '" + packageName + "'");
        }
        List<String> parts = Splitter.on("://").limit(2).splitToList(packageName);
        if (parts.size() != 2) {
            throw new IllegalArgumentException("Invalid package name '" + packageName + "'");
        }
        this.type = PackageType.getEnum(parts.get(0));
        String rest = parts.get(1);
        if (!rest.contains("@")) {
            rest = rest + "@";
        }
        if ((parts = Splitter.on("@").splitToList(rest)).size() != 2) {
            throw new IllegalArgumentException("Invalid package name '" + packageName + "'");
        }
        List<String> partsWithoutVersion = Splitter.on("/").splitToList(parts.get(0));
        if (partsWithoutVersion.size() != 3) {
            throw new IllegalArgumentException("Invalid package name '" + packageName + "'");
        }
        this.tenant = partsWithoutVersion.get(0);
        this.namespace = partsWithoutVersion.get(1);
        this.name = partsWithoutVersion.get(2);
        this.version = Strings.isNullOrEmpty(parts.get(1)) ? "latest" : parts.get(1);
        this.completeName = String.format("%s/%s/%s", this.tenant, this.namespace, this.name);
        this.completePackageName = String.format("%s://%s/%s/%s@%s", this.type.toString(), this.tenant, this.namespace, this.name, this.version);
    }

    public PackageType getPkgType() {
        return this.type;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getCompleteName() {
        return this.completeName;
    }

    public String toString() {
        return this.completePackageName;
    }

    public String toRestPath() {
        return String.format("%s/%s/%s/%s/%s", new Object[]{this.type, this.tenant, this.namespace, this.name, this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PackageName another = (PackageName)obj;
        return another.type.equals((Object)this.type) && another.completeName.equals(this.completeName) && another.version.equals(this.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.namespace, this.tenant, this.name, this.version});
    }
}

