/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shaded.com.yahoo.sketches.quantiles;

import org.apache.pulsar.shaded.com.yahoo.sketches.Family;
import org.apache.pulsar.shaded.com.yahoo.sketches.SketchesArgumentException;

final class Util {
    static final int MIN_BASE_BUF_SIZE = 4;
    public static final String LS = System.getProperty("line.separator");
    public static final char TAB = '\t';

    private Util() {
    }

    static void checkK(int k) {
        if (k < 1 || k >= 65536 || !org.apache.pulsar.shaded.com.yahoo.sketches.Util.isPowerOf2(k)) {
            throw new SketchesArgumentException("K must be > 0 and < 65536");
        }
    }

    static void checkFamilyID(int familyID) {
        Family family = Family.idToFamily(familyID);
        if (!family.equals((Object)Family.QUANTILES)) {
            throw new SketchesArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
    }

    static boolean checkPreLongsFlagsCap(int preambleLongs, int flags, long memCapBytes) {
        boolean valid;
        boolean empty = (flags & 4) > 0;
        int minPre = Family.QUANTILES.getMinPreLongs();
        int maxPre = Family.QUANTILES.getMaxPreLongs();
        boolean bl = valid = preambleLongs == minPre && empty || preambleLongs == maxPre && !empty;
        if (!valid) {
            throw new SketchesArgumentException("Possible corruption: PreambleLongs inconsistent with empty state: " + preambleLongs);
        }
        Util.checkFlags(flags);
        if (!empty && memCapBytes < (long)(preambleLongs << 3)) {
            throw new SketchesArgumentException("Possible corruption: Insufficient capacity for preamble: " + memCapBytes);
        }
        return empty;
    }

    static void checkFlags(int flags) {
        int allowedFlags = 30;
        int flagsMask = -31;
        if ((flags & 0xFFFFFFE1) > 0) {
            throw new SketchesArgumentException("Possible corruption: Invalid flags field: " + Integer.toBinaryString(flags));
        }
    }

    static final void validateFractions(double[] fractions) {
        if (fractions == null) {
            throw new SketchesArgumentException("Fractions cannot be null.");
        }
        int len = fractions.length;
        if (len == 0) {
            return;
        }
        double flo = fractions[0];
        double fhi = fractions[fractions.length - 1];
        if (flo < 0.0 || fhi > 1.0) {
            throw new SketchesArgumentException("A fraction cannot be less than zero or greater than 1.0");
        }
        Util.validateValues(fractions);
    }

    static final void validateValues(double[] values) {
        if (values == null) {
            throw new SketchesArgumentException("Values cannot be null.");
        }
        int lenM1 = values.length - 1;
        for (int j = 0; j < lenM1; ++j) {
            if (values[j] < values[j + 1]) continue;
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not NaN.");
        }
    }

    static int computeRetainedItems(int k, long n) {
        int bbCnt = Util.computeBaseBufferItems(k, n);
        long bitPattern = Util.computeBitPattern(k, n);
        int validLevels = Long.bitCount(bitPattern);
        return bbCnt + validLevels * k;
    }

    static int computeExpandedCombinedBufferItemCapacity(int k, long n) {
        int ret;
        int totLevels = Util.computeNumLevelsNeeded(k, n);
        if (totLevels > 0) {
            ret = (2 + totLevels) * k;
        } else {
            int bbItems = Util.computeBaseBufferItems(k, n);
            ret = Math.max(4, org.apache.pulsar.shaded.com.yahoo.sketches.Util.ceilingPowerOf2(bbItems));
        }
        return ret;
    }

    static int computeValidLevels(long bitPattern) {
        return Long.bitCount(bitPattern);
    }

    static int computeNumLevelsNeeded(int k, long n) {
        return 1 + Util.hiBitPos(n / (2L * (long)k));
    }

    static int computeBaseBufferItems(int k, long n) {
        return (int)(n % (2L * (long)k));
    }

    static long computeBitPattern(int k, long n) {
        return n / (2L * (long)k);
    }

    static double lg(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    static int hiBitPos(long num) {
        return 63 - Long.numberOfLeadingZeros(num);
    }

    static int positionOfLowestZeroBitStartingAt(long numIn, int startingPos) {
        long num = numIn >>> startingPos;
        int pos = 0;
        while ((num & 1L) != 0L) {
            num >>>= 1;
            ++pos;
        }
        return pos + startingPos;
    }

    static class EpsilonFromK {
        private static final double deltaForEps = 0.01;
        private static final double adjustKForEps = 1.3333333333333333;
        private static final double bracketedBinarySearchForEpsTol = 1.0E-15;

        EpsilonFromK() {
        }

        static double getAdjustedEpsilon(int k) {
            if (k == 1) {
                return 1.0;
            }
            return EpsilonFromK.getTheoreticalEpsilon(k, 1.3333333333333333);
        }

        private static double getTheoreticalEpsilon(int k, double ff) {
            if (k < 2) {
                throw new SketchesArgumentException("K must be greater than one.");
            }
            double kf = (double)k * ff;
            assert (kf >= 2.15);
            assert (kf < 1.0E12);
            double lo = 1.0E-16;
            double hi = 0.9999999999999999;
            assert (EpsilonFromK.epsForKPredicate(1.0E-16, kf));
            assert (!EpsilonFromK.epsForKPredicate(0.9999999999999999, kf));
            return EpsilonFromK.bracketedBinarySearchForEps(kf, 1.0E-16, 0.9999999999999999);
        }

        private static double kOfEpsFormula(double eps) {
            return 1.0 / eps * Math.sqrt(Math.log(1.0 / (eps * 0.01)));
        }

        private static boolean epsForKPredicate(double eps, double kf) {
            return EpsilonFromK.kOfEpsFormula(eps) >= kf;
        }

        private static double bracketedBinarySearchForEps(double kf, double lo, double hi) {
            assert (lo < hi);
            assert (EpsilonFromK.epsForKPredicate(lo, kf));
            assert (!EpsilonFromK.epsForKPredicate(hi, kf));
            if ((hi - lo) / lo < 1.0E-15) {
                return lo;
            }
            double mid = (lo + hi) / 2.0;
            assert (mid > lo);
            assert (mid < hi);
            if (EpsilonFromK.epsForKPredicate(mid, kf)) {
                return EpsilonFromK.bracketedBinarySearchForEps(kf, mid, hi);
            }
            return EpsilonFromK.bracketedBinarySearchForEps(kf, lo, mid);
        }
    }
}

