/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.aerospike;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Host;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.NioEventLoops;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.WritePolicy;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.aerospike.AerospikeSinkConfig;
import org.apache.pulsar.io.core.KeyValue;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.SinkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AerospikeAbstractSink<K, V>
implements Sink<byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(AerospikeAbstractSink.class);
    private AerospikeSinkConfig aerospikeSinkConfig;
    private AerospikeClient client;
    private WritePolicy writePolicy;
    private BlockingQueue<AWriteListener> queue;
    private NioEventLoops eventLoops;
    private EventLoop eventLoop;

    public void open(Map<String, Object> config, SinkContext sinkContext) throws Exception {
        this.aerospikeSinkConfig = AerospikeSinkConfig.load(config);
        if (this.aerospikeSinkConfig.getSeedHosts() == null || this.aerospikeSinkConfig.getKeyspace() == null || this.aerospikeSinkConfig.getColumnName() == null) {
            throw new IllegalArgumentException("Required property not set.");
        }
        this.writePolicy = new WritePolicy();
        this.writePolicy.maxRetries = this.aerospikeSinkConfig.getRetries();
        this.writePolicy.setTimeout(this.aerospikeSinkConfig.getTimeoutMs());
        this.eventLoops = new NioEventLoops(new EventPolicy(), 1);
        this.eventLoop = this.eventLoops.next();
        this.createClient(this.eventLoops);
        this.queue = new LinkedBlockingDeque<AWriteListener>(this.aerospikeSinkConfig.getMaxConcurrentRequests());
        for (int i = 0; i < this.aerospikeSinkConfig.getMaxConcurrentRequests(); ++i) {
            this.queue.put(new AWriteListener(this.queue));
        }
    }

    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        if (this.eventLoops != null) {
            this.eventLoops.close();
        }
        LOG.info("Connection Closed");
    }

    public void write(Record<byte[]> record) {
        KeyValue<K, V> keyValue = this.extractKeyValue(record);
        Key key = new Key(this.aerospikeSinkConfig.getKeyspace(), this.aerospikeSinkConfig.getKeySet(), keyValue.getKey().toString());
        Bin bin = new Bin(this.aerospikeSinkConfig.getColumnName(), Value.getAsBlob((Object)keyValue.getValue()));
        AWriteListener listener = null;
        try {
            listener = this.queue.take();
        }
        catch (InterruptedException ex) {
            record.fail();
            return;
        }
        listener.setContext(record);
        this.client.put(this.eventLoop, (WriteListener)listener, this.writePolicy, key, new Bin[]{bin});
    }

    private void createClient(NioEventLoops eventLoops) {
        String[] hosts = this.aerospikeSinkConfig.getSeedHosts().split(",");
        if (hosts.length <= 0) {
            throw new RuntimeException("Invalid Seed Hosts");
        }
        Host[] aeroSpikeHosts = new Host[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            String[] hostPort = hosts[i].split(":");
            aeroSpikeHosts[i] = new Host(hostPort[0], Integer.parseInt(hostPort[1]));
        }
        ClientPolicy policy = new ClientPolicy();
        if (this.aerospikeSinkConfig.getUserName() != null && !this.aerospikeSinkConfig.getUserName().isEmpty() && this.aerospikeSinkConfig.getPassword() != null && !this.aerospikeSinkConfig.getPassword().isEmpty()) {
            policy.user = this.aerospikeSinkConfig.getUserName();
            policy.password = this.aerospikeSinkConfig.getPassword();
        }
        policy.eventLoops = eventLoops;
        this.client = new AerospikeClient(policy, aeroSpikeHosts);
    }

    public abstract KeyValue<K, V> extractKeyValue(Record<byte[]> var1);

    private class AWriteListener
    implements WriteListener {
        private Record<byte[]> context;
        private BlockingQueue<AWriteListener> queue;

        public AWriteListener(BlockingQueue<AWriteListener> queue) {
            this.queue = queue;
        }

        public void setContext(Record<byte[]> record) {
            this.context = record;
        }

        public void onSuccess(Key key) {
            if (this.context != null) {
                this.context.ack();
            }
            try {
                this.queue.put(this);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted while being added to the queue", ex);
            }
        }

        public void onFailure(AerospikeException e) {
            if (this.context != null) {
                this.context.fail();
            }
            try {
                this.queue.put(this);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted while being added to the queue", ex);
            }
        }
    }
}

