/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.alluxio;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class AlluxioAbstractConfig
implements Serializable {
    private static final long serialVersionUID = 3727671407445918309L;
    @FieldDoc(required=true, defaultValue="", help="The hostname of Alluxio master")
    private String alluxioMasterHost;
    @FieldDoc(required=true, defaultValue="19998", help="The port that Alluxio master node runs on")
    private int alluxioMasterPort = 19998;
    @FieldDoc(required=true, defaultValue="", help="The Alluxio directory from which files should be read from or written to")
    private String alluxioDir;
    @FieldDoc(required=false, defaultValue="", help="When `alluxio.security.authentication.type` is set to `SIMPLE` or `CUSTOM`, user application uses this property to indicate the user requesting Alluxio service. If it is not set explicitly, the OS login user is used")
    private String securityLoginUser;

    public void validate() {
        Preconditions.checkNotNull((Object)this.alluxioMasterHost, (Object)"alluxioMasterHost property not set.");
        Preconditions.checkNotNull((Object)this.alluxioMasterPort, (Object)"alluxioMasterPort property not set.");
        Preconditions.checkNotNull((Object)this.alluxioDir, (Object)"alluxioDir property not set.");
    }

    public AlluxioAbstractConfig setAlluxioMasterHost(String alluxioMasterHost) {
        this.alluxioMasterHost = alluxioMasterHost;
        return this;
    }

    public AlluxioAbstractConfig setAlluxioMasterPort(int alluxioMasterPort) {
        this.alluxioMasterPort = alluxioMasterPort;
        return this;
    }

    public AlluxioAbstractConfig setAlluxioDir(String alluxioDir) {
        this.alluxioDir = alluxioDir;
        return this;
    }

    public AlluxioAbstractConfig setSecurityLoginUser(String securityLoginUser) {
        this.securityLoginUser = securityLoginUser;
        return this;
    }

    public String getAlluxioMasterHost() {
        return this.alluxioMasterHost;
    }

    public int getAlluxioMasterPort() {
        return this.alluxioMasterPort;
    }

    public String getAlluxioDir() {
        return this.alluxioDir;
    }

    public String getSecurityLoginUser() {
        return this.securityLoginUser;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlluxioAbstractConfig)) {
            return false;
        }
        AlluxioAbstractConfig other = (AlluxioAbstractConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAlluxioMasterPort() != other.getAlluxioMasterPort()) {
            return false;
        }
        String this$alluxioMasterHost = this.getAlluxioMasterHost();
        String other$alluxioMasterHost = other.getAlluxioMasterHost();
        if (this$alluxioMasterHost == null ? other$alluxioMasterHost != null : !this$alluxioMasterHost.equals(other$alluxioMasterHost)) {
            return false;
        }
        String this$alluxioDir = this.getAlluxioDir();
        String other$alluxioDir = other.getAlluxioDir();
        if (this$alluxioDir == null ? other$alluxioDir != null : !this$alluxioDir.equals(other$alluxioDir)) {
            return false;
        }
        String this$securityLoginUser = this.getSecurityLoginUser();
        String other$securityLoginUser = other.getSecurityLoginUser();
        return !(this$securityLoginUser == null ? other$securityLoginUser != null : !this$securityLoginUser.equals(other$securityLoginUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlluxioAbstractConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAlluxioMasterPort();
        String $alluxioMasterHost = this.getAlluxioMasterHost();
        result = result * 59 + ($alluxioMasterHost == null ? 43 : $alluxioMasterHost.hashCode());
        String $alluxioDir = this.getAlluxioDir();
        result = result * 59 + ($alluxioDir == null ? 43 : $alluxioDir.hashCode());
        String $securityLoginUser = this.getSecurityLoginUser();
        result = result * 59 + ($securityLoginUser == null ? 43 : $securityLoginUser.hashCode());
        return result;
    }

    public String toString() {
        return "AlluxioAbstractConfig(alluxioMasterHost=" + this.getAlluxioMasterHost() + ", alluxioMasterPort=" + this.getAlluxioMasterPort() + ", alluxioDir=" + this.getAlluxioDir() + ", securityLoginUser=" + this.getSecurityLoginUser() + ")";
    }
}

