/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch;

import java.io.Serializable;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class ElasticSearchSslConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=false, defaultValue="false", help="Enable SSL/TLS")
    private boolean enabled = false;
    @FieldDoc(required=false, defaultValue="None", help="SSL Provider")
    private String provider;
    @FieldDoc(required=false, defaultValue="true", help="Whether or not to validate node hostnames when using SSL. Changing this value is high insecure and you should not use it in production environment.")
    private boolean hostnameVerification = true;
    @FieldDoc(required=false, defaultValue="false", help="Whether or not to disable the node certificate validation. Changing this value is high insecure and you should not use it in production environment.")
    private boolean disableCertificateValidation;
    @FieldDoc(required=false, defaultValue="", help="The path to the truststore file")
    private String truststorePath;
    @FieldDoc(required=false, defaultValue="", help="Truststore password")
    private String truststorePassword;
    @FieldDoc(required=false, defaultValue="", help="The path to the keystore file")
    private String keystorePath;
    @FieldDoc(required=false, defaultValue="", help="Keystore password")
    private String keystorePassword;
    @FieldDoc(required=false, defaultValue="", help="SSL/TLS cipher suites")
    private String cipherSuites;
    @FieldDoc(required=false, defaultValue="TLSv1.2", help="Comma separated list of enabled SSL/TLS protocols")
    private String protocols = "TLSv1.2";

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getProvider() {
        return this.provider;
    }

    public boolean isHostnameVerification() {
        return this.hostnameVerification;
    }

    public boolean isDisableCertificateValidation() {
        return this.disableCertificateValidation;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getCipherSuites() {
        return this.cipherSuites;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public ElasticSearchSslConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ElasticSearchSslConfig setProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public ElasticSearchSslConfig setHostnameVerification(boolean hostnameVerification) {
        this.hostnameVerification = hostnameVerification;
        return this;
    }

    public ElasticSearchSslConfig setDisableCertificateValidation(boolean disableCertificateValidation) {
        this.disableCertificateValidation = disableCertificateValidation;
        return this;
    }

    public ElasticSearchSslConfig setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public ElasticSearchSslConfig setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    public ElasticSearchSslConfig setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public ElasticSearchSslConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public ElasticSearchSslConfig setCipherSuites(String cipherSuites) {
        this.cipherSuites = cipherSuites;
        return this;
    }

    public ElasticSearchSslConfig setProtocols(String protocols) {
        this.protocols = protocols;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSearchSslConfig)) {
            return false;
        }
        ElasticSearchSslConfig other = (ElasticSearchSslConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isHostnameVerification() != other.isHostnameVerification()) {
            return false;
        }
        if (this.isDisableCertificateValidation() != other.isDisableCertificateValidation()) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$truststorePath = this.getTruststorePath();
        String other$truststorePath = other.getTruststorePath();
        if (this$truststorePath == null ? other$truststorePath != null : !this$truststorePath.equals(other$truststorePath)) {
            return false;
        }
        String this$truststorePassword = this.getTruststorePassword();
        String other$truststorePassword = other.getTruststorePassword();
        if (this$truststorePassword == null ? other$truststorePassword != null : !this$truststorePassword.equals(other$truststorePassword)) {
            return false;
        }
        String this$keystorePath = this.getKeystorePath();
        String other$keystorePath = other.getKeystorePath();
        if (this$keystorePath == null ? other$keystorePath != null : !this$keystorePath.equals(other$keystorePath)) {
            return false;
        }
        String this$keystorePassword = this.getKeystorePassword();
        String other$keystorePassword = other.getKeystorePassword();
        if (this$keystorePassword == null ? other$keystorePassword != null : !this$keystorePassword.equals(other$keystorePassword)) {
            return false;
        }
        String this$cipherSuites = this.getCipherSuites();
        String other$cipherSuites = other.getCipherSuites();
        if (this$cipherSuites == null ? other$cipherSuites != null : !this$cipherSuites.equals(other$cipherSuites)) {
            return false;
        }
        String this$protocols = this.getProtocols();
        String other$protocols = other.getProtocols();
        return !(this$protocols == null ? other$protocols != null : !this$protocols.equals(other$protocols));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticSearchSslConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isHostnameVerification() ? 79 : 97);
        result = result * 59 + (this.isDisableCertificateValidation() ? 79 : 97);
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $truststorePath = this.getTruststorePath();
        result = result * 59 + ($truststorePath == null ? 43 : $truststorePath.hashCode());
        String $truststorePassword = this.getTruststorePassword();
        result = result * 59 + ($truststorePassword == null ? 43 : $truststorePassword.hashCode());
        String $keystorePath = this.getKeystorePath();
        result = result * 59 + ($keystorePath == null ? 43 : $keystorePath.hashCode());
        String $keystorePassword = this.getKeystorePassword();
        result = result * 59 + ($keystorePassword == null ? 43 : $keystorePassword.hashCode());
        String $cipherSuites = this.getCipherSuites();
        result = result * 59 + ($cipherSuites == null ? 43 : $cipherSuites.hashCode());
        String $protocols = this.getProtocols();
        result = result * 59 + ($protocols == null ? 43 : $protocols.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticSearchSslConfig(enabled=" + this.isEnabled() + ", provider=" + this.getProvider() + ", hostnameVerification=" + this.isHostnameVerification() + ", disableCertificateValidation=" + this.isDisableCertificateValidation() + ", truststorePath=" + this.getTruststorePath() + ", truststorePassword=" + this.getTruststorePassword() + ", keystorePath=" + this.getKeystorePath() + ", keystorePassword=" + this.getKeystorePassword() + ", cipherSuites=" + this.getCipherSuites() + ", protocols=" + this.getProtocols() + ")";
    }
}

