/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.elasticsearch.ElasticSearchConfig;
import org.apache.pulsar.io.elasticsearch.client.BulkProcessor;
import org.apache.pulsar.io.elasticsearch.client.RestClient;
import org.apache.pulsar.io.elasticsearch.client.elastic.ElasticSearchJavaRestClient;
import org.apache.pulsar.io.elasticsearch.client.opensearch.OpenSearchHighLevelRestClient;
import org.opensearch.client.Request;
import org.opensearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestClientFactory.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static RestClient createClient(ElasticSearchConfig config, BulkProcessor.Listener bulkListener) throws IOException {
        if (config.getCompatibilityMode() == ElasticSearchConfig.CompatibilityMode.ELASTICSEARCH) {
            log.info("Found compatibilityMode set to '{}', using the ElasticSearch Java client.", (Object)config.getCompatibilityMode());
            return new ElasticSearchJavaRestClient(config, bulkListener);
        }
        if (config.getCompatibilityMode() == ElasticSearchConfig.CompatibilityMode.ELASTICSEARCH_7 || config.getCompatibilityMode() == ElasticSearchConfig.CompatibilityMode.OPENSEARCH) {
            log.info("Found compatibilityMode set to '{}', using the OpenSearch High Level Rest API Client.", (Object)config.getCompatibilityMode());
            return new OpenSearchHighLevelRestClient(config, bulkListener);
        }
        log.info("Found compatibilityMode set to '{}', will try to auto detect the best client to use.", (Object)config.getCompatibilityMode());
        try {
            Map<String, Object> jsonResponse = RestClientFactory.requestInfo(config);
            boolean useOpenSearchHighLevelClient = RestClientFactory.useOpenSearchHighLevelClient(jsonResponse);
            log.info("useOpenSearchHighLevelClient={}, got info response: {}", (Object)useOpenSearchHighLevelClient, jsonResponse);
            if (useOpenSearchHighLevelClient) {
                return new OpenSearchHighLevelRestClient(config, bulkListener);
            }
            return new ElasticSearchJavaRestClient(config, bulkListener);
        }
        catch (IOException ioException) {
            log.warn("Got error while performing info request to detect Elastic version: {}", (Object)ioException.getMessage());
            throw ioException;
        }
    }

    private static Map<String, Object> requestInfo(ElasticSearchConfig config) throws IOException {
        try (OpenSearchHighLevelRestClient openSearchHighLevelRestClient = new OpenSearchHighLevelRestClient(config, null);){
            Response response = openSearchHighLevelRestClient.getClient().getLowLevelClient().performRequest(new Request("GET", "/"));
            Map map = (Map)MAPPER.readValue(response.getEntity().getContent(), Map.class);
            return map;
        }
    }

    private static boolean useOpenSearchHighLevelClient(Map<String, Object> jsonResponse) {
        Map versionMap = (Map)jsonResponse.get("version");
        String distribution = (String)versionMap.get("distribution");
        if (!StringUtils.isBlank((CharSequence)distribution) && distribution.equals("opensearch")) {
            return true;
        }
        String version = (String)versionMap.get("number");
        if (StringUtils.isBlank((CharSequence)version)) {
            return true;
        }
        String mainVersion = version.substring(0, version.indexOf("."));
        try {
            int numVersion = Integer.parseInt(mainVersion);
            return numVersion <= 7;
        }
        catch (NumberFormatException nfe) {
            log.warn("Not able to parse version: {}", (Object)mainVersion, (Object)nfe);
            return true;
        }
    }
}

