/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch.client.opensearch;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.http.HttpHost;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.elasticsearch.ElasticSearchConfig;
import org.apache.pulsar.io.elasticsearch.RandomExponentialRetry;
import org.apache.pulsar.io.elasticsearch.client.BulkProcessor;
import org.apache.pulsar.io.elasticsearch.client.RestClient;
import org.apache.pulsar.io.elasticsearch.client.opensearch.RandomExponentialBackoffPolicy;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.refresh.RefreshRequest;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkProcessor;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Node;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.Requests;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.CreateIndexResponse;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.common.Strings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.ByteSizeUnit;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchHighLevelRestClient
extends RestClient
implements BulkProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenSearchHighLevelRestClient.class);
    private RestHighLevelClient client;
    private org.opensearch.action.bulk.BulkProcessor internalBulkProcessor;

    public OpenSearchHighLevelRestClient(ElasticSearchConfig elasticSearchConfig, final BulkProcessor.Listener bulkProcessorListener) {
        super(elasticSearchConfig, bulkProcessorListener);
        log.info("ElasticSearch URL {}", (Object)this.config.getElasticSearchUrl());
        HttpHost[] httpHosts = this.getHttpHosts();
        RestClientBuilder builder = org.opensearch.client.RestClient.builder((HttpHost[])httpHosts).setRequestConfigCallback(builder1 -> builder1.setContentCompressionEnabled(this.config.isCompressionEnabled()).setConnectionRequestTimeout(this.config.getConnectionRequestTimeoutInMs()).setConnectTimeout(this.config.getConnectTimeoutInMs()).setSocketTimeout(this.config.getSocketTimeoutInMs())).setCompressionEnabled(this.config.isCompressionEnabled()).setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)this.configCallback).setFailureListener(new RestClient.FailureListener(){

            public void onFailure(Node node) {
                log.warn("Node host={} failed", (Object)node.getHost());
            }
        });
        this.client = new RestHighLevelClient(builder);
        if (this.config.isBulkEnabled()) {
            BulkProcessor.Builder bulkBuilder = org.opensearch.action.bulk.BulkProcessor.builder((bulkRequest, bulkResponseActionListener) -> this.client.bulkAsync(bulkRequest, RequestOptions.DEFAULT, bulkResponseActionListener), (BulkProcessor.Listener)new BulkProcessor.Listener(){

                private List<BulkProcessor.BulkOperationRequest> convertBulkRequest(BulkRequest bulkRequest) {
                    return bulkRequest.requests().stream().map(docWriteRequest -> {
                        if (!(docWriteRequest instanceof DocWriteRequestWithPulsarRecord)) {
                            throw new UnsupportedOperationException("Unexpected bulk request of type: " + String.valueOf(docWriteRequest.getClass()));
                        }
                        DocWriteRequestWithPulsarRecord requestWithId = (DocWriteRequestWithPulsarRecord)docWriteRequest;
                        Record pulsarRecord = requestWithId.getPulsarRecord();
                        return BulkProcessor.BulkOperationRequest.builder().pulsarRecord(pulsarRecord).build();
                    }).collect(Collectors.toList());
                }

                private List<BulkProcessor.BulkOperationResult> convertBulkResponse(BulkResponse bulkRequest) {
                    return Arrays.asList(bulkRequest.getItems()).stream().map(itemResponse -> BulkProcessor.BulkOperationResult.builder().error(itemResponse.getFailureMessage()).index(itemResponse.getIndex()).documentId(itemResponse.getId()).build()).collect(Collectors.toList());
                }

                public void beforeBulk(long l, BulkRequest bulkRequest) {
                }

                public void afterBulk(long l, BulkRequest bulkRequest, BulkResponse bulkResponse) {
                    bulkProcessorListener.afterBulk(l, this.convertBulkRequest(bulkRequest), this.convertBulkResponse(bulkResponse));
                }

                public void afterBulk(long l, BulkRequest bulkRequest, Throwable throwable) {
                    bulkProcessorListener.afterBulk(l, this.convertBulkRequest(bulkRequest), throwable);
                }
            }).setBulkActions(this.config.getBulkActions()).setBulkSize(new ByteSizeValue(this.config.getBulkSizeInMb(), ByteSizeUnit.MB)).setConcurrentRequests(this.config.getBulkConcurrentRequests()).setBackoffPolicy((BackoffPolicy)new RandomExponentialBackoffPolicy(new RandomExponentialRetry(elasticSearchConfig.getMaxRetryTimeInSec()), this.config.getRetryBackoffInMs(), this.config.getMaxRetries()));
            if (this.config.getBulkFlushIntervalInMs() > 0L) {
                bulkBuilder.setFlushInterval(new TimeValue(this.config.getBulkFlushIntervalInMs(), TimeUnit.MILLISECONDS));
            }
            this.internalBulkProcessor = bulkBuilder.build();
        } else {
            this.internalBulkProcessor = null;
        }
    }

    @Override
    public boolean indexExists(String index) throws IOException {
        GetIndexRequest request = new GetIndexRequest(new String[]{index});
        return this.client.indices().exists(request, RequestOptions.DEFAULT);
    }

    @Override
    public boolean createIndex(String index) throws IOException {
        CreateIndexRequest cireq = new CreateIndexRequest(index);
        cireq.settings(Settings.builder().put("index.number_of_shards", this.config.getIndexNumberOfShards()).put("index.number_of_replicas", this.config.getIndexNumberOfReplicas()));
        CreateIndexResponse resp = this.client.indices().create(cireq, RequestOptions.DEFAULT);
        if (!resp.isAcknowledged() || !resp.isShardsAcknowledged()) {
            throw new IOException("Unable to create index.");
        }
        return true;
    }

    @Override
    public boolean deleteIndex(String index) throws IOException {
        return this.client.indices().delete(new DeleteIndexRequest(index), RequestOptions.DEFAULT).isAcknowledged();
    }

    @Override
    public boolean indexDocument(String index, String documentId, String documentSource) throws IOException {
        IndexRequest indexRequest = Requests.indexRequest((String)index);
        if (!Strings.isNullOrEmpty((String)documentId)) {
            indexRequest.id(documentId);
        }
        indexRequest.type(this.config.getTypeName());
        indexRequest.source(documentSource, XContentType.JSON);
        IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
        return indexResponse.getResult().equals((Object)DocWriteResponse.Result.CREATED) || indexResponse.getResult().equals((Object)DocWriteResponse.Result.UPDATED);
    }

    @Override
    public boolean deleteDocument(String index, String documentId) throws IOException {
        DeleteRequest deleteRequest = Requests.deleteRequest((String)index);
        deleteRequest.id(documentId);
        deleteRequest.type(this.config.getTypeName());
        DeleteResponse deleteResponse = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        if (log.isDebugEnabled()) {
            log.debug("delete result {}", (Object)deleteResponse.getResult());
        }
        return deleteResponse.getResult().equals((Object)DocWriteResponse.Result.DELETED) || deleteResponse.getResult().equals((Object)DocWriteResponse.Result.NOT_FOUND);
    }

    @Override
    public long totalHits(String indexName) throws IOException {
        return this.search((String)indexName).getHits().getTotalHits().value;
    }

    @Override
    public long totalHits(String indexName, String query) throws IOException {
        return this.search((String)indexName, (String)query).getHits().getTotalHits().value;
    }

    @VisibleForTesting
    public SearchResponse search(String indexName) throws IOException {
        return this.search(indexName, "*:*");
    }

    @VisibleForTesting
    public SearchResponse search(String indexName, String query) throws IOException {
        MatchAllQueryBuilder queryBuilder;
        this.client.indices().refresh(new RefreshRequest(new String[]{indexName}), RequestOptions.DEFAULT);
        if ("*:*".equals(query)) {
            queryBuilder = QueryBuilders.matchAllQuery();
        } else {
            String[] split = query.split(":");
            String name = split[0];
            String text = split[1];
            queryBuilder = QueryBuilders.matchQuery((String)name, (Object)text);
        }
        return this.client.search(new SearchRequest().indices(new String[]{indexName}).source(new SearchSourceBuilder().query((QueryBuilder)queryBuilder)), RequestOptions.DEFAULT);
    }

    @Override
    public BulkProcessor getBulkProcessor() {
        return this;
    }

    @Override
    public void appendIndexRequest(BulkProcessor.BulkIndexRequest request) throws IOException {
        IndexRequestWithPulsarRecord indexRequest = new IndexRequestWithPulsarRecord(request.getIndex(), request.getRecord());
        if (!Strings.isNullOrEmpty((String)request.getDocumentId())) {
            indexRequest.id(request.getDocumentId());
        }
        indexRequest.type(this.config.getTypeName());
        indexRequest.source(request.getDocumentSource(), XContentType.JSON);
        this.internalBulkProcessor.add((IndexRequest)indexRequest);
    }

    @Override
    public void appendDeleteRequest(BulkProcessor.BulkDeleteRequest request) throws IOException {
        DeleteRequestWithPulsarRecord deleteRequest = new DeleteRequestWithPulsarRecord(request.getIndex(), request.getRecord());
        deleteRequest.id(request.getDocumentId());
        deleteRequest.type(this.config.getTypeName());
        this.internalBulkProcessor.add((DeleteRequest)deleteRequest);
    }

    @Override
    public void flush() {
        this.internalBulkProcessor.flush();
    }

    @Override
    public void closeClient() {
        try {
            if (this.internalBulkProcessor != null) {
                this.internalBulkProcessor.awaitClose(5000L, TimeUnit.MILLISECONDS);
                this.internalBulkProcessor = null;
            }
        }
        catch (InterruptedException e) {
            log.warn("Elasticsearch bulk processor close error:", (Throwable)e);
        }
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        catch (IOException e) {
            log.warn("Elasticsearch client close error:", (Throwable)e);
        }
    }

    @VisibleForTesting
    public void setClient(RestHighLevelClient client) {
        this.client = client;
    }

    @VisibleForTesting
    public void setInternalBulkProcessor(org.opensearch.action.bulk.BulkProcessor internalBulkProcessor) {
        this.internalBulkProcessor = internalBulkProcessor;
    }

    @VisibleForTesting
    public RestHighLevelClient getClient() {
        return this.client;
    }

    @VisibleForTesting
    public org.opensearch.action.bulk.BulkProcessor getInternalBulkProcessor() {
        return this.internalBulkProcessor;
    }

    private static class IndexRequestWithPulsarRecord
    extends IndexRequest
    implements DocWriteRequestWithPulsarRecord {
        private Record pulsarRecord;

        public IndexRequestWithPulsarRecord(String index, Record pulsarRecord) {
            super(index);
            this.pulsarRecord = pulsarRecord;
        }

        @Override
        public Record getPulsarRecord() {
            return this.pulsarRecord;
        }
    }

    private static class DeleteRequestWithPulsarRecord
    extends DeleteRequest
    implements DocWriteRequestWithPulsarRecord {
        private Record pulsarRecord;

        public DeleteRequestWithPulsarRecord(String index, Record pulsarRecord) {
            super(index);
            this.pulsarRecord = pulsarRecord;
        }

        @Override
        public Record getPulsarRecord() {
            return this.pulsarRecord;
        }
    }

    private static interface DocWriteRequestWithPulsarRecord {
        public Record getPulsarRecord();
    }
}

