/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.flume.node;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.SinkRunner;
import org.apache.flume.SourceRunner;
import org.apache.pulsar.io.flume.node.MaterializedConfiguration;

public class SimpleMaterializedConfiguration
implements MaterializedConfiguration {
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private final Map<String, SourceRunner> sourceRunners = new HashMap<String, SourceRunner>();
    private final Map<String, SinkRunner> sinkRunners = new HashMap<String, SinkRunner>();

    public String toString() {
        return "{ sourceRunners:" + String.valueOf(this.sourceRunners) + " sinkRunners:" + String.valueOf(this.sinkRunners) + " channels:" + String.valueOf(this.channels) + " }";
    }

    @Override
    public void addSourceRunner(String name, SourceRunner sourceRunner) {
        this.sourceRunners.put(name, sourceRunner);
    }

    @Override
    public void addSinkRunner(String name, SinkRunner sinkRunner) {
        this.sinkRunners.put(name, sinkRunner);
    }

    @Override
    public void addChannel(String name, Channel channel) {
        this.channels.put(name, channel);
    }

    @Override
    public ImmutableMap<String, Channel> getChannels() {
        return ImmutableMap.copyOf(this.channels);
    }

    @Override
    public ImmutableMap<String, SourceRunner> getSourceRunners() {
        return ImmutableMap.copyOf(this.sourceRunners);
    }

    @Override
    public ImmutableMap<String, SinkRunner> getSinkRunners() {
        return ImmutableMap.copyOf(this.sinkRunners);
    }
}

