/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.bookkeeper.AbstractHierarchicalLedgerManager;
import org.apache.zookeeper.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LongHierarchicalLedgerManager
extends AbstractHierarchicalLedgerManager {
    private static final Logger log = LoggerFactory.getLogger(LongHierarchicalLedgerManager.class);

    public LongHierarchicalLedgerManager(MetadataStore store, ScheduledExecutorService scheduler, String ledgerRootPath) {
        super(store, scheduler, ledgerRootPath);
    }

    public long getLedgerId(String pathName) throws IOException {
        if (!pathName.startsWith(this.ledgerRootPath)) {
            throw new IOException("it is not a valid hashed path name : " + pathName);
        }
        String hierarchicalPath = pathName.substring(this.ledgerRootPath.length() + 1);
        return StringUtils.stringToLongHierarchicalLedgerId((String)hierarchicalPath);
    }

    public String getLedgerPath(long ledgerId) {
        return this.ledgerRootPath + StringUtils.getLongHierarchicalLedgerPath((long)ledgerId);
    }

    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object context, int successRc, int failureRc) {
        this.asyncProcessLevelNodes(this.ledgerRootPath, new RecursiveProcessor(0, this.ledgerRootPath, processor, context, successRc, failureRc), finalCb, context, successRc, failureRc);
    }

    @Override
    protected String getLedgerParentNodeRegex() {
        return "\\d{3}";
    }

    private class RecursiveProcessor
    implements BookkeeperInternalCallbacks.Processor<String> {
        private final int level;
        private final String path;
        private final BookkeeperInternalCallbacks.Processor<Long> processor;
        private final Object context;
        private final int successRc;
        private final int failureRc;

        private RecursiveProcessor(int level, String path, BookkeeperInternalCallbacks.Processor<Long> processor, Object context, int successRc, int failureRc) {
            this.level = level;
            this.path = path;
            this.processor = processor;
            this.context = context;
            this.successRc = successRc;
            this.failureRc = failureRc;
        }

        public void process(String lNode, AsyncCallback.VoidCallback cb) {
            String nodePath = this.path + "/" + lNode;
            if (this.level == 0 && !LongHierarchicalLedgerManager.this.isLedgerParentNode(lNode)) {
                cb.processResult(this.successRc, null, this.context);
                return;
            }
            if (this.level < 3) {
                LongHierarchicalLedgerManager.this.asyncProcessLevelNodes(nodePath, new RecursiveProcessor(this.level + 1, nodePath, this.processor, this.context, this.successRc, this.failureRc), cb, this.context, this.successRc, this.failureRc);
            } else {
                LongHierarchicalLedgerManager.this.asyncProcessLedgersInSingleNode(nodePath, this.processor, cb, this.context, this.successRc, this.failureRc);
            }
        }
    }
}

