/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.json;

import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonSchema;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarColumnMetadata;
import org.apache.pulsar.sql.presto.PulsarRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.json.PulsarJsonRowDecoder;

public class PulsarJsonRowDecoderFactory
implements PulsarRowDecoderFactory {
    private final TypeManager typeManager;
    private static final Logger log = Logger.get(PulsarJsonRowDecoderFactory.class);

    public PulsarJsonRowDecoderFactory(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    @Override
    public PulsarJsonRowDecoder createRowDecoder(TopicName topicName, SchemaInfo schemaInfo, Set<DecoderColumnHandle> columns) {
        return new PulsarJsonRowDecoder((GenericJsonSchema)GenericJsonSchema.of(schemaInfo), columns);
    }

    @Override
    public List<ColumnMetadata> extractColumnMetadata(TopicName topicName, SchemaInfo schemaInfo, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        List<ColumnMetadata> columnMetadata;
        Schema schema;
        String schemaJson = new String(schemaInfo.getSchema());
        if (StringUtils.isBlank((CharSequence)schemaJson)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Topic " + topicName.toString() + " does not have a valid schema");
        }
        try {
            schema = GenericJsonSchema.of(schemaInfo).getAvroSchema();
        }
        catch (SchemaParseException ex) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Topic " + topicName.toString() + " does not have a valid schema");
        }
        try {
            columnMetadata = schema.getFields().stream().map(field -> new PulsarColumnMetadata(PulsarColumnMetadata.getColumnName(handleKeyValueType, field.name()), this.parseJsonPrestoType(field.name(), field.schema()), field.schema().toString(), null, false, false, handleKeyValueType, new PulsarColumnMetadata.DecoderExtraInfo(field.name(), null, null))).collect(Collectors.toList());
        }
        catch (StackOverflowError e) {
            log.warn((Throwable)e, "Topic " + topicName.toString() + " extractColumnMetadata failed.");
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Topic " + topicName.toString() + " schema may contains cyclic definitions.", (Throwable)e);
        }
        return columnMetadata;
    }

    private Type parseJsonPrestoType(String fieldName, Schema schema) {
        Schema.Type type = schema.getType();
        LogicalType logicalType = schema.getLogicalType();
        switch (type) {
            case STRING: {
                if (logicalType != null && logicalType.equals(LogicalTypes.uuid())) {
                    return UuidType.UUID;
                }
                return VarcharType.createUnboundedVarcharType();
            }
            case ENUM: {
                return VarcharType.createUnboundedVarcharType();
            }
            case NULL: {
                throw new UnsupportedOperationException(String.format("field '%s' NULL type code should not be reached , please check the schema or report the bug.", fieldName));
            }
            case FIXED: 
            case BYTES: {
                if (logicalType instanceof LogicalTypes.Decimal) {
                    LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                    return DecimalType.createDecimalType((int)decimal.getPrecision(), (int)decimal.getScale());
                }
                return VarbinaryType.VARBINARY;
            }
            case INT: {
                if (logicalType == LogicalTypes.timeMillis()) {
                    return TimeType.TIME_MILLIS;
                }
                if (logicalType == LogicalTypes.date()) {
                    return DateType.DATE;
                }
                return IntegerType.INTEGER;
            }
            case LONG: {
                if (logicalType == LogicalTypes.timestampMillis()) {
                    return TimestampType.TIMESTAMP_MILLIS;
                }
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case ARRAY: {
                return new ArrayType(this.parseJsonPrestoType(fieldName, schema.getElementType()));
            }
            case MAP: {
                TypeSignature valueType = this.parseJsonPrestoType(fieldName, schema.getValueType()).getTypeSignature();
                return this.typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)VarcharType.VARCHAR.getTypeSignature()), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType)));
            }
            case RECORD: {
                if (schema.getFields().size() > 0) {
                    return RowType.from((List)((List)schema.getFields().stream().map(field -> new RowType.Field(Optional.of(field.name()), this.parseJsonPrestoType(field.name(), field.schema()))).collect(ImmutableList.toImmutableList())));
                }
                throw new UnsupportedOperationException(String.format("field '%s' of record type has no fields, please check schema definition. ", fieldName));
            }
            case UNION: {
                for (Schema nestType : schema.getTypes()) {
                    if (nestType.getType() == Schema.Type.NULL) continue;
                    return this.parseJsonPrestoType(fieldName, nestType);
                }
                throw new UnsupportedOperationException(String.format("field '%s' of UNION type must contains not NULL type.", fieldName));
            }
        }
        throw new UnsupportedOperationException(String.format("Can't convert from schema type '%s' (%s) to presto type.", schema.getType(), schema.getFullName()));
    }
}

