/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.airlift.configuration.Config;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.validation.constraints.NotNull;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.shade.javax.ws.rs.client.ClientBuilder;

public class PulsarConnectorConfig
implements AutoCloseable {
    private boolean hasMetadataUrl = false;
    private String brokerServiceUrl = "http://localhost:8080";
    private String brokerBinaryServiceUrl = "pulsar://localhost:6650/";
    private String webServiceUrl = "";
    private String metadataUrl = "zk:localhost:2181";
    private int entryReadBatchSize = 100;
    private int targetNumSplits = 2;
    private int maxSplitMessageQueueSize = 10000;
    private int maxSplitEntryQueueSize = 1000;
    private long maxSplitQueueSizeBytes = -1L;
    private int maxMessageSize = 0x500000;
    private String statsProvider = NullStatsProvider.class.getName();
    private Map<String, String> statsProviderConfigs = new HashMap<String, String>();
    private String authPluginClassName;
    private String authParams;
    private String tlsTrustCertsFilePath;
    private Boolean tlsAllowInsecureConnection;
    private Boolean tlsHostnameVerificationEnable;
    private boolean namespaceDelimiterRewriteEnable = false;
    private String rewriteNamespaceDelimiter = "/";
    private boolean authorizationEnabled = false;
    private String managedLedgerOffloadDriver = null;
    private int managedLedgerOffloadMaxThreads = 2;
    private String offloadersDirectory = "./offloaders";
    private Map<String, String> offloaderProperties = new HashMap<String, String>();
    private boolean exposeTopicLevelMetricsInPrometheus = false;
    private boolean exposeManagedLedgerMetricsInPrometheus = false;
    private int managedLedgerStatsPeriodSeconds = 60;
    private PulsarAdmin pulsarAdmin;
    private int bookkeeperThrottleValue = 0;
    private int bookkeeperNumIOThreads = 2 * Runtime.getRuntime().availableProcessors();
    private int bookkeeperNumWorkerThreads = Runtime.getRuntime().availableProcessors();
    private boolean bookkeeperUseV2Protocol = true;
    private int bookkeeperExplicitInterval = 0;
    private long managedLedgerCacheSizeMB = 0L;
    private int managedLedgerNumSchedulerThreads = Runtime.getRuntime().availableProcessors();
    private String narExtractionDirectory = NarClassLoader.DEFAULT_NAR_EXTRACTION_DIR;

    @NotNull
    public String getBrokerServiceUrl() {
        if (StringUtils.isEmpty((CharSequence)this.webServiceUrl)) {
            return this.brokerServiceUrl;
        }
        return this.getWebServiceUrl();
    }

    @Config(value="pulsar.broker-service-url")
    public PulsarConnectorConfig setBrokerServiceUrl(String brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
        return this;
    }

    public String getBrokerBinaryServiceUrl() {
        return this.brokerBinaryServiceUrl;
    }

    @Config(value="pulsar.broker-binary-service-url")
    public PulsarConnectorConfig setBrokerBinaryServiceUrl(String brokerBinaryServiceUrl) {
        this.brokerBinaryServiceUrl = brokerBinaryServiceUrl;
        return this;
    }

    @Config(value="pulsar.web-service-url")
    public PulsarConnectorConfig setWebServiceUrl(String webServiceUrl) {
        this.webServiceUrl = webServiceUrl;
        return this;
    }

    public String getWebServiceUrl() {
        return this.webServiceUrl;
    }

    @Config(value="pulsar.max-message-size")
    public PulsarConnectorConfig setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Deprecated
    @NotNull
    public String getZookeeperUri() {
        return this.getMetadataUrl();
    }

    @Deprecated
    @Config(value="pulsar.zookeeper-uri")
    public PulsarConnectorConfig setZookeeperUri(String zookeeperUri) {
        if (this.hasMetadataUrl) {
            return this;
        }
        this.metadataUrl = zookeeperUri;
        return this;
    }

    @NotNull
    public String getMetadataUrl() {
        return this.metadataUrl;
    }

    @Config(value="pulsar.metadata-url")
    public PulsarConnectorConfig setMetadataUrl(String metadataUrl) {
        this.hasMetadataUrl = true;
        this.metadataUrl = metadataUrl;
        return this;
    }

    @NotNull
    public int getMaxEntryReadBatchSize() {
        return this.entryReadBatchSize;
    }

    @Config(value="pulsar.max-entry-read-batch-size")
    public PulsarConnectorConfig setMaxEntryReadBatchSize(int batchSize) {
        this.entryReadBatchSize = batchSize;
        return this;
    }

    @NotNull
    public int getTargetNumSplits() {
        return this.targetNumSplits;
    }

    @Config(value="pulsar.target-num-splits")
    public PulsarConnectorConfig setTargetNumSplits(int targetNumSplits) {
        this.targetNumSplits = targetNumSplits;
        return this;
    }

    @NotNull
    public int getMaxSplitMessageQueueSize() {
        return this.maxSplitMessageQueueSize;
    }

    @Config(value="pulsar.max-split-message-queue-size")
    public PulsarConnectorConfig setMaxSplitMessageQueueSize(int maxSplitMessageQueueSize) {
        this.maxSplitMessageQueueSize = maxSplitMessageQueueSize;
        return this;
    }

    @NotNull
    public int getMaxSplitEntryQueueSize() {
        return this.maxSplitEntryQueueSize;
    }

    @Config(value="pulsar.max-split-entry-queue-size")
    public PulsarConnectorConfig setMaxSplitEntryQueueSize(int maxSplitEntryQueueSize) {
        this.maxSplitEntryQueueSize = maxSplitEntryQueueSize;
        return this;
    }

    @NotNull
    public long getMaxSplitQueueSizeBytes() {
        return this.maxSplitQueueSizeBytes;
    }

    @Config(value="pulsar.max-split-queue-cache-size")
    public PulsarConnectorConfig setMaxSplitQueueSizeBytes(long maxSplitQueueSizeBytes) {
        this.maxSplitQueueSizeBytes = maxSplitQueueSizeBytes;
        return this;
    }

    @NotNull
    public String getStatsProvider() {
        return this.statsProvider;
    }

    @Config(value="pulsar.stats-provider")
    public PulsarConnectorConfig setStatsProvider(String statsProvider) {
        this.statsProvider = statsProvider;
        return this;
    }

    @NotNull
    public Map<String, String> getStatsProviderConfigs() {
        return this.statsProviderConfigs;
    }

    @Config(value="pulsar.stats-provider-configs")
    public PulsarConnectorConfig setStatsProviderConfigs(String statsProviderConfigs) throws IOException {
        this.statsProviderConfigs = (Map)new ObjectMapper().readValue(statsProviderConfigs, Map.class);
        return this;
    }

    public String getRewriteNamespaceDelimiter() {
        return this.rewriteNamespaceDelimiter;
    }

    @Config(value="pulsar.rewrite-namespace-delimiter")
    public PulsarConnectorConfig setRewriteNamespaceDelimiter(String rewriteNamespaceDelimiter) {
        Matcher m = NamedEntity.NAMED_ENTITY_PATTERN.matcher(rewriteNamespaceDelimiter);
        if (m.matches()) {
            throw new IllegalArgumentException("Can't use " + rewriteNamespaceDelimiter + "as delimiter, because delimiter must contain characters which name of namespace not allowed");
        }
        this.rewriteNamespaceDelimiter = rewriteNamespaceDelimiter;
        return this;
    }

    public boolean getNamespaceDelimiterRewriteEnable() {
        return this.namespaceDelimiterRewriteEnable;
    }

    @Config(value="pulsar.namespace-delimiter-rewrite-enable")
    public PulsarConnectorConfig setNamespaceDelimiterRewriteEnable(boolean namespaceDelimiterRewriteEnable) {
        this.namespaceDelimiterRewriteEnable = namespaceDelimiterRewriteEnable;
        return this;
    }

    public boolean getAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    @Config(value="pulsar.authorization-enabled")
    public PulsarConnectorConfig setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
        return this;
    }

    public int getManagedLedgerOffloadMaxThreads() {
        return this.managedLedgerOffloadMaxThreads;
    }

    @Config(value="pulsar.managed-ledger-offload-max-threads")
    public PulsarConnectorConfig setManagedLedgerOffloadMaxThreads(int managedLedgerOffloadMaxThreads) throws IOException {
        this.managedLedgerOffloadMaxThreads = managedLedgerOffloadMaxThreads;
        return this;
    }

    public String getManagedLedgerOffloadDriver() {
        return this.managedLedgerOffloadDriver;
    }

    @Config(value="pulsar.managed-ledger-offload-driver")
    public PulsarConnectorConfig setManagedLedgerOffloadDriver(String managedLedgerOffloadDriver) throws IOException {
        this.managedLedgerOffloadDriver = managedLedgerOffloadDriver;
        return this;
    }

    public String getOffloadersDirectory() {
        return this.offloadersDirectory;
    }

    @Config(value="pulsar.offloaders-directory")
    public PulsarConnectorConfig setOffloadersDirectory(String offloadersDirectory) throws IOException {
        this.offloadersDirectory = offloadersDirectory;
        return this;
    }

    public Map<String, String> getOffloaderProperties() {
        return this.offloaderProperties;
    }

    @Config(value="pulsar.offloader-properties")
    public PulsarConnectorConfig setOffloaderProperties(String offloaderProperties) throws IOException {
        this.offloaderProperties = (Map)new ObjectMapper().readValue(offloaderProperties, Map.class);
        return this;
    }

    @Config(value="pulsar.expose-topic-level-metrics-in-prometheus")
    public PulsarConnectorConfig setExposeTopicLevelMetricsInPrometheus(boolean exposeTopicLevelMetricsInPrometheus) {
        this.exposeTopicLevelMetricsInPrometheus = exposeTopicLevelMetricsInPrometheus;
        return this;
    }

    public boolean isExposeTopicLevelMetricsInPrometheus() {
        return this.exposeTopicLevelMetricsInPrometheus;
    }

    @Config(value="pulsar.expose-managed-ledger-metrics-in-prometheus")
    public PulsarConnectorConfig setExposeManagedLedgerMetricsInPrometheus(boolean exposeManagedLedgerMetricsInPrometheus) {
        this.exposeManagedLedgerMetricsInPrometheus = exposeManagedLedgerMetricsInPrometheus;
        return this;
    }

    public boolean isExposeManagedLedgerMetricsInPrometheus() {
        return this.exposeManagedLedgerMetricsInPrometheus;
    }

    @Config(value="pulsar.managed-ledger-stats-period-seconds")
    public PulsarConnectorConfig setManagedLedgerStatsPeriodSeconds(int managedLedgerStatsPeriodSeconds) {
        this.managedLedgerStatsPeriodSeconds = managedLedgerStatsPeriodSeconds;
        return this;
    }

    public int getManagedLedgerStatsPeriodSeconds() {
        return this.managedLedgerStatsPeriodSeconds;
    }

    public String getAuthPlugin() {
        return this.authPluginClassName;
    }

    @Config(value="pulsar.auth-plugin")
    public PulsarConnectorConfig setAuthPlugin(String authPluginClassName) throws IOException {
        this.authPluginClassName = authPluginClassName;
        return this;
    }

    public String getAuthParams() {
        return this.authParams;
    }

    @Config(value="pulsar.auth-params")
    public PulsarConnectorConfig setAuthParams(String authParams) throws IOException {
        this.authParams = authParams;
        return this;
    }

    public Boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    @Config(value="pulsar.tls-allow-insecure-connection")
    public PulsarConnectorConfig setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        return this;
    }

    public Boolean isTlsHostnameVerificationEnable() {
        return this.tlsHostnameVerificationEnable;
    }

    @Config(value="pulsar.tls-hostname-verification-enable")
    public PulsarConnectorConfig setTlsHostnameVerificationEnable(boolean tlsHostnameVerificationEnable) {
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
        return this;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    @Config(value="pulsar.tls-trust-cert-file-path")
    public PulsarConnectorConfig setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        return this;
    }

    public int getBookkeeperThrottleValue() {
        return this.bookkeeperThrottleValue;
    }

    @Config(value="pulsar.bookkeeper-throttle-value")
    public PulsarConnectorConfig setBookkeeperThrottleValue(int bookkeeperThrottleValue) {
        this.bookkeeperThrottleValue = bookkeeperThrottleValue;
        return this;
    }

    public int getBookkeeperNumIOThreads() {
        return this.bookkeeperNumIOThreads;
    }

    @Config(value="pulsar.bookkeeper-num-io-threads")
    public PulsarConnectorConfig setBookkeeperNumIOThreads(int bookkeeperNumIOThreads) {
        this.bookkeeperNumIOThreads = bookkeeperNumIOThreads;
        return this;
    }

    public int getBookkeeperNumWorkerThreads() {
        return this.bookkeeperNumWorkerThreads;
    }

    @Config(value="pulsar.bookkeeper-num-worker-threads")
    public PulsarConnectorConfig setBookkeeperNumWorkerThreads(int bookkeeperNumWorkerThreads) {
        this.bookkeeperNumWorkerThreads = bookkeeperNumWorkerThreads;
        return this;
    }

    public boolean getBookkeeperUseV2Protocol() {
        return this.bookkeeperUseV2Protocol;
    }

    @Config(value="pulsar.bookkeeper-use-v2-protocol")
    public PulsarConnectorConfig setBookkeeperUseV2Protocol(boolean bookkeeperUseV2Protocol) {
        this.bookkeeperUseV2Protocol = bookkeeperUseV2Protocol;
        return this;
    }

    public int getBookkeeperExplicitInterval() {
        return this.bookkeeperExplicitInterval;
    }

    @Config(value="pulsar.bookkeeper-explicit-interval")
    public PulsarConnectorConfig setBookkeeperExplicitInterval(int bookkeeperExplicitInterval) {
        this.bookkeeperExplicitInterval = bookkeeperExplicitInterval;
        return this;
    }

    public long getManagedLedgerCacheSizeMB() {
        return this.managedLedgerCacheSizeMB;
    }

    @Config(value="pulsar.managed-ledger-cache-size-MB")
    public PulsarConnectorConfig setManagedLedgerCacheSizeMB(int managedLedgerCacheSizeMB) {
        this.managedLedgerCacheSizeMB = managedLedgerCacheSizeMB * 1024 * 1024;
        return this;
    }

    public int getManagedLedgerNumSchedulerThreads() {
        return this.managedLedgerNumSchedulerThreads;
    }

    @Config(value="pulsar.managed-ledger-num-scheduler-threads")
    public PulsarConnectorConfig setManagedLedgerNumSchedulerThreads(int managedLedgerNumSchedulerThreads) {
        this.managedLedgerNumSchedulerThreads = managedLedgerNumSchedulerThreads;
        return this;
    }

    public String getNarExtractionDirectory() {
        return this.narExtractionDirectory;
    }

    @Config(value="pulsar.nar-extraction-directory")
    public PulsarConnectorConfig setNarExtractionDirectory(String narExtractionDirectory) {
        this.narExtractionDirectory = narExtractionDirectory;
        return this;
    }

    @NotNull
    public PulsarAdmin getPulsarAdmin() throws PulsarClientException {
        if (this.pulsarAdmin == null) {
            PulsarAdminBuilder builder = PulsarAdmin.builder();
            if (this.getAuthPlugin() != null) {
                builder.authentication(this.getAuthPlugin(), this.getAuthParams());
            }
            if (this.isTlsAllowInsecureConnection() != null) {
                builder.allowTlsInsecureConnection(this.isTlsAllowInsecureConnection().booleanValue());
            }
            if (this.isTlsHostnameVerificationEnable() != null) {
                builder.enableTlsHostnameVerification(this.isTlsHostnameVerificationEnable().booleanValue());
            }
            if (this.getTlsTrustCertsFilePath() != null) {
                builder.tlsTrustCertsFilePath(this.getTlsTrustCertsFilePath());
            }
            builder.setContextClassLoader(ClientBuilder.class.getClassLoader());
            this.pulsarAdmin = builder.serviceHttpUrl(this.getBrokerServiceUrl()).build();
        }
        return this.pulsarAdmin;
    }

    public OffloadPoliciesImpl getOffloadPolices() {
        Properties offloadProperties = new Properties();
        offloadProperties.putAll(this.getOffloaderProperties());
        OffloadPoliciesImpl offloadPolicies = OffloadPoliciesImpl.create((Properties)offloadProperties);
        offloadPolicies.setManagedLedgerOffloadDriver(this.getManagedLedgerOffloadDriver());
        offloadPolicies.setManagedLedgerOffloadMaxThreads(Integer.valueOf(this.getManagedLedgerOffloadMaxThreads()));
        offloadPolicies.setOffloadersDirectory(this.getOffloadersDirectory());
        return offloadPolicies;
    }

    @Override
    public void close() throws Exception {
        this.pulsarAdmin.close();
    }

    public String toString() {
        if (StringUtils.isEmpty((CharSequence)this.webServiceUrl)) {
            return "PulsarConnectorConfig{brokerServiceUrl='" + this.brokerServiceUrl + "'}";
        }
        return "PulsarConnectorConfig{brokerServiceUrl='" + this.webServiceUrl + "'}";
    }
}

