/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderErrorCode;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.json.JsonFieldDecoder;
import io.trino.decoder.json.JsonRowDecoderFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class PulsarJsonFieldDecoder
implements JsonFieldDecoder {
    private final DecoderColumnHandle columnHandle;
    private final long minValue;
    private final long maxValue;
    private static final Logger log = Logger.get(PulsarJsonFieldDecoder.class);

    public PulsarJsonFieldDecoder(DecoderColumnHandle columnHandle) {
        this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
        if (!this.isSupportedType(columnHandle.getType())) {
            JsonRowDecoderFactory.throwUnsupportedColumnType((DecoderColumnHandle)columnHandle);
        }
        Pair<Long, Long> range = PulsarJsonFieldDecoder.getNumRangeByType(columnHandle.getType());
        this.minValue = (Long)range.getKey();
        this.maxValue = (Long)range.getValue();
    }

    private static Pair<Long, Long> getNumRangeByType(Type type) {
        if (type == TinyintType.TINYINT) {
            return Pair.of((Object)-128L, (Object)127L);
        }
        if (type == SmallintType.SMALLINT) {
            return Pair.of((Object)-32768L, (Object)32767L);
        }
        if (type == IntegerType.INTEGER) {
            return Pair.of((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE);
        }
        if (type == BigintType.BIGINT) {
            return Pair.of((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE);
        }
        return Pair.of((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE);
    }

    private boolean isSupportedType(Type type) {
        if (type instanceof DecimalType) {
            return true;
        }
        if (type instanceof VarcharType) {
            return true;
        }
        if (ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)SmallintType.SMALLINT, (Object)TinyintType.TINYINT, (Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE, (Object)TimestampType.TIMESTAMP_MILLIS, (Object)DateType.DATE, (Object)TimeType.TIME_MILLIS, (Object)RealType.REAL, (Object)UuidType.UUID).contains((Object)type)) {
            return true;
        }
        if (type instanceof ArrayType) {
            Preconditions.checkArgument((type.getTypeParameters().size() == 1 ? 1 : 0) != 0, (Object)"expecting exactly one type parameter for array");
            return this.isSupportedType((Type)type.getTypeParameters().get(0));
        }
        if (type instanceof MapType) {
            List typeParameters = type.getTypeParameters();
            Preconditions.checkArgument((typeParameters.size() == 2 ? 1 : 0) != 0, (Object)"expecting exactly two type parameters for map");
            return this.isSupportedType((Type)type.getTypeParameters().get(0)) && this.isSupportedType((Type)type.getTypeParameters().get(1));
        }
        if (type instanceof RowType) {
            for (Type fieldType : type.getTypeParameters()) {
                if (this.isSupportedType(fieldType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public FieldValueProvider decode(JsonNode value) {
        return new JsonValueProvider(value, this.columnHandle, this.minValue, this.maxValue);
    }

    public static class JsonValueProvider
    extends FieldValueProvider {
        private final JsonNode value;
        private final DecoderColumnHandle columnHandle;
        private final long minValue;
        private final long maxValue;

        public JsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle, long minValue, long maxValue) {
            this.value = value;
            this.columnHandle = columnHandle;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public final boolean isNull() {
            return this.value.isMissingNode() || this.value.isNull();
        }

        public boolean getBoolean() {
            return JsonValueProvider.getBoolean(this.value, this.columnHandle.getType(), this.columnHandle.getName());
        }

        public long getLong() {
            return JsonValueProvider.getLong(this.value, this.columnHandle.getType(), this.columnHandle.getName(), this.minValue, this.maxValue);
        }

        public double getDouble() {
            return JsonValueProvider.getDouble(this.value, this.columnHandle.getType(), this.columnHandle.getName());
        }

        public Slice getSlice() {
            return JsonValueProvider.getSlice(this.value, this.columnHandle.getType(), this.columnHandle.getName());
        }

        public Block getBlock() {
            return this.serializeObject(null, this.value, this.columnHandle.getType(), this.columnHandle.getName());
        }

        public static boolean getBoolean(JsonNode value, Type type, String columnName) {
            if (value.isValueNode()) {
                return value.asBoolean();
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse non-value node as '%s' for column '%s'", type, columnName));
        }

        public static long getLong(JsonNode value, Type type, String columnName, long minValue, long maxValue) {
            try {
                if (type instanceof RealType) {
                    return Float.floatToIntBits(Float.parseFloat(value.asText()));
                }
                if (type instanceof DecimalType) {
                    String decimalLong = value.asText().replace(".", "");
                    return Long.parseLong(decimalLong);
                }
                Long longValue = value.isIntegralNumber() && !value.isBigInteger() ? Long.valueOf(value.longValue()) : (value.isValueNode() ? Long.valueOf(Long.parseLong(value.asText())) : null);
                if (longValue != null && longValue >= minValue && longValue <= maxValue) {
                    if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
                        return longValue * 1000L;
                    }
                    if (TimeType.TIME_MILLIS.equals((Object)type)) {
                        return longValue * 1000000000L;
                    }
                    return longValue;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", value.asText(), type, columnName));
        }

        public static double getDouble(JsonNode value, Type type, String columnName) {
            try {
                if (value.isNumber()) {
                    return value.doubleValue();
                }
                if (value.isValueNode()) {
                    return Double.parseDouble(value.asText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", value.asText(), type, columnName));
        }

        private static Slice getSlice(JsonNode value, Type type, String columnName) {
            String textValue = value.isValueNode() ? value.asText() : value.toString();
            Slice slice = Slices.utf8Slice((String)textValue);
            if (type instanceof VarcharType) {
                slice = Varchars.truncateToLength((Slice)slice, (Type)type);
            }
            return slice;
        }

        private Block serializeObject(BlockBuilder builder, Object value, Type type, String columnName) {
            if (type instanceof ArrayType) {
                return this.serializeList(builder, value, type, columnName);
            }
            if (type instanceof MapType) {
                return this.serializeMap(builder, value, type, columnName);
            }
            if (type instanceof RowType) {
                return this.serializeRow(builder, value, type, columnName);
            }
            if (type instanceof DecimalType && !((DecimalType)type).isShort()) {
                return JsonValueProvider.serializeLongDecimal(builder, value, type, columnName);
            }
            this.serializePrimitive(builder, value, type, columnName);
            return null;
        }

        private Block serializeList(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
            if (value == null) {
                Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
                parentBlockBuilder.appendNull();
                return null;
            }
            Preconditions.checkState((boolean)(value instanceof ArrayNode), (Object)"Json array node must is ArrayNode type");
            Iterator jsonNodeIterator = ((ArrayNode)value).elements();
            List typeParameters = type.getTypeParameters();
            Type elementType = (Type)typeParameters.get(0);
            BlockBuilder blockBuilder = elementType.createBlockBuilder(null, ((ArrayNode)value).size());
            while (jsonNodeIterator.hasNext()) {
                Object element = jsonNodeIterator.next();
                this.serializeObject(blockBuilder, element, elementType, columnName);
            }
            if (parentBlockBuilder != null) {
                type.writeObject(parentBlockBuilder, (Object)blockBuilder.build());
                return null;
            }
            return blockBuilder.build();
        }

        private static Block serializeLongDecimal(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
            BlockBuilder blockBuilder = parentBlockBuilder != null ? parentBlockBuilder : type.createBlockBuilder(null, 1);
            assert (value instanceof DecimalNode);
            DecimalNode node = (DecimalNode)value;
            type.writeObject(blockBuilder, (Object)Int128.valueOf((String)node.asText().replace(".", "")));
            if (parentBlockBuilder == null) {
                return blockBuilder.getSingleValueBlock(0);
            }
            return null;
        }

        private void serializePrimitive(BlockBuilder blockBuilder, Object node, Type type, String columnName) {
            Objects.requireNonNull(blockBuilder, "parent blockBuilder is null");
            if (node == null) {
                blockBuilder.appendNull();
                return;
            }
            if (!(node instanceof JsonNode)) {
                throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("primitive object of '%s' as '%s' for column '%s' cann't convert to JsonNode", node.getClass(), type, columnName));
            }
            JsonNode value = (JsonNode)node;
            if (type instanceof BooleanType) {
                type.writeBoolean(blockBuilder, JsonValueProvider.getBoolean(value, type, columnName));
                return;
            }
            if (type instanceof RealType || type instanceof BigintType || type instanceof IntegerType || type instanceof SmallintType || type instanceof TinyintType || type instanceof TimestampType || type instanceof TimeType || type instanceof DateType) {
                Pair<Long, Long> numRange = PulsarJsonFieldDecoder.getNumRangeByType(type);
                type.writeLong(blockBuilder, JsonValueProvider.getLong(value, type, columnName, (Long)numRange.getKey(), (Long)numRange.getValue()));
                return;
            }
            if (type instanceof DoubleType) {
                type.writeDouble(blockBuilder, JsonValueProvider.getDouble(value, type, columnName));
                return;
            }
            if (type instanceof VarcharType || type instanceof VarbinaryType) {
                type.writeSlice(blockBuilder, JsonValueProvider.getSlice(value, type, columnName));
                return;
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
        }

        private Block serializeMap(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
            if (value == null) {
                Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
                parentBlockBuilder.appendNull();
                return null;
            }
            Preconditions.checkState((boolean)(value instanceof ObjectNode), (Object)"Json map node must  is ObjectNode type");
            List typeParameters = type.getTypeParameters();
            Type keyType = (Type)typeParameters.get(0);
            Type valueType = (Type)typeParameters.get(1);
            BlockBuilder blockBuilder = parentBlockBuilder != null ? parentBlockBuilder : type.createBlockBuilder(null, 1);
            BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
            Iterator fields = ((ObjectNode)value).fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                if (entry.getKey() == null) continue;
                keyType.writeSlice(entryBuilder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)entry.getKey().toString()), (Type)keyType));
                this.serializeObject(entryBuilder, entry.getValue(), valueType, columnName);
            }
            blockBuilder.closeEntry();
            if (parentBlockBuilder == null) {
                return (Block)blockBuilder.getObject(0, Block.class);
            }
            return null;
        }

        private Block serializeRow(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
            if (value == null) {
                Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parent block builder is null");
                parentBlockBuilder.appendNull();
                return null;
            }
            BlockBuilder blockBuilder = parentBlockBuilder != null ? parentBlockBuilder : type.createBlockBuilder(null, 1);
            BlockBuilder singleRowBuilder = blockBuilder.beginBlockEntry();
            List fields = ((RowType)type).getFields();
            Preconditions.checkState((boolean)(value instanceof ObjectNode), (Object)"Json row node must be ObjectNode type");
            for (RowType.Field field : fields) {
                Preconditions.checkState((boolean)field.getName().isPresent(), (Object)"field name not found");
                this.serializeObject(singleRowBuilder, ((ObjectNode)value).get((String)field.getName().get()), field.getType(), columnName);
            }
            blockBuilder.closeEntry();
            if (parentBlockBuilder == null) {
                return (Block)blockBuilder.getObject(0, Block.class);
            }
            return null;
        }
    }
}

