/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.messaging;

import java.util.Collection;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.codec.messaging.HeaderType;

public class FastPathHeaderType
implements AMQPType<Header>,
FastPathDescribedTypeConstructor<Header> {
    private static final byte DESCRIPTOR_CODE = 112;
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(112L), Symbol.valueOf("amqp:header:list")};
    private final HeaderType headerType;

    public FastPathHeaderType(EncoderImpl encoder) {
        this.headerType = new HeaderType(encoder);
    }

    public EncoderImpl getEncoder() {
        return this.headerType.getEncoder();
    }

    public DecoderImpl getDecoder() {
        return this.headerType.getDecoder();
    }

    @Override
    public Header readValue() {
        DecoderImpl decoder = this.getDecoder();
        byte typeCode = decoder.getBuffer().get();
        int size = 0;
        int count = 0;
        switch (typeCode) {
            case 69: {
                break;
            }
            case -64: {
                size = decoder.getBuffer().get() & 0xFF;
                count = decoder.getBuffer().get() & 0xFF;
                break;
            }
            case -48: {
                size = decoder.getBuffer().getInt();
                count = decoder.getBuffer().getInt();
                break;
            }
            default: {
                throw new DecodeException("Incorrect type found in Header encoding: " + typeCode);
            }
        }
        Header header = new Header();
        block12: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    header.setDurable(decoder.readBoolean());
                    continue block12;
                }
                case 1: {
                    header.setPriority(decoder.readUnsignedByte());
                    continue block12;
                }
                case 2: {
                    header.setTtl(decoder.readUnsignedInteger());
                    continue block12;
                }
                case 3: {
                    header.setFirstAcquirer(decoder.readBoolean());
                    continue block12;
                }
                case 4: {
                    header.setDeliveryCount(decoder.readUnsignedInteger());
                    continue block12;
                }
                default: {
                    throw new IllegalStateException("To many entries in Header encoding");
                }
            }
        }
        return header;
    }

    @Override
    public void skipValue() {
        this.getDecoder().readConstructor().skipValue();
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    @Override
    public Class<Header> getTypeClass() {
        return Header.class;
    }

    @Override
    public TypeEncoding<Header> getEncoding(Header header) {
        return this.headerType.getEncoding(header);
    }

    @Override
    public TypeEncoding<Header> getCanonicalEncoding() {
        return this.headerType.getCanonicalEncoding();
    }

    @Override
    public Collection<? extends TypeEncoding<Header>> getAllEncodings() {
        return this.headerType.getAllEncodings();
    }

    @Override
    public void write(Header value) {
        WritableBuffer buffer = this.getEncoder().getBuffer();
        int count = this.getElementCount(value);
        byte encodingCode = this.deduceEncodingCode(value, count);
        buffer.put((byte)0);
        buffer.put((byte)83);
        buffer.put((byte)112);
        buffer.put(encodingCode);
        if (encodingCode == 69) {
            return;
        }
        int fieldWidth = encodingCode == -64 ? 1 : 4;
        int startIndex = buffer.position();
        if (fieldWidth == 1) {
            buffer.put((byte)0);
            buffer.put((byte)count);
        } else {
            buffer.putInt(0);
            buffer.putInt(count);
        }
        for (int i = 0; i < count; ++i) {
            this.writeElement(value, i);
        }
        int endIndex = buffer.position();
        int writeSize = endIndex - startIndex - fieldWidth;
        buffer.position(startIndex);
        if (fieldWidth == 1) {
            buffer.put((byte)writeSize);
        } else {
            buffer.putInt(writeSize);
        }
        buffer.position(endIndex);
    }

    private void writeElement(Header header, int index) {
        switch (index) {
            case 0: {
                this.getEncoder().writeBoolean(header.getDurable());
                break;
            }
            case 1: {
                this.getEncoder().writeUnsignedByte(header.getPriority());
                break;
            }
            case 2: {
                this.getEncoder().writeUnsignedInteger(header.getTtl());
                break;
            }
            case 3: {
                this.getEncoder().writeBoolean(header.getFirstAcquirer());
                break;
            }
            case 4: {
                this.getEncoder().writeUnsignedInteger(header.getDeliveryCount());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Header value index: " + index);
            }
        }
    }

    private int getElementCount(Header header) {
        if (header.getDeliveryCount() != null) {
            return 5;
        }
        if (header.getFirstAcquirer() != null) {
            return 4;
        }
        if (header.getTtl() != null) {
            return 3;
        }
        if (header.getPriority() != null) {
            return 2;
        }
        if (header.getDurable() != null) {
            return 1;
        }
        return 0;
    }

    private byte deduceEncodingCode(Header value, int elementCount) {
        if (elementCount == 0) {
            return 69;
        }
        return -64;
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        FastPathHeaderType type = new FastPathHeaderType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }
}

