/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManagedAttributeValue;
import org.apache.qpid.server.model.ManagedAttributeValueTypeDerivedMethod;
import org.apache.qpid.server.model.preferences.GenericPrincipal;
import org.apache.qpid.server.security.QpidPrincipal;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class ConfiguredObjectCustomSerialization {
    private static final Set<String> OBJECT_METHOD_NAMES = Collections.synchronizedSet(new HashSet());
    private static final Map<Class<?>, Converter<?>> REGISTERED_CONVERTERS;
    private static final Map<Class<?>, Converter<?>> REGISTERED_PERSISTENCE_CONVERTERS;
    private static final Converter<Principal> PRINCIPAL_CONVERTER;
    private static final Converter<Certificate> CERTIFICATE_CONVERTER;
    private static final Converter<ConfiguredObject> CONFIGURED_OBJECT_CONVERTER;
    private static final Converter<ManagedAttributeValue> MANAGED_ATTRIBUTE_VALUE_CONVERTER;
    private static final Converter<ManagedAttributeValue> MANAGED_ATTRIBUTE_VALUE_PERSISTENCE_CONVERTER;
    private static final Converter<Content> CONTENT_CONVERTER;

    public static Collection<Converter<?>> getConverters(boolean forPersistence) {
        return forPersistence ? REGISTERED_PERSISTENCE_CONVERTERS.values() : REGISTERED_CONVERTERS.values();
    }

    static {
        for (Method method : Object.class.getMethods()) {
            OBJECT_METHOD_NAMES.add(method.getName());
        }
        REGISTERED_CONVERTERS = new ConcurrentHashMap();
        REGISTERED_PERSISTENCE_CONVERTERS = new ConcurrentHashMap();
        PRINCIPAL_CONVERTER = new AbstractConverter<Principal>(Principal.class){

            @Override
            public Object convert(Principal value) {
                if (value instanceof QpidPrincipal) {
                    return new GenericPrincipal((QpidPrincipal)value).toExternalForm();
                }
                if (value instanceof GenericPrincipal) {
                    return ((GenericPrincipal)value).toExternalForm();
                }
                return value.getName();
            }
        };
        CERTIFICATE_CONVERTER = new AbstractConverter<Certificate>(Certificate.class){

            @Override
            public Object convert(Certificate value) {
                try {
                    return value.getEncoded();
                }
                catch (CertificateEncodingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        CONFIGURED_OBJECT_CONVERTER = new AbstractConverter<ConfiguredObject>(ConfiguredObject.class){

            @Override
            public Object convert(ConfiguredObject value) {
                return value.getId().toString();
            }
        };
        MANAGED_ATTRIBUTE_VALUE_CONVERTER = new ManagedAttributeValueAbstractConverter(true);
        MANAGED_ATTRIBUTE_VALUE_PERSISTENCE_CONVERTER = new ManagedAttributeValueAbstractConverter(false);
        CONTENT_CONVERTER = new ContentConverter();
    }

    public static interface Converter<T> {
        public Class<T> getConversionClass();

        public Object convert(T var1);
    }

    private static class ManagedAttributeValueAbstractConverter
    extends AbstractConverter<ManagedAttributeValue> {
        private final boolean _includeDerivedAttributes;

        public ManagedAttributeValueAbstractConverter(boolean includeDerivedAttributes) {
            super(ManagedAttributeValue.class, includeDerivedAttributes, !includeDerivedAttributes);
            this._includeDerivedAttributes = includeDerivedAttributes;
        }

        @Override
        public Object convert(ManagedAttributeValue value) {
            LinkedHashMap<Object, Object> valueAsMap = new LinkedHashMap<Object, Object>();
            for (Method method : value.getClass().getMethods()) {
                String methodName = method.getName();
                if (method.getParameterTypes().length != 0 || OBJECT_METHOD_NAMES.contains(methodName) || !methodName.startsWith("is") && !methodName.startsWith("has") && !methodName.startsWith("get") || !this._includeDerivedAttributes && this.isDerivedMethod(method)) continue;
                Object propertyName = methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3);
                propertyName = Character.toLowerCase(((String)propertyName).charAt(0)) + ((String)propertyName).substring(1);
                boolean originalAccessible = method.canAccess(value);
                try {
                    Object attrValue;
                    if (!originalAccessible) {
                        method.setAccessible(true);
                    }
                    if ((attrValue = method.invoke((Object)value, new Object[0])) == null) continue;
                    valueAsMap.put(propertyName, attrValue);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new ServerScopedRuntimeException(String.format("Failed to access %s", propertyName), e);
                }
                finally {
                    if (!originalAccessible) {
                        method.setAccessible(originalAccessible);
                    }
                }
            }
            return valueAsMap;
        }

        private boolean isDerivedMethod(Method method) {
            String methodName;
            Class<?> clazz;
            boolean annotationPresent = method.isAnnotationPresent(ManagedAttributeValueTypeDerivedMethod.class);
            if (!annotationPresent && this.isDerivedMethod(clazz = method.getDeclaringClass(), methodName = method.getName())) {
                return true;
            }
            return annotationPresent;
        }

        private boolean isDerivedMethod(Class<?> clazz, String methodName) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != 0) continue;
                if (!method.isAnnotationPresent(ManagedAttributeValueTypeDerivedMethod.class)) break;
                return true;
            }
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                if (!ManagedAttributeValue.class.isAssignableFrom((Class<?>)genericDeclaration) || !this.isDerivedMethod((Class<?>)genericDeclaration, methodName)) continue;
                return true;
            }
            return clazz.getSuperclass() != null && ManagedAttributeValue.class.isAssignableFrom(clazz.getSuperclass()) && this.isDerivedMethod(clazz.getSuperclass(), methodName);
        }
    }

    private static class ContentConverter
    extends AbstractConverter<Content> {
        public ContentConverter() {
            super(Content.class, true, false);
        }

        @Override
        public Object convert(Content content) {
            try {
                byte[] byArray;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    content.write(baos);
                    byArray = baos.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            baos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(String.format("Unexpected failure whilst streaming operation content from content : %s", content));
                    }
                }
                baos.close();
                return byArray;
            }
            finally {
                content.release();
            }
        }
    }

    private static abstract class AbstractConverter<T>
    implements Converter<T> {
        private final Class<T> _conversionClass;

        public AbstractConverter(Class<T> conversionClass) {
            this(conversionClass, true, true);
        }

        public AbstractConverter(Class<T> conversionClass, boolean nonPersistenceConverter, boolean persistenceConverted) {
            if (nonPersistenceConverter) {
                REGISTERED_CONVERTERS.put(conversionClass, this);
            }
            if (persistenceConverted) {
                REGISTERED_PERSISTENCE_CONVERTERS.put(conversionClass, this);
            }
            this._conversionClass = conversionClass;
        }

        @Override
        public final Class<T> getConversionClass() {
            return this._conversionClass;
        }
    }
}

