/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import org.apache.qpid.server.SystemLauncherListener;
import org.apache.qpid.server.configuration.CommonProperties;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.configuration.updater.TaskExecutorImpl;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LoggingMessageLogger;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.plugin.PluggableFactoryLoader;
import org.apache.qpid.server.plugin.SystemConfigFactory;
import org.apache.qpid.server.security.auth.TaskPrincipal;
import org.apache.qpid.server.util.urlstreamhandler.classpath.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemLauncher.class);
    private static final String DEFAULT_INITIAL_PROPERTIES_LOCATION = "classpath:system.properties";
    private static final SystemLauncherListener.DefaultSystemLauncherListener DEFAULT_SYSTEM_LAUNCHER_LISTENER = new SystemLauncherListener.DefaultSystemLauncherListener();
    private EventLogger _eventLogger;
    private final TaskExecutor _taskExecutor = new TaskExecutorImpl();
    private volatile SystemConfig _systemConfig;
    private SystemLauncherListener _listener;
    private final Principal _systemPrincipal = new SystemPrincipal();
    private final Subject _brokerTaskSubject;

    public SystemLauncher(SystemLauncherListener listener) {
        this._listener = listener;
        this._brokerTaskSubject = new Subject(true, new HashSet<Principal>(Arrays.asList(this._systemPrincipal, new TaskPrincipal("Broker"))), Collections.emptySet(), Collections.emptySet());
    }

    public SystemLauncher(SystemLauncherListener ... listeners) {
        this((SystemLauncherListener)new SystemLauncherListener.ChainedSystemLauncherListener(listeners));
    }

    public SystemLauncher() {
        this((SystemLauncherListener)DEFAULT_SYSTEM_LAUNCHER_LISTENER);
    }

    public static void populateSystemPropertiesFromDefaults(String initialProperties) throws IOException {
        Properties props;
        block19: {
            URL initialPropertiesLocation;
            if (initialProperties == null) {
                initialPropertiesLocation = new URL(DEFAULT_INITIAL_PROPERTIES_LOCATION);
            } else {
                try {
                    initialPropertiesLocation = new URL(initialProperties);
                }
                catch (MalformedURLException e) {
                    initialPropertiesLocation = new File(initialProperties).toURI().toURL();
                }
            }
            props = new Properties(CommonProperties.asProperties());
            try {
                InputStream inStream = initialPropertiesLocation.openStream();
                Object object = null;
                try {
                    props.load(inStream);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (inStream != null) {
                        if (object != null) {
                            try {
                                inStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            inStream.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (initialProperties == null) break block19;
                throw e;
            }
        }
        HashSet<String> propertyNames = new HashSet<String>(props.stringPropertyNames());
        propertyNames.removeAll(System.getProperties().stringPropertyNames());
        for (String propName : propertyNames) {
            System.setProperty(propName, props.getProperty(propName));
        }
    }

    public Principal getSystemPrincipal() {
        return this._systemPrincipal;
    }

    public void shutdown() {
        this.shutdown(0);
    }

    public void shutdown(int exitStatusCode) {
        try {
            if (this._systemConfig != null) {
                ListenableFuture<Void> closeResult = this._systemConfig.closeAsync();
                closeResult.get(30000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.warn("Attempting to cleanly shutdown took too long, exiting immediately");
            this._listener.exceptionOnShutdown(e);
        }
        catch (RuntimeException e) {
            this._listener.exceptionOnShutdown(e);
            throw e;
        }
        finally {
            this.cleanUp(exitStatusCode);
        }
    }

    private void cleanUp(int exitStatusCode) {
        this._taskExecutor.stop();
        this._listener.onShutdown(exitStatusCode);
        this._systemConfig = null;
    }

    public void startup(final Map<String, Object> systemConfigAttributes) throws Exception {
        final SystemOutMessageLogger systemOutMessageLogger = new SystemOutMessageLogger();
        this._eventLogger = new EventLogger(systemOutMessageLogger);
        Subject.doAs(this._brokerTaskSubject, new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                SystemLauncher.this._listener.beforeStartup();
                try {
                    SystemLauncher.this.startupImpl(systemConfigAttributes);
                }
                catch (RuntimeException e) {
                    systemOutMessageLogger.message(new SystemStartupMessage(e));
                    LOGGER.error("Exception during startup", (Throwable)e);
                    SystemLauncher.this._listener.errorOnStartup(e);
                    SystemLauncher.this.closeSystemConfigAndCleanUp();
                }
                finally {
                    SystemLauncher.this._listener.afterStartup();
                }
                return null;
            }
        });
    }

    private void startupImpl(Map<String, Object> systemConfigAttributes) throws Exception {
        SystemLauncher.populateSystemPropertiesFromDefaults((String)systemConfigAttributes.get("initialSystemPropertiesLocation"));
        String storeType = (String)systemConfigAttributes.get("type");
        boolean statusUpdatesEnabled = Boolean.parseBoolean(System.getProperty("qpid.broker_status_updates", "true"));
        LoggingMessageLogger messageLogger = new LoggingMessageLogger(statusUpdatesEnabled);
        this._eventLogger.setMessageLogger(messageLogger);
        PluggableFactoryLoader<SystemConfigFactory> configFactoryLoader = new PluggableFactoryLoader<SystemConfigFactory>(SystemConfigFactory.class);
        SystemConfigFactory configFactory = configFactoryLoader.get(storeType);
        if (configFactory == null) {
            LOGGER.error("Unknown config store type '" + storeType + "', only the following types are supported: " + configFactoryLoader.getSupportedTypes());
            throw new IllegalArgumentException("Unknown config store type '" + storeType + "', only the following types are supported: " + configFactoryLoader.getSupportedTypes());
        }
        this._taskExecutor.start();
        this._systemConfig = configFactory.newInstance(this._taskExecutor, this._eventLogger, this._systemPrincipal, systemConfigAttributes);
        this._systemConfig.setOnContainerResolveTask(new Runnable(){

            @Override
            public void run() {
                SystemLauncher.this._listener.onContainerResolve(SystemLauncher.this._systemConfig);
            }
        });
        this._systemConfig.setOnContainerCloseTask(new Runnable(){

            @Override
            public void run() {
                SystemLauncher.this._listener.onContainerClose(SystemLauncher.this._systemConfig);
            }
        });
        this._systemConfig.open();
        if (this._systemConfig.getContainer().getState() == State.ERRORED) {
            throw new RuntimeException("Closing due to errors");
        }
    }

    private void closeSystemConfigAndCleanUp() {
        try {
            if (this._systemConfig != null) {
                try {
                    this._systemConfig.close();
                }
                catch (Exception ce) {
                    LOGGER.debug("An error occurred when closing the system config following initialization failure", (Throwable)ce);
                }
            }
        }
        finally {
            this.cleanUp(1);
        }
    }

    static {
        Handler.register();
    }

    private static class SystemStartupMessage
    implements LogMessage {
        private final RuntimeException _exception;

        public SystemStartupMessage(RuntimeException exception) {
            this._exception = exception;
        }

        @Override
        public String getLogHierarchy() {
            return "system";
        }

        public String toString() {
            StringWriter writer = new StringWriter();
            this._exception.printStackTrace(new PrintWriter(writer));
            return "Exception during startup: \n" + writer.toString();
        }
    }

    private static final class SystemPrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SystemPrincipal() {
        }

        @Override
        public String getName() {
            return "SYSTEM";
        }
    }
}

