/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.filter.SelectorParsingException;

public abstract class UnaryExpression<T>
implements Expression<T> {
    private static final BigDecimal BD_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    private Expression<T> right;

    public static <E> Expression<E> createNegate(Expression<E> left) {
        return new NegativeExpression<E>(left);
    }

    public static <E> BooleanExpression<E> createInExpression(Expression<E> right, List<?> elements, boolean not, boolean allowNonJms) {
        Collection<?> t = elements.size() == 0 ? null : (elements.size() < 5 ? elements : new HashSet(elements));
        List<?> inList = t;
        return new InExpression<E>(right, inList, not, allowNonJms);
    }

    public static <E> BooleanExpression<E> createNOT(BooleanExpression<E> left) {
        return new NotExpression<E>(left);
    }

    public static <E> BooleanExpression<E> createBooleanCast(Expression<E> left) {
        return new BooleanCastExpression<E>(left);
    }

    private static Number negate(Number left) {
        Class<?> clazz = left.getClass();
        if (clazz == Integer.class) {
            return -left.intValue();
        }
        if (clazz == Long.class) {
            return -left.longValue();
        }
        if (clazz == Float.class) {
            return Float.valueOf(-left.floatValue());
        }
        if (clazz == Double.class) {
            return -left.doubleValue();
        }
        if (clazz == BigDecimal.class) {
            BigDecimal bd = (BigDecimal)left;
            if (BD_LONG_MIN_VALUE.compareTo(bd = bd.negate()) == 0) {
                return Long.MIN_VALUE;
            }
            return bd;
        }
        throw new SelectorParsingException("Don't know how to negate: " + left);
    }

    public UnaryExpression(Expression<T> left) {
        this.right = left;
    }

    public Expression<T> getRight() {
        return this.right;
    }

    public String toString() {
        return "(" + this.getExpressionSymbol() + " " + this.right.toString() + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.toString().equals(o.toString());
    }

    public abstract String getExpressionSymbol();

    private static class BooleanCastExpression<E>
    extends BooleanUnaryExpression<E> {
        public BooleanCastExpression(Expression<E> left) {
            super(left);
        }

        @Override
        public Object evaluate(E message) {
            Object rvalue = this.getRight().evaluate(message);
            if (rvalue == null) {
                return null;
            }
            if (!rvalue.getClass().equals(Boolean.class)) {
                return Boolean.FALSE;
            }
            return (Boolean)rvalue != false ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public String toString() {
            return this.getRight().toString();
        }

        @Override
        public String getExpressionSymbol() {
            return "";
        }
    }

    private static class NotExpression<E>
    extends BooleanUnaryExpression<E> {
        public NotExpression(BooleanExpression<E> left) {
            super(left);
        }

        @Override
        public Object evaluate(E message) {
            Boolean lvalue = (Boolean)this.getRight().evaluate(message);
            if (lvalue == null) {
                return null;
            }
            return lvalue != false ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public String getExpressionSymbol() {
            return "NOT";
        }
    }

    private static class InExpression<E>
    extends BooleanUnaryExpression<E> {
        private final Collection<?> _inList;
        private final boolean _not;
        private final boolean _allowNonJms;

        public InExpression(Expression<E> right, Collection<?> inList, boolean not, boolean allowNonJms) {
            super(right);
            this._inList = inList;
            this._not = not;
            this._allowNonJms = allowNonJms;
        }

        @Override
        public Object evaluate(E expression) {
            Object rvalue = this.getRight().evaluate(expression);
            if (rvalue == null || !this._allowNonJms && !(rvalue instanceof String)) {
                return null;
            }
            if ((this._inList != null && this.isInList(rvalue, expression)) ^ this._not) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        private boolean isInList(Object rvalue, E expression) {
            for (Object entry : this._inList) {
                Object listItemValue;
                Object currentRvalue = rvalue;
                Object object = listItemValue = entry instanceof Expression ? ((Expression)entry).evaluate(expression) : entry;
                if (currentRvalue instanceof Enum && listItemValue instanceof String) {
                    listItemValue = this.convertStringToEnumValue(currentRvalue.getClass(), (String)listItemValue);
                }
                if (listItemValue instanceof Enum && currentRvalue instanceof String) {
                    currentRvalue = this.convertStringToEnumValue(listItemValue.getClass(), (String)currentRvalue);
                }
                if (currentRvalue == null && listItemValue == null || currentRvalue != null && currentRvalue.equals(listItemValue)) {
                    return true;
                }
                if (!(currentRvalue instanceof Number) || !(listItemValue instanceof Number)) continue;
                Number num1 = (Number)currentRvalue;
                Number num2 = (Number)listItemValue;
                if (num1.doubleValue() != num2.doubleValue() || num1.longValue() != num2.longValue()) continue;
                return true;
            }
            return false;
        }

        private Object convertStringToEnumValue(Class<?> enumType, String candidateValue) {
            try {
                Class<?> rclazz = enumType;
                return Enum.valueOf(rclazz, candidateValue);
            }
            catch (IllegalArgumentException iae) {
                return candidateValue;
            }
        }

        @Override
        public String toString() {
            StringBuilder answer = new StringBuilder(String.valueOf(this.getRight()));
            answer.append(" ");
            answer.append(this.getExpressionSymbol());
            answer.append(" ( ");
            int count = 0;
            for (Object o : this._inList) {
                if (count != 0) {
                    answer.append(", ");
                }
                answer.append(o);
                ++count;
            }
            answer.append(" )");
            return answer.toString();
        }

        @Override
        public String getExpressionSymbol() {
            if (this._not) {
                return "NOT IN";
            }
            return "IN";
        }
    }

    private static class NegativeExpression<E>
    extends UnaryExpression<E> {
        public NegativeExpression(Expression<E> left) {
            super(left);
        }

        @Override
        public Object evaluate(E message) {
            Object rvalue = this.getRight().evaluate(message);
            if (rvalue == null) {
                return null;
            }
            if (rvalue instanceof Number) {
                return UnaryExpression.negate((Number)rvalue);
            }
            return null;
        }

        @Override
        public String getExpressionSymbol() {
            return "-";
        }
    }

    static abstract class BooleanUnaryExpression<E>
    extends UnaryExpression<E>
    implements BooleanExpression<E> {
        public BooleanUnaryExpression(Expression<E> left) {
            super(left);
        }

        @Override
        public boolean matches(E message) {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }
}

