/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.Model;

public class ConfigurationExtractor {
    private static final Set<String> EXCLUDED_ATTRIBUTES = new HashSet<String>(Arrays.asList("id", "lastUpdatedBy", "lastUpdatedTime", "createdBy", "createdTime"));

    public Map<String, Object> extractConfig(ConfiguredObject<?> object, boolean includeSecure) {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        results.putAll(this.extractAttributeValues(object, includeSecure));
        results.putAll(this.extractChildren(object, includeSecure));
        return results;
    }

    private Map<String, Object> extractAttributeValues(ConfiguredObject<?> object, boolean includeSecure) {
        Model model = object.getModel();
        ConfiguredObjectTypeRegistry typeRegistry = model.getTypeRegistry();
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        HashMap attributeDefinitions = new HashMap();
        for (ConfiguredObjectAttribute<?, ?> configuredObjectAttribute : typeRegistry.getAttributes(object.getClass())) {
            attributeDefinitions.put(configuredObjectAttribute.getName(), configuredObjectAttribute);
        }
        for (Map.Entry entry : object.getActualAttributes().entrySet()) {
            if (EXCLUDED_ATTRIBUTES.contains(entry.getKey())) continue;
            ConfiguredObjectAttribute attributeDefinition = (ConfiguredObjectAttribute)attributeDefinitions.get(entry.getKey());
            if (attributeDefinition.isSecureValue(attributeDefinition.getValue(object))) {
                results.put((String)entry.getKey(), this.extractSecureValue(object, includeSecure, entry, attributeDefinition));
                continue;
            }
            if (ConfiguredObject.class.isAssignableFrom(attributeDefinition.getType())) {
                results.put((String)entry.getKey(), this.extractConfiguredObjectValue((ConfiguredObject)attributeDefinition.getValue(object), entry.getValue()));
                continue;
            }
            if (Collection.class.isAssignableFrom(attributeDefinition.getType()) && entry.getValue() instanceof Collection && this.hasConfiguredObjectTypeArguments(attributeDefinition, 1)) {
                results.put((String)entry.getKey(), this.extractConfiguredObjectCollectionValue(object, entry, attributeDefinition));
                continue;
            }
            if (Map.class.isAssignableFrom(attributeDefinition.getType()) && entry.getValue() instanceof Map && this.hasConfiguredObjectTypeArguments(attributeDefinition, 2)) {
                results.put((String)entry.getKey(), this.extractConfiguredObjectMapValue(object, entry, attributeDefinition));
                continue;
            }
            results.put((String)entry.getKey(), entry.getValue());
        }
        return results;
    }

    private Map extractConfiguredObjectMapValue(ConfiguredObject<?> object, Map.Entry<String, Object> attr, ConfiguredObjectAttribute attributeDefinition) {
        LinkedHashMap mapResults = new LinkedHashMap();
        Map values = (Map)attributeDefinition.getValue(object);
        Iterator valuesIter = values.entrySet().iterator();
        for (Map.Entry attrValue : ((Map)attr.getValue()).entrySet()) {
            Map.Entry obj = valuesIter.next();
            Object key = obj.getKey() instanceof ConfiguredObject ? this.extractConfiguredObjectValue((ConfiguredObject)obj.getKey(), attrValue.getKey()) : attrValue.getKey();
            Object value = obj.getValue() instanceof ConfiguredObject ? this.extractConfiguredObjectValue((ConfiguredObject)obj.getValue(), attrValue.getValue()) : attrValue.getValue();
            mapResults.put(key, value);
        }
        return mapResults;
    }

    private List<Object> extractConfiguredObjectCollectionValue(ConfiguredObject<?> object, Map.Entry<String, Object> attr, ConfiguredObjectAttribute attributeDefinition) {
        ArrayList<Object> listResults = new ArrayList<Object>();
        Collection values = (Collection)attributeDefinition.getValue(object);
        Iterator valuesIter = values.iterator();
        for (Object attrValue : (Collection)attr.getValue()) {
            listResults.add(this.extractConfiguredObjectValue((ConfiguredObject)valuesIter.next(), attrValue));
        }
        return listResults;
    }

    private Object extractConfiguredObjectValue(ConfiguredObject<?> object, Object attrVal) {
        Object value = !(attrVal instanceof String) || object.getId().toString().equals(attrVal) ? object.getName() : attrVal;
        return value;
    }

    private Object extractSecureValue(ConfiguredObject<?> object, boolean includeSecure, Map.Entry<String, Object> attr, ConfiguredObjectAttribute attributeDefinition) {
        Object value = includeSecure ? (attributeDefinition.isSecure() && object.hasEncrypter() ? attributeDefinition.getValue(object) : attr.getValue()) : "********";
        return value;
    }

    private boolean hasConfiguredObjectTypeArguments(ConfiguredObjectAttribute attributeDefinition, int paramCount) {
        if (attributeDefinition.getGenericType() instanceof ParameterizedType && ((ParameterizedType)attributeDefinition.getGenericType()).getActualTypeArguments().length == paramCount) {
            for (int i = 0; i < paramCount; ++i) {
                if (!this.isConfiguredObjectTypeArgument(attributeDefinition, i)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isConfiguredObjectTypeArgument(ConfiguredObjectAttribute attributeDefinition, int paramIndex) {
        return ConfiguredObject.class.isAssignableFrom(this.getTypeParameterClass(attributeDefinition, paramIndex));
    }

    private Class getTypeParameterClass(ConfiguredObjectAttribute attributeDefinition, int paramIndex) {
        Type argType = ((ParameterizedType)attributeDefinition.getGenericType()).getActualTypeArguments()[paramIndex];
        return argType instanceof Class ? (Class)argType : (Class)((ParameterizedType)argType).getRawType();
    }

    private Map<String, Object> extractChildren(ConfiguredObject<?> object, boolean includeSecure) {
        Model model = object.getModel();
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        if (!object.getCategoryClass().getAnnotation(ManagedObject.class).managesChildren() && !object.getTypeClass().getAnnotation(ManagedObject.class).managesChildren()) {
            for (Class<? extends ConfiguredObject> childClass : model.getChildTypes(object.getCategoryClass())) {
                Class<? extends ConfiguredObject> parentClass = model.getParentType(childClass);
                if (!parentClass.equals(object.getCategoryClass())) continue;
                ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
                for (ConfiguredObject configuredObject : object.getChildren(childClass)) {
                    if (!configuredObject.isDurable()) continue;
                    children.add(this.extractConfig(configuredObject, includeSecure));
                }
                if (children.isEmpty()) continue;
                String singularName = childClass.getSimpleName().toLowerCase();
                String string = singularName + (singularName.endsWith("s") ? "es" : "s");
                results.put(string, children);
            }
        }
        return results;
    }
}

