/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;

@ManagedObject(creatable=false, amqpName="org.apache.qpid.Consumer")
public interface Consumer<X extends Consumer<X, T>, T extends ConsumerTarget>
extends ConfiguredObject<X>,
MessageInstanceConsumer<T> {
    public static final String DISTRIBUTION_MODE = "distributionMode";
    public static final String EXCLUSIVE = "exclusive";
    public static final String NO_LOCAL = "noLocal";
    public static final String SELECTOR = "selector";
    public static final String SETTLEMENT_MODE = "settlementMode";
    public static final String PRIORITY = "priority";
    public static final String SUSPEND_NOTIFICATION_PERIOD = "consumer.suspendNotificationPeriod";
    @ManagedContextDefault(name="consumer.suspendNotificationPeriod")
    public static final long SUSPEND_NOTIFICATION_PERIOD_DEFAULT = 10000L;
    public static final AtomicLong CONSUMER_NUMBER_GENERATOR = new AtomicLong(0L);

    @DerivedAttribute
    public String getLinkName();

    @DerivedAttribute
    public Session<?> getSession();

    @ManagedAttribute(immutable=true)
    public String getDistributionMode();

    @ManagedAttribute(immutable=true)
    public String getSettlementMode();

    @ManagedAttribute(immutable=true)
    public boolean isExclusive();

    @ManagedAttribute(immutable=true)
    public boolean isNoLocal();

    @ManagedAttribute(immutable=true)
    public String getSelector();

    @ManagedAttribute(defaultValue="2147483647", description="Number representing the priority of the consumer versus other consumers.  Priority 2147483647 is the highest priority.")
    public int getPriority();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Outbound")
    public long getBytesOut();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Outbound")
    public long getMessagesOut();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Prefetch")
    public long getUnacknowledgedBytes();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Prefetch")
    public long getUnacknowledgedMessages();

    public long getConsumerNumber();

    public boolean isSuspended();

    public boolean seesRequeues();

    public boolean isActive();
}

