/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.server.model.OperationParameter;

public class OperationParameterFromInjection
implements OperationParameter {
    private final Class<?> _type;
    private final Type _genericType;
    private final String _name;
    private final String _defaultValue;
    private final String _description;
    private final List<String> _validValues;
    private final boolean _mandatory;

    public OperationParameterFromInjection(String name, Class<?> type, Type genericType, String defaultValue, String description, String[] validValues, boolean mandatory) {
        this._type = type;
        this._genericType = genericType;
        this._name = name;
        this._defaultValue = defaultValue;
        this._description = description;
        this._mandatory = mandatory;
        this._validValues = validValues == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(validValues));
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDefaultValue() {
        return this._defaultValue;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public List<String> getValidValues() {
        return this._validValues;
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    @Override
    public Type getGenericType() {
        return this._genericType;
    }

    @Override
    public boolean isMandatory() {
        return this._mandatory || this._type.isPrimitive();
    }

    @Override
    public boolean isCompatible(OperationParameter that) {
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null) {
            return false;
        }
        return !(this.getGenericType() == null ? that.getGenericType() != null : !this.getGenericType().equals(that.getGenericType()));
    }
}

