/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.math.BigDecimal;
import java.util.Collection;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.AMQTypedValue;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.FieldArray;
import org.apache.qpid.server.protocol.v0_8.FieldTable;

public enum AMQType {
    LONG_STRING('S'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongStringLength((String)value);
        }

        @Override
        public String toNativeValue(Object value) {
            if (value != null) {
                return value.toString();
            }
            throw new NullPointerException("Cannot convert: null to String.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            EncodingUtils.writeLongStringBytes(buffer, (String)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return EncodingUtils.readLongString(buffer);
        }
    }
    ,
    INTEGER('i'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.unsignedIntegerLength();
        }

        @Override
        public Long toNativeValue(Object value) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            if (value instanceof Short) {
                return ((Short)value).longValue();
            }
            if (value instanceof Byte) {
                return ((Byte)value).longValue();
            }
            if (value instanceof String || value == null) {
                return Long.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to int.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            buffer.putLong((Long)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return buffer.getUnsignedInt();
        }
    }
    ,
    DECIMAL('D'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedByteLength() + EncodingUtils.encodedIntegerLength();
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to BigDecimal.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            BigDecimal bd = (BigDecimal)value;
            byte places = new Integer(bd.scale()).byteValue();
            int unscaled = bd.intValue();
            buffer.put(places);
            buffer.putInt(unscaled);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            byte places = buffer.get();
            int unscaled = buffer.getInt();
            BigDecimal bd = new BigDecimal(unscaled);
            return bd.setScale(places);
        }
    }
    ,
    TIMESTAMP('T'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongLength();
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value instanceof Long) {
                return (Long)value;
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to timestamp.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            buffer.putLong((Long)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return buffer.getLong();
        }
    }
    ,
    FIELD_TABLE('F'){

        @Override
        public int getEncodingSize(Object value) {
            if (!(value instanceof FieldTable)) {
                throw new IllegalArgumentException("Value is not a FieldTable.");
            }
            FieldTable ftValue = (FieldTable)value;
            return EncodingUtils.encodedFieldTableLength(ftValue);
        }

        @Override
        public Object toNativeValue(Object value) {
            if (!(value instanceof FieldTable)) {
                throw new IllegalArgumentException("Value is not a FieldTable.");
            }
            return (FieldTable)value;
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            if (!(value instanceof FieldTable)) {
                throw new IllegalArgumentException("Value is not a FieldTable.");
            }
            FieldTable ftValue = (FieldTable)value;
            ftValue.writeToBuffer(buffer);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            try {
                return EncodingUtils.readFieldTable(buffer);
            }
            catch (AMQFrameDecodingException e) {
                throw new IllegalArgumentException("Unable to read field table from buffer.", e);
            }
        }
    }
    ,
    FIELD_ARRAY('A'){

        @Override
        public int getEncodingSize(Object value) {
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException("Value is not a Collection.");
            }
            FieldArray fieldArrayValue = FieldArray.asFieldArray((Collection)value);
            return 4 + fieldArrayValue.getEncodingSize();
        }

        @Override
        public Object toNativeValue(Object value) {
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException("Value cannot be converted to a FieldArray.");
            }
            return FieldArray.asFieldArray((Collection)value);
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            if (!(value instanceof FieldArray)) {
                throw new IllegalArgumentException("Value is not a FieldArray.");
            }
            FieldArray fieldArrayValue = (FieldArray)value;
            fieldArrayValue.writeToBuffer(buffer);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return FieldArray.readFromBuffer(buffer);
        }
    }
    ,
    VOID('V'){

        @Override
        public int getEncodingSize(Object value) {
            return 0;
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value == null) {
                return null;
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to null String.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return null;
        }
    }
    ,
    BINARY('x'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongstrLength((byte[])value);
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value instanceof byte[] || value == null) {
                return value;
            }
            throw new IllegalArgumentException("Value: " + value + " (" + value.getClass().getName() + ") cannot be converted to byte[]");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            EncodingUtils.writeLongstr(buffer, (byte[])value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return EncodingUtils.readLongstr(buffer);
        }
    }
    ,
    ASCII_STRING('c'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongStringLength((String)value);
        }

        @Override
        public String toNativeValue(Object value) {
            if (value != null) {
                return value.toString();
            }
            throw new NullPointerException("Cannot convert: null to String.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            EncodingUtils.writeLongStringBytes(buffer, (String)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return EncodingUtils.readLongString(buffer);
        }
    }
    ,
    WIDE_STRING('C'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongStringLength((String)value);
        }

        @Override
        public String toNativeValue(Object value) {
            if (value != null) {
                return value.toString();
            }
            throw new NullPointerException("Cannot convert: null to String.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            EncodingUtils.writeLongStringBytes(buffer, (String)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return EncodingUtils.readLongString(buffer);
        }
    }
    ,
    BOOLEAN('t'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedBooleanLength();
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String || value == null) {
                return Boolean.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to boolean.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            EncodingUtils.writeBoolean(buffer, (Boolean)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return buffer.get() == 1;
        }
    }
    ,
    ASCII_CHARACTER('k'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedCharLength();
        }

        @Override
        public Character toNativeValue(Object value) {
            if (value instanceof Character) {
                return (Character)value;
            }
            if (value == null) {
                throw new NullPointerException("Cannot convert null into char");
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to char.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            char charVal = ((Character)value).charValue();
            buffer.put((byte)charVal);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return Character.valueOf((char)buffer.get());
        }
    }
    ,
    BYTE('b'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedByteLength();
        }

        @Override
        public Byte toNativeValue(Object value) {
            if (value instanceof Byte) {
                return (Byte)value;
            }
            if (value instanceof String || value == null) {
                return Byte.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to byte.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            buffer.put((Byte)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return buffer.get();
        }
    }
    ,
    UNSIGNED_BYTE('B'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedByteLength();
        }

        @Override
        public Short toNativeValue(Object value) {
            if (value == null) {
                throw new NullPointerException("Cannot convert null into unsigned byte");
            }
            if (value instanceof Short) {
                return (Short)value;
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof String) {
                return Short.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to unsigned byte.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            buffer.putUnsignedByte((Short)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return buffer.getUnsignedByte();
        }
    }
    ,
    SHORT('s'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedShortLength();
        }

        @Override
        public Short toNativeValue(Object value) {
            if (value instanceof Short) {
                return (Short)value;
            }
            if (value instanceof Byte) {
                return ((Byte)value).shortValue();
            }
            if (value instanceof String || value == null) {
                return Short.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to short.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            buffer.putShort((Short)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return buffer.getShort();
        }
    }
    ,
    UNSIGNED_SHORT('u'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedShortLength();
        }

        @Override
        public Integer toNativeValue(Object value) {
            if (value == null) {
                throw new NullPointerException("Cannot convert null into unsigned short");
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return Integer.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to unsigned short.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            buffer.putUnsignedShort((Integer)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return buffer.getUnsignedShort();
        }
    }
    ,
    INT('I'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedIntegerLength();
        }

        @Override
        public Integer toNativeValue(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Short) {
                return ((Short)value).intValue();
            }
            if (value instanceof Byte) {
                return ((Byte)value).intValue();
            }
            if (value instanceof String || value == null) {
                return Integer.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to int.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            buffer.putInt((Integer)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return buffer.getInt();
        }
    }
    ,
    LONG('l'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongLength();
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            if (value instanceof Short) {
                return ((Short)value).longValue();
            }
            if (value instanceof Byte) {
                return ((Byte)value).longValue();
            }
            if (value instanceof String || value == null) {
                return Long.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to long.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            buffer.putLong((Long)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return buffer.getLong();
        }
    }
    ,
    FLOAT('f'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedFloatLength();
        }

        @Override
        public Float toNativeValue(Object value) {
            if (value instanceof Float) {
                return (Float)value;
            }
            if (value instanceof String || value == null) {
                return Float.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to float.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            buffer.putFloat(((Float)value).floatValue());
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return Float.valueOf(buffer.getFloat());
        }
    }
    ,
    DOUBLE('d'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedDoubleLength();
        }

        @Override
        public Double toNativeValue(Object value) {
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Float) {
                return ((Float)value).doubleValue();
            }
            if (value instanceof String || value == null) {
                return Double.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to double.");
        }

        @Override
        public void writeValueImpl(Object value, QpidByteBuffer buffer) {
            buffer.putDouble((Double)value);
        }

        @Override
        public Object readValueFromBuffer(QpidByteBuffer buffer) {
            return buffer.getDouble();
        }
    };

    private final byte _identifier;

    private AMQType(char identifier) {
        this._identifier = (byte)identifier;
    }

    public final byte identifier() {
        return this._identifier;
    }

    public abstract int getEncodingSize(Object var1);

    public abstract Object toNativeValue(Object var1);

    public AMQTypedValue asTypedValue(Object value) {
        return AMQTypedValue.createAMQTypedValue(this, this.toNativeValue(value));
    }

    public void writeToBuffer(Object value, QpidByteBuffer buffer) {
        buffer.put(this.identifier());
        this.writeValueImpl(value, buffer);
    }

    abstract void writeValueImpl(Object var1, QpidByteBuffer var2);

    abstract Object readValueFromBuffer(QpidByteBuffer var1);
}

