/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class QueueStatistics {
    private final AtomicInteger _queueCount = new AtomicInteger();
    private final AtomicLong _queueSize = new AtomicLong();
    private final AtomicInteger _unackedCount = new AtomicInteger();
    private final AtomicLong _unackedSize = new AtomicLong();
    private final AtomicInteger _availableCount = new AtomicInteger();
    private final AtomicLong _availableSize = new AtomicLong();
    private final AtomicLong _dequeueCount = new AtomicLong();
    private final AtomicLong _dequeueSize = new AtomicLong();
    private final AtomicLong _enqueueCount = new AtomicLong();
    private final AtomicLong _enqueueSize = new AtomicLong();
    private final AtomicLong _persistentEnqueueCount = new AtomicLong();
    private final AtomicLong _persistentEnqueueSize = new AtomicLong();
    private final AtomicLong _persistentDequeueCount = new AtomicLong();
    private final AtomicLong _persistentDequeueSize = new AtomicLong();
    private final AtomicInteger _queueCountHwm = new AtomicInteger();
    private final AtomicLong _queueSizeHwm = new AtomicLong();
    private final AtomicInteger _availableCountHwm = new AtomicInteger();
    private final AtomicLong _availableSizeHwm = new AtomicLong();
    private final AtomicInteger _expiredCount = new AtomicInteger();
    private final AtomicLong _expiredSize = new AtomicLong();

    QueueStatistics() {
    }

    public final int getQueueCount() {
        return this._queueCount.get();
    }

    public final long getQueueSize() {
        return this._queueSize.get();
    }

    public final int getUnackedCount() {
        return this._unackedCount.get();
    }

    public final long getUnackedSize() {
        return this._unackedSize.get();
    }

    public final int getAvailableCount() {
        return this._availableCount.get();
    }

    public final long getAvailableSize() {
        return this._availableSize.get();
    }

    public final long getEnqueueCount() {
        return this._enqueueCount.get();
    }

    public final long getEnqueueSize() {
        return this._enqueueSize.get();
    }

    public final long getDequeueCount() {
        return this._dequeueCount.get();
    }

    public final long getDequeueSize() {
        return this._dequeueSize.get();
    }

    public final long getPersistentEnqueueCount() {
        return this._persistentEnqueueCount.get();
    }

    public final long getPersistentEnqueueSize() {
        return this._persistentEnqueueSize.get();
    }

    public final long getPersistentDequeueCount() {
        return this._persistentDequeueCount.get();
    }

    public final long getPersistentDequeueSize() {
        return this._persistentDequeueSize.get();
    }

    public final int getQueueCountHwm() {
        return this._queueCountHwm.get();
    }

    public final long getQueueSizeHwm() {
        return this._queueSizeHwm.get();
    }

    public final int getAvailableCountHwm() {
        return this._availableCountHwm.get();
    }

    public final long getAvailableSizeHwm() {
        return this._availableSizeHwm.get();
    }

    public int getExpiredCount() {
        return this._expiredCount.get();
    }

    public long getExpiredSize() {
        return this._expiredSize.get();
    }

    void addToQueue(long size) {
        long sizeHwm;
        int hwm;
        int count = this._queueCount.incrementAndGet();
        long queueSize = this._queueSize.addAndGet(size);
        while ((hwm = this._queueCountHwm.get()) < count) {
            this._queueCountHwm.compareAndSet(hwm, count);
        }
        while ((sizeHwm = this._queueSizeHwm.get()) < queueSize) {
            this._queueSizeHwm.compareAndSet(sizeHwm, queueSize);
        }
    }

    void removeFromQueue(long size) {
        this._queueCount.decrementAndGet();
        this._queueSize.addAndGet(-size);
    }

    void addToAvailable(long size) {
        long sizeHwm;
        int hwm;
        int count = this._availableCount.incrementAndGet();
        long availableSize = this._availableSize.addAndGet(size);
        while ((hwm = this._availableCountHwm.get()) < count) {
            this._availableCountHwm.compareAndSet(hwm, count);
        }
        while ((sizeHwm = this._availableSizeHwm.get()) < availableSize) {
            this._availableSizeHwm.compareAndSet(sizeHwm, availableSize);
        }
    }

    void removeFromAvailable(long size) {
        this._availableCount.decrementAndGet();
        this._availableSize.addAndGet(-size);
    }

    void addToUnacknowledged(long size) {
        this._unackedCount.incrementAndGet();
        this._unackedSize.addAndGet(size);
    }

    void removeFromUnacknowledged(long size) {
        this._unackedCount.decrementAndGet();
        this._unackedSize.addAndGet(-size);
    }

    void addToEnqueued(long size) {
        this._enqueueCount.incrementAndGet();
        this._enqueueSize.addAndGet(size);
    }

    void addToDequeued(long size) {
        this._dequeueCount.incrementAndGet();
        this._dequeueSize.addAndGet(size);
    }

    void addToPersistentEnqueued(long size) {
        this._persistentEnqueueCount.incrementAndGet();
        this._persistentEnqueueSize.addAndGet(size);
    }

    void addToPersistentDequeued(long size) {
        this._persistentDequeueCount.incrementAndGet();
        this._persistentDequeueSize.addAndGet(size);
    }

    void addToExpired(long size) {
        this._expiredCount.incrementAndGet();
        this._expiredSize.addAndGet(size);
    }
}

