/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.OverflowPolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.MessageUnacceptableException;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoredMessage;

public class RejectPolicyHandler {
    private final Handler _handler;

    RejectPolicyHandler(Queue<?> queue) {
        this._handler = new Handler(queue);
        this.addMessageDeleteListener();
        queue.addChangeListener(this._handler);
    }

    void messageDeleted(StoredMessage storedMessage) {
        this._handler.messageDeleted(storedMessage);
    }

    void checkReject(ServerMessage<?> newMessage) throws MessageUnacceptableException {
        this._handler.checkReject(newMessage);
    }

    void postEnqueue(MessageInstance instance) {
        this._handler.postEnqueue(instance);
    }

    private void addMessageDeleteListener() {
        MessageStore messageStore = this._handler.getMessageStore();
        if (messageStore != null) {
            messageStore.addMessageDeleteListener(this._handler);
        }
    }

    private static class Handler
    extends AbstractConfigurationChangeListener
    implements MessageStore.MessageDeleteListener {
        private final Queue<?> _queue;
        private final AtomicLong _pendingDepthBytes = new AtomicLong();
        private final AtomicInteger _pendingDepthMessages = new AtomicInteger();
        private final Map<StoredMessage<?>, Long> _pendingMessages = new ConcurrentHashMap();

        private Handler(Queue<?> queue) {
            this._queue = queue;
        }

        @Override
        public void messageDeleted(StoredMessage<?> m) {
            this.decrementPendingCountersIfNecessary(m);
        }

        @Override
        public void bulkChangeEnd(ConfiguredObject<?> object) {
            super.bulkChangeEnd(object);
            if (this._queue.getOverflowPolicy() != OverflowPolicy.REJECT) {
                this._queue.removeChangeListener(this);
                MessageStore messageStore = this.getMessageStore();
                if (messageStore != null) {
                    messageStore.removeMessageDeleteListener(this);
                }
            }
        }

        private void checkReject(ServerMessage<?> newMessage) throws MessageUnacceptableException {
            boolean bytesOverflow;
            long maximumQueueDepthMessages = this._queue.getMaximumQueueDepthMessages();
            long maximumQueueDepthBytes = this._queue.getMaximumQueueDepthBytes();
            int queueDepthMessages = this._queue.getQueueDepthMessages();
            long queueDepthBytes = this._queue.getQueueDepthBytes();
            int pendingMessages = this._pendingDepthMessages.addAndGet(1);
            long pendingBytes = this._pendingDepthBytes.addAndGet(newMessage.getSizeIncludingHeader());
            boolean messagesOverflow = maximumQueueDepthMessages >= 0L && (long)(queueDepthMessages + pendingMessages) > maximumQueueDepthMessages;
            boolean bl = bytesOverflow = maximumQueueDepthBytes >= 0L && queueDepthBytes + pendingBytes > maximumQueueDepthBytes;
            if (bytesOverflow || messagesOverflow) {
                long depthBytesDelta = -newMessage.getSizeIncludingHeader();
                this._pendingDepthBytes.addAndGet(-depthBytesDelta);
                this._pendingDepthMessages.addAndGet(-1);
                String message = String.format("Maximum depth exceeded on '%s' : current=[count: %d, size: %d], max=[count: %d, size: %d]", this._queue.getName(), queueDepthMessages + pendingMessages, queueDepthBytes + pendingBytes, maximumQueueDepthMessages, maximumQueueDepthBytes);
                throw new MessageUnacceptableException(message);
            }
            this._pendingMessages.put(newMessage.getStoredMessage(), newMessage.getSizeIncludingHeader());
        }

        private void postEnqueue(MessageInstance instance) {
            this.decrementPendingCountersIfNecessary(instance.getMessage().getStoredMessage());
        }

        private void decrementPendingCountersIfNecessary(StoredMessage<?> m) {
            Long size = this._pendingMessages.remove(m);
            if (size != null) {
                this._pendingDepthBytes.addAndGet(-size.longValue());
                this._pendingDepthMessages.addAndGet(-1);
            }
        }

        private MessageStore getMessageStore() {
            return this._queue.getVirtualHost().getMessageStore();
        }
    }
}

