/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AbstractTrustStore;
import org.apache.qpid.server.security.CertificateDetails;
import org.apache.qpid.server.security.ManagedPeerCertificateTrustStore;
import org.apache.qpid.server.transport.network.security.ssl.QpidMultipleTrustManager;
import org.apache.qpid.server.transport.network.security.ssl.QpidPeersOnlyTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false)
public class ManagedPeerCertificateTrustStoreImpl
extends AbstractTrustStore<ManagedPeerCertificateTrustStoreImpl>
implements ManagedPeerCertificateTrustStore<ManagedPeerCertificateTrustStoreImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedPeerCertificateTrustStoreImpl.class);
    private volatile TrustManager[] _trustManagers = new TrustManager[0];
    @ManagedAttributeField(afterSet="updateTrustManagers")
    private final List<Certificate> _storedCertificates = new ArrayList<Certificate>();

    @ManagedObjectFactoryConstructor
    public ManagedPeerCertificateTrustStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    protected TrustManager[] getTrustManagersInternal() {
        TrustManager[] trustManagers = this._trustManagers;
        if (trustManagers == null || trustManagers.length == 0) {
            throw new IllegalStateException("Truststore " + this + " defines no trust managers");
        }
        return Arrays.copyOf(trustManagers, trustManagers.length);
    }

    @Override
    public Certificate[] getCertificates() {
        ArrayList<Certificate> storedCertificates = new ArrayList<Certificate>(this._storedCertificates);
        return storedCertificates.toArray(new Certificate[storedCertificates.size()]);
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        return this.deleteIfNotInUse();
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> doActivate() {
        this.initializeExpiryChecking();
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    private void updateTrustManagers() {
        try {
            TrustManager[] delegateManagers;
            KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inMemoryKeyStore.load(null, null);
            int i = 1;
            for (Certificate cert : this._storedCertificates) {
                inMemoryKeyStore.setCertificateEntry(String.valueOf(i++), cert);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(inMemoryKeyStore);
            ArrayList<TrustManager> trustManagersCol = new ArrayList<TrustManager>();
            QpidMultipleTrustManager mulTrustManager = new QpidMultipleTrustManager();
            for (TrustManager tm : delegateManagers = tmf.getTrustManagers()) {
                if (tm instanceof X509TrustManager) {
                    mulTrustManager.addTrustManager(new QpidPeersOnlyTrustManager(inMemoryKeyStore, (X509TrustManager)tm));
                    continue;
                }
                trustManagersCol.add(tm);
            }
            if (!mulTrustManager.isEmpty()) {
                trustManagersCol.add(mulTrustManager);
            }
            this._trustManagers = trustManagersCol.isEmpty() ? null : trustManagersCol.toArray(new TrustManager[trustManagersCol.size()]);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException("Cannot load certificate(s) :" + e, e);
        }
    }

    @Override
    public List<Certificate> getStoredCertificates() {
        return this._storedCertificates;
    }

    @Override
    public void addCertificate(Certificate cert) {
        LinkedHashSet<Certificate> certificates = new LinkedHashSet<Certificate>(this._storedCertificates);
        if (certificates.add(cert)) {
            this.setAttributes(Collections.singletonMap("storedCertificates", certificates));
        }
    }

    @Override
    public void removeCertificates(List<CertificateDetails> certs) {
        HashMap certsToRemove = new HashMap();
        for (CertificateDetails cert : certs) {
            if (!certsToRemove.containsKey(cert.getIssuerName())) {
                certsToRemove.put(cert.getIssuerName(), new HashSet());
            }
            ((Set)certsToRemove.get(cert.getIssuerName())).add(new BigInteger(cert.getSerialNumber()));
        }
        boolean updated = false;
        LinkedHashSet<Certificate> currentCerts = new LinkedHashSet<Certificate>(this._storedCertificates);
        Iterator iter = currentCerts.iterator();
        while (iter.hasNext()) {
            X509Certificate x509Certificate;
            String issuerName;
            Certificate cert = (Certificate)iter.next();
            if (!(cert instanceof X509Certificate) || !certsToRemove.containsKey(issuerName = (x509Certificate = (X509Certificate)cert).getIssuerX500Principal().getName()) || !((Set)certsToRemove.get(issuerName)).contains(x509Certificate.getSerialNumber())) continue;
            iter.remove();
            updated = true;
        }
        if (updated) {
            this.setAttributes(Collections.singletonMap("storedCertificates", currentCerts));
        }
    }
}

