/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.messages.AuthenticationProviderMessages;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;

public class SubjectCreator {
    private final NamedAddressSpace _addressSpace;
    private AuthenticationProvider<?> _authenticationProvider;
    private Collection<GroupProvider<?>> _groupProviders;

    public SubjectCreator(AuthenticationProvider<?> authenticationProvider, Collection<GroupProvider<?>> groupProviders, NamedAddressSpace addressSpace) {
        this._authenticationProvider = authenticationProvider;
        this._groupProviders = groupProviders;
        this._addressSpace = addressSpace;
    }

    public AuthenticationProvider<?> getAuthenticationProvider() {
        return this._authenticationProvider;
    }

    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings) {
        return this._authenticationProvider.createSaslNegotiator(mechanism, saslSettings, this._addressSpace);
    }

    public SubjectAuthenticationResult authenticate(SaslNegotiator saslNegotiator, byte[] response) {
        AuthenticationResult authenticationResult = saslNegotiator.handleResponse(response);
        if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
            return this.createResultWithGroups(authenticationResult);
        }
        if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.ERROR) {
            String authenticationId = saslNegotiator.getAttemptedAuthenticationId();
            this._authenticationProvider.getEventLogger().message(AuthenticationProviderMessages.AUTHENTICATION_FAILED(authenticationId, authenticationId != null));
        }
        return new SubjectAuthenticationResult(authenticationResult);
    }

    public SubjectAuthenticationResult createResultWithGroups(AuthenticationResult authenticationResult) {
        if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
            Subject authenticationSubject = new Subject();
            authenticationSubject.getPrincipals().addAll(authenticationResult.getPrincipals());
            Set<Principal> groupPrincipals = this.getGroupPrincipals(authenticationResult.getMainPrincipal());
            authenticationSubject.getPrincipals().addAll(groupPrincipals);
            authenticationSubject.setReadOnly();
            return new SubjectAuthenticationResult(authenticationResult, authenticationSubject);
        }
        return new SubjectAuthenticationResult(authenticationResult);
    }

    public Subject createSubjectWithGroups(Principal userPrincipal) {
        Subject authenticationSubject = new Subject();
        authenticationSubject.getPrincipals().add(userPrincipal);
        authenticationSubject.getPrincipals().addAll(this.getGroupPrincipals(userPrincipal));
        authenticationSubject.setReadOnly();
        return authenticationSubject;
    }

    Set<Principal> getGroupPrincipals(Principal userPrincipal) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (GroupProvider<?> groupProvider : this._groupProviders) {
            Set<Principal> groups = groupProvider.getGroupPrincipalsForUser(userPrincipal);
            if (groups == null) continue;
            principals.addAll(groups);
        }
        return Collections.unmodifiableSet(principals);
    }
}

