/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.consumer.ConsumerOption;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.virtualhost.AbstractSystemMessageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustStoreMessageSource
extends AbstractSystemMessageSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustStoreMessageSource.class);
    private final TrustStore<?> _trustStore;
    private final AtomicReference<Set<Certificate>> _certCache = new AtomicReference();
    private final VirtualHost<?> _virtualHost;

    public TrustStoreMessageSource(TrustStore<?> trustStore, VirtualHost<?> virtualHost) {
        super(TrustStoreMessageSource.getSourceNameFromTrustStore(trustStore), virtualHost);
        this._virtualHost = virtualHost;
        this._trustStore = trustStore;
        this._trustStore.addChangeListener(new AbstractConfigurationChangeListener(){

            @Override
            public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
                if (newState == State.ACTIVE) {
                    TrustStoreMessageSource.this.updateCertCache();
                }
            }

            @Override
            public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
                TrustStoreMessageSource.this.updateCertCache();
            }
        });
        if (this._trustStore.getState() == State.ACTIVE) {
            this.updateCertCache();
        }
    }

    @Override
    public <T extends ConsumerTarget<T>> AbstractSystemMessageSource.Consumer<T> addConsumer(T target, FilterManager filters, Class<? extends ServerMessage> messageClass, String consumerName, EnumSet<ConsumerOption> options, Integer priority) throws MessageSource.ExistingExclusiveConsumer, MessageSource.ExistingConsumerPreventsExclusive, MessageSource.ConsumerAccessRefused, MessageSource.QueueDeleted {
        MessageInstanceConsumer consumer = super.addConsumer((ConsumerTarget)target, filters, (Class)messageClass, consumerName, (EnumSet)options, priority);
        ((AbstractSystemMessageSource.Consumer)consumer).send(this.createMessage());
        target.noMessagesAvailable();
        return consumer;
    }

    private void updateCertCache() {
        this._certCache.set(this.populateCertCache());
        if (!this.getConsumers().isEmpty()) {
            this.sendMessageToConsumers();
        }
    }

    private void sendMessageToConsumers() {
        InternalMessage message = this.createMessage();
        for (AbstractSystemMessageSource.Consumer<?> c : new ArrayList(this.getConsumers())) {
            c.send(message);
        }
    }

    private InternalMessage createMessage() {
        ArrayList<byte[]> messageList = new ArrayList<byte[]>();
        for (Certificate cert : this._certCache.get()) {
            try {
                messageList.add(cert.getEncoded());
            }
            catch (CertificateEncodingException e) {
                LOGGER.error("Could not encode certificate of type " + cert.getType(), (Throwable)e);
            }
        }
        InternalMessageHeader header = new InternalMessageHeader(Collections.emptyMap(), null, 0L, null, null, UUID.randomUUID().toString(), null, null, 4, System.currentTimeMillis(), 0L, null, null, System.currentTimeMillis());
        return InternalMessage.createListMessage(this._virtualHost.getMessageStore(), header, messageList);
    }

    private Set<Certificate> populateCertCache() {
        try {
            HashSet<Certificate> certCache = new HashSet<Certificate>();
            for (Certificate cert : this._trustStore.getCertificates()) {
                certCache.add(cert);
            }
            return certCache;
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Cannot read trust managers from truststore " + this._trustStore.getName(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    public static String getSourceNameFromTrustStore(TrustStore<?> trustStore) {
        return "$certificates/" + trustStore.getName();
    }
}

