/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SocketConnectionPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationResultCacher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationResultCacher.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final Cache<String, AuthenticationResult> _authenticationCache;
    private final int _iterationCount;

    public AuthenticationResultCacher(int cacheSize, long expirationTime, int iterationCount) {
        if (cacheSize <= 0 || expirationTime <= 0L || iterationCount < 0) {
            LOGGER.debug("disabling authentication result caching");
            this._iterationCount = 0;
            this._authenticationCache = null;
        } else {
            this._iterationCount = iterationCount;
            this._authenticationCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterWrite(expirationTime, TimeUnit.SECONDS).build();
        }
    }

    public AuthenticationResult getOrLoad(String[] credentials, final Callable<AuthenticationResult> loader) {
        try {
            if (this._authenticationCache == null) {
                return loader.call();
            }
            String credentialDigest = this.digestCredentials(credentials);
            return (AuthenticationResult)this._authenticationCache.get((Object)credentialDigest, (Callable)new Callable<AuthenticationResult>(){

                @Override
                public AuthenticationResult call() throws Exception {
                    return (AuthenticationResult)loader.call();
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unexpected checked Exception while authenticating", e.getCause());
        }
        catch (UncheckedExecutionException e) {
            throw new RuntimeException("Unexpected Exception while authenticating", e.getCause());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected checked Exception while authenticating", e);
        }
    }

    private String digestCredentials(String ... content) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            Subject subject = Subject.getSubject(AccessController.getContext());
            Set<SocketConnectionPrincipal> connectionPrincipals = subject.getPrincipals(SocketConnectionPrincipal.class);
            if (connectionPrincipals != null && !connectionPrincipals.isEmpty()) {
                SocketConnectionPrincipal connectionPrincipal = connectionPrincipals.iterator().next();
                md.update(connectionPrincipal.getRemoteAddress().toString().getBytes(UTF8));
            }
            for (String part : content) {
                md.update(part.getBytes(UTF8));
            }
            byte[] credentialDigest = md.digest();
            for (int i = 0; i < this._iterationCount; ++i) {
                md = MessageDigest.getInstance("SHA-256");
                credentialDigest = md.digest(credentialDigest);
            }
            return DatatypeConverter.printHexBinary((byte[])credentialDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("JVM is non compliant. Seems to not support SHA-256.");
        }
    }
}

