/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.util.List;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.security.auth.manager.CachingAuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.UsernamePasswordAuthenticationProvider;

@ManagedObject(category=false, type="SimpleLDAP", description="Authentication provider that delegates authentication decisions to a Directory supporting the LDAP protocol.")
public interface SimpleLDAPAuthenticationManager<X extends SimpleLDAPAuthenticationManager<X>>
extends CachingAuthenticationProvider<X>,
UsernamePasswordAuthenticationProvider<X> {
    public static final String CLASS_DESCRIPTION = "Authentication provider that delegates authentication decisions to a Directory supporting the LDAP protocol.";
    public static final String PROVIDER_TYPE = "SimpleLDAP";
    public static final String PROVIDER_URL = "providerUrl";
    public static final String PROVIDER_AUTH_URL = "providerAuthUrl";
    public static final String SEARCH_CONTEXT = "searchContext";
    public static final String LDAP_CONTEXT_FACTORY = "ldapContextFactory";
    public static final String SEARCH_USERNAME = "getSearchUsername";
    public static final String SEARCH_PASSWORD = "getSearchPassword";
    public static final String TRUST_STORE = "trustStore";
    @ManagedContextDefault(name="ldap.context.factory")
    public static final String DEFAULT_LDAP_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";

    @ManagedAttribute(description="LDAP server URL", mandatory=true)
    public String getProviderUrl();

    @ManagedAttribute(description="LDAP authentication URL")
    public String getProviderAuthUrl();

    @ManagedAttribute(description="Search context", mandatory=true)
    public String getSearchContext();

    @ManagedAttribute(description="Search filter", mandatory=true)
    public String getSearchFilter();

    @ManagedAttribute(description="Bind without search")
    public boolean isBindWithoutSearch();

    @ManagedAttribute(description="LDAP context factory", defaultValue="${ldap.context.factory}")
    public String getLdapContextFactory();

    @ManagedAttribute(description="Trust store name")
    public TrustStore getTrustStore();

    @ManagedAttribute(description="(Optional) username for authenticated search")
    public String getSearchUsername();

    @ManagedAttribute(description="(Optional) password for authenticated search", secure=true)
    public String getSearchPassword();

    @ManagedAttribute(description="User entry attribute name containing group name user belongs to. ")
    public String getGroupAttributeName();

    @ManagedAttribute(description="Search context to look for role entries")
    public String getGroupSearchContext();

    @ManagedAttribute(description="Group search filter to search for groups in group search context")
    public String getGroupSearchFilter();

    @ManagedAttribute(description="Defines the group search scope. If true the search for group entries is performed in the entire subtree of the group search context")
    public boolean isGroupSubtreeSearchScope();

    @DerivedAttribute
    public List<String> getTlsProtocolWhiteList();

    @DerivedAttribute
    public List<String> getTlsProtocolBlackList();

    @DerivedAttribute
    public List<String> getTlsCipherSuiteWhiteList();

    @DerivedAttribute
    public List<String> getTlsCipherSuiteBlackList();
}

