/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import com.google.common.util.concurrent.ListenableFuture;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationResultCacher;
import org.apache.qpid.server.security.auth.manager.SimpleLDAPAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.ldap.AbstractLDAPSSLSocketFactory;
import org.apache.qpid.server.security.auth.manager.ldap.LDAPSSLSocketFactoryGenerator;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.plain.PlainNegotiator;
import org.apache.qpid.server.security.group.GroupPrincipal;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.CipherSuiteAndProtocolRestrictingSSLSocketFactory;
import org.apache.qpid.server.util.ParameterizedTypes;
import org.apache.qpid.server.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLDAPAuthenticationManagerImpl
extends AbstractAuthenticationManager<SimpleLDAPAuthenticationManagerImpl>
implements SimpleLDAPAuthenticationManager<SimpleLDAPAuthenticationManagerImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleLDAPAuthenticationManagerImpl.class);
    private static final List<String> CONNECTIVITY_ATTRS = Collections.unmodifiableList(Arrays.asList("providerUrl", "providerAuthUrl", "searchContext", "ldapContextFactory", "getSearchUsername", "getSearchPassword", "trustStore"));
    private static final String JAVA_NAMING_LDAP_FACTORY_SOCKET = "java.naming.ldap.factory.socket";
    @ManagedAttributeField
    private String _providerUrl;
    @ManagedAttributeField
    private String _providerAuthUrl;
    @ManagedAttributeField
    private String _searchContext;
    @ManagedAttributeField
    private String _searchFilter;
    @ManagedAttributeField
    private String _ldapContextFactory;
    @ManagedAttributeField
    private TrustStore _trustStore;
    @ManagedAttributeField
    private boolean _bindWithoutSearch;
    @ManagedAttributeField
    private String _searchUsername;
    @ManagedAttributeField
    private String _searchPassword;
    @ManagedAttributeField
    private String _groupAttributeName;
    @ManagedAttributeField
    private String _groupSearchContext;
    @ManagedAttributeField
    private String _groupSearchFilter;
    @ManagedAttributeField
    private boolean _groupSubtreeSearchScope;
    private List<String> _tlsProtocolWhiteList;
    private List<String> _tlsProtocolBlackList;
    private List<String> _tlsCipherSuiteWhiteList;
    private List<String> _tlsCipherSuiteBlackList;
    private AuthenticationResultCacher _authenticationResultCacher;
    private Class<? extends SocketFactory> _sslSocketFactoryOverrideClass;

    @ManagedObjectFactoryConstructor
    protected SimpleLDAPAuthenticationManagerImpl(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    protected void validateOnCreate() {
        super.validateOnCreate();
        Class<? extends SocketFactory> sslSocketFactoryOverrideClass = this.createSslSocketFactoryOverrideClass(this._trustStore);
        this.validateInitialDirContext(sslSocketFactoryOverrideClass, this._providerUrl, this._searchUsername, this._searchPassword);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        if (!Collections.disjoint(changedAttributes, CONNECTIVITY_ATTRS)) {
            SimpleLDAPAuthenticationManager changed = (SimpleLDAPAuthenticationManager)proxyForValidation;
            TrustStore changedTruststore = changed.getTrustStore();
            Class<? extends SocketFactory> sslSocketFactoryOverrideClass = this.createSslSocketFactoryOverrideClass(changedTruststore);
            this.validateInitialDirContext(sslSocketFactoryOverrideClass, changed.getProviderUrl(), changed.getSearchUsername(), changed.getSearchPassword());
        }
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._tlsProtocolWhiteList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.protocolWhiteList");
        this._tlsProtocolBlackList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.protocolBlackList");
        this._tlsCipherSuiteWhiteList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.cipherSuiteWhiteList");
        this._tlsCipherSuiteBlackList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.cipherSuiteBlackList");
        Integer cacheMaxSize = this.getContextValue(Integer.class, "qpid.auth.cache.size");
        Long cacheExpirationTime = this.getContextValue(Long.class, "qpid.auth.cache.expiration_time");
        Integer cacheIterationCount = this.getContextValue(Integer.class, "qpid.auth.cache.iteration_count");
        if (cacheMaxSize == null || cacheMaxSize <= 0 || cacheExpirationTime == null || cacheExpirationTime <= 0L || cacheIterationCount == null || cacheIterationCount < 0) {
            LOGGER.debug("disabling authentication result caching");
            cacheMaxSize = 0;
            cacheExpirationTime = 1L;
            cacheIterationCount = 0;
        }
        this._authenticationResultCacher = new AuthenticationResultCacher(cacheMaxSize, cacheExpirationTime, cacheIterationCount);
    }

    @Override
    protected ListenableFuture<Void> activate() {
        this._sslSocketFactoryOverrideClass = this.createSslSocketFactoryOverrideClass(this._trustStore);
        return super.activate();
    }

    @Override
    public String getProviderUrl() {
        return this._providerUrl;
    }

    @Override
    public String getProviderAuthUrl() {
        return this._providerAuthUrl;
    }

    @Override
    public String getSearchContext() {
        return this._searchContext;
    }

    @Override
    public String getSearchFilter() {
        return this._searchFilter;
    }

    @Override
    public String getLdapContextFactory() {
        return this._ldapContextFactory;
    }

    @Override
    public TrustStore getTrustStore() {
        return this._trustStore;
    }

    @Override
    public String getSearchUsername() {
        return this._searchUsername;
    }

    @Override
    public String getSearchPassword() {
        return this._searchPassword;
    }

    @Override
    public String getGroupAttributeName() {
        return this._groupAttributeName;
    }

    @Override
    public String getGroupSearchContext() {
        return this._groupSearchContext;
    }

    @Override
    public String getGroupSearchFilter() {
        return this._groupSearchFilter;
    }

    @Override
    public boolean isGroupSubtreeSearchScope() {
        return this._groupSubtreeSearchScope;
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.singletonList("PLAIN");
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
        if ("PLAIN".equals(mechanism)) {
            return new PlainNegotiator(this);
        }
        return null;
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        return this.getOrLoadAuthenticationResult(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationResult doLDAPNameAuthentication(String userId, String password) {
        String name;
        try {
            name = this.getNameFromId(userId);
        }
        catch (NamingException e) {
            LOGGER.warn("Retrieving LDAP name for user '{}' resulted in error.", (Object)userId, (Object)e);
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
        if (name == null) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        }
        String providerAuthUrl = this.isSpecified(this.getProviderAuthUrl()) ? this.getProviderAuthUrl() : this.getProviderUrl();
        Hashtable<String, Object> env = this.createInitialDirContextEnvironment(providerAuthUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", name);
        env.put("java.naming.security.credentials", password);
        InitialDirContext ctx = null;
        try {
            ctx = this.createInitialDirContext(env, this._sslSocketFactoryOverrideClass);
            Set<Principal> groups = Collections.emptySet();
            if (this.isGroupSearchRequired()) {
                if (!providerAuthUrl.equals(this.getProviderUrl())) {
                    this.closeSafely(ctx);
                    ctx = this.createSearchInitialDirContext();
                }
                groups = this.findGroups(ctx, name);
            }
            AuthenticationResult authenticationResult = new AuthenticationResult(new UsernamePrincipal(name, this), groups, null);
            return authenticationResult;
        }
        catch (AuthenticationException ae) {
            AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
            return authenticationResult;
        }
        catch (NamingException e) {
            LOGGER.warn("LDAP authentication attempt for username '{}' resulted in error.", (Object)name, (Object)e);
            AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
            return authenticationResult;
        }
        finally {
            if (ctx != null) {
                this.closeSafely(ctx);
            }
        }
    }

    private AuthenticationResult getOrLoadAuthenticationResult(final String userId, final String password) {
        return this._authenticationResultCacher.getOrLoad(new String[]{userId, password}, new Callable<AuthenticationResult>(){

            @Override
            public AuthenticationResult call() {
                return SimpleLDAPAuthenticationManagerImpl.this.doLDAPNameAuthentication(userId, password);
            }
        });
    }

    private boolean isGroupSearchRequired() {
        if (this.isSpecified(this.getGroupAttributeName())) {
            return true;
        }
        return this.isSpecified(this.getGroupSearchContext()) && this.isSpecified(this.getGroupSearchFilter());
    }

    private boolean isSpecified(String value) {
        return value != null && !"".equals(value);
    }

    private Set<Principal> findGroups(DirContext context, String userDN) throws NamingException {
        HashSet<Principal> groupPrincipals = new HashSet<Principal>();
        if (this.getGroupAttributeName() != null && !"".equals(this.getGroupAttributeName())) {
            Attributes attributes = context.getAttributes(userDN, new String[]{this.getGroupAttributeName()});
            NamingEnumeration<? extends Attribute> namingEnum = attributes.getAll();
            while (namingEnum.hasMore()) {
                Attribute attribute = namingEnum.next();
                if (attribute == null) continue;
                NamingEnumeration<?> attributeValues = attribute.getAll();
                while (attributeValues.hasMore()) {
                    Object attributeValue = attributeValues.next();
                    if (attributeValue == null) continue;
                    String groupDN = String.valueOf(attributeValue);
                    groupPrincipals.add(new GroupPrincipal(groupDN, this));
                }
            }
        }
        if (this.getGroupSearchContext() != null && !"".equals(this.getGroupSearchContext()) && this.getGroupSearchFilter() != null && !"".equals(this.getGroupSearchFilter())) {
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[0]);
            searchControls.setSearchScope(this.isGroupSubtreeSearchScope() ? 2 : 1);
            NamingEnumeration<SearchResult> groupEnumeration = context.search(this.getGroupSearchContext(), this.getGroupSearchFilter(), (Object[])new String[]{this.encode(userDN)}, searchControls);
            while (groupEnumeration.hasMore()) {
                SearchResult result = groupEnumeration.next();
                String groupDN = result.getNameInNamespace();
                groupPrincipals.add(new GroupPrincipal(groupDN, this));
            }
        }
        return groupPrincipals;
    }

    private String encode(String value) {
        StringBuilder encoded = new StringBuilder(value.length());
        char[] chars = value.toCharArray();
        block7: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\u0000': {
                    encoded.append("\\00");
                    continue block7;
                }
                case '(': {
                    encoded.append("\\28");
                    continue block7;
                }
                case ')': {
                    encoded.append("\\29");
                    continue block7;
                }
                case '*': {
                    encoded.append("\\2a");
                    continue block7;
                }
                case '\\': {
                    encoded.append("\\5c");
                    continue block7;
                }
                default: {
                    encoded.append(ch);
                }
            }
        }
        return encoded.toString();
    }

    private Hashtable<String, Object> createInitialDirContextEnvironment(String providerUrl) {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", this._ldapContextFactory);
        env.put("java.naming.provider.url", providerUrl);
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InitialDirContext createInitialDirContext(Hashtable<String, Object> env, Class<? extends SocketFactory> sslSocketFactoryOverrideClass) throws NamingException {
        ClassLoader existingContextClassLoader = null;
        boolean isLdaps = String.valueOf(env.get("java.naming.provider.url")).trim().toLowerCase().startsWith("ldaps:");
        boolean revertContentClassLoader = false;
        try {
            if (isLdaps) {
                existingContextClassLoader = Thread.currentThread().getContextClassLoader();
                env.put(JAVA_NAMING_LDAP_FACTORY_SOCKET, sslSocketFactoryOverrideClass.getName());
                Thread.currentThread().setContextClassLoader(sslSocketFactoryOverrideClass.getClassLoader());
                revertContentClassLoader = true;
            }
            InitialDirContext initialDirContext = new InitialDirContext(env);
            return initialDirContext;
        }
        finally {
            if (revertContentClassLoader) {
                Thread.currentThread().setContextClassLoader(existingContextClassLoader);
            }
        }
    }

    private Class<? extends SocketFactory> createSslSocketFactoryOverrideClass(TrustStore trustStore) {
        String managerName = String.format("%s_%s_%s", this.getName(), this.getId(), trustStore == null ? "none" : trustStore.getName());
        String clazzName = new StringUtil().createUniqueJavaName(managerName);
        SSLContext sslContext = null;
        try {
            sslContext = SSLUtil.tryGetSSLContext();
            sslContext.init(null, trustStore == null ? null : trustStore.getTrustManagers(), null);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Exception creating SSLContext", (Throwable)e);
            if (trustStore != null) {
                throw new IllegalConfigurationException("Error creating SSLContext with trust store : " + trustStore.getName(), e);
            }
            throw new IllegalConfigurationException("Error creating SSLContext (no trust store)", e);
        }
        CipherSuiteAndProtocolRestrictingSSLSocketFactory sslSocketFactory = new CipherSuiteAndProtocolRestrictingSSLSocketFactory(sslContext.getSocketFactory(), this._tlsCipherSuiteWhiteList, this._tlsCipherSuiteBlackList, this._tlsProtocolWhiteList, this._tlsProtocolBlackList);
        Class<? extends AbstractLDAPSSLSocketFactory> clazz = LDAPSSLSocketFactoryGenerator.createSubClass(clazzName, sslSocketFactory);
        LOGGER.debug("Connection to Directory will use custom SSL socket factory : {}", clazz);
        return clazz;
    }

    @Override
    public String toString() {
        return "SimpleLDAPAuthenticationManagerImpl [id=" + this.getId() + ", name=" + this.getName() + ", providerUrl=" + this._providerUrl + ", providerAuthUrl=" + this._providerAuthUrl + ", searchContext=" + this._searchContext + ", state=" + (Object)((Object)this.getState()) + ", searchFilter=" + this._searchFilter + ", ldapContextFactory=" + this._ldapContextFactory + ", bindWithoutSearch=" + this._bindWithoutSearch + ", trustStore=" + this._trustStore + ", searchUsername=" + this._searchUsername + "]";
    }

    private void validateInitialDirContext(Class<? extends SocketFactory> sslSocketFactoryOverrideClass, String providerUrl, String searchUsername, String searchPassword) {
        Hashtable<String, Object> env = this.createInitialDirContextEnvironment(providerUrl);
        this.setupSearchContext(env, searchUsername, searchPassword);
        InitialDirContext ctx = null;
        try {
            ctx = this.createInitialDirContext(env, sslSocketFactoryOverrideClass);
        }
        catch (NamingException e) {
            LOGGER.error("Failed to establish connectivity to the ldap server for '{}'", (Object)providerUrl, (Object)e);
            throw new IllegalConfigurationException("Failed to establish connectivity to the ldap server.", e);
        }
        finally {
            this.closeSafely(ctx);
        }
    }

    private void setupSearchContext(Hashtable<String, Object> env, String searchUsername, String searchPassword) {
        if (this._searchUsername != null && this._searchUsername.trim().length() > 0) {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", searchUsername);
            env.put("java.naming.security.credentials", searchPassword);
        } else {
            env.put("java.naming.security.authentication", "none");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNameFromId(String id) throws NamingException {
        if (!this.isBindWithoutSearch()) {
            InitialDirContext ctx = this.createSearchInitialDirContext();
            try {
                SearchControls searchControls = new SearchControls();
                searchControls.setReturningAttributes(new String[0]);
                searchControls.setCountLimit(1L);
                searchControls.setSearchScope(2);
                NamingEnumeration<SearchResult> namingEnum = null;
                LOGGER.debug("Searching for '{}'", (Object)id);
                namingEnum = ctx.search(this._searchContext, this._searchFilter, (Object[])new String[]{id}, searchControls);
                if (namingEnum.hasMore()) {
                    SearchResult result = namingEnum.next();
                    String name = result.getNameInNamespace();
                    LOGGER.debug("Found '{}' DN '{}'", (Object)id, (Object)name);
                    String string = name;
                    return string;
                }
                LOGGER.debug("Not found '{}'", (Object)id);
                String string = null;
                return string;
            }
            finally {
                this.closeSafely(ctx);
            }
        }
        return id;
    }

    private InitialDirContext createSearchInitialDirContext() throws NamingException {
        Hashtable<String, Object> env = this.createInitialDirContextEnvironment(this._providerUrl);
        this.setupSearchContext(env, this._searchUsername, this._searchPassword);
        return this.createInitialDirContext(env, this._sslSocketFactoryOverrideClass);
    }

    @Override
    public boolean isBindWithoutSearch() {
        return this._bindWithoutSearch;
    }

    @Override
    public List<String> getTlsProtocolWhiteList() {
        return this._tlsProtocolWhiteList;
    }

    @Override
    public List<String> getTlsProtocolBlackList() {
        return this._tlsProtocolBlackList;
    }

    @Override
    public List<String> getTlsCipherSuiteWhiteList() {
        return this._tlsCipherSuiteWhiteList;
    }

    @Override
    public List<String> getTlsCipherSuiteBlackList() {
        return this._tlsCipherSuiteBlackList;
    }

    private void closeSafely(InitialDirContext ctx) {
        try {
            if (ctx != null) {
                ctx.close();
                ctx = null;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception closing InitialDirContext", (Throwable)e);
        }
    }
}

