/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.encryption;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.security.encryption.ConfigurationSecretEncrypter;
import org.apache.qpid.server.util.Strings;

class AESKeyFileEncrypter
implements ConfigurationSecretEncrypter {
    private static final String CIPHER_NAME = "AES/CBC/PKCS5Padding";
    private static final int AES_INITIALIZATION_VECTOR_LENGTH = 16;
    private static final String AES_ALGORITHM = "AES";
    private final SecretKey _secretKey;
    private final SecureRandom _random = new SecureRandom();

    AESKeyFileEncrypter(SecretKey secretKey) {
        if (secretKey == null) {
            throw new NullPointerException("A non null secret key must be supplied");
        }
        if (!AES_ALGORITHM.equals(secretKey.getAlgorithm())) {
            throw new IllegalArgumentException("Provided secret key was for the algorithm: " + secretKey.getAlgorithm() + "when" + AES_ALGORITHM + "was needed.");
        }
        this._secretKey = secretKey;
    }

    @Override
    public String encrypt(String unencrypted) {
        byte[] unencryptedBytes = unencrypted.getBytes(StandardCharsets.UTF_8);
        try {
            byte[] ivbytes = new byte[16];
            this._random.nextBytes(ivbytes);
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            cipher.init(1, (Key)this._secretKey, new IvParameterSpec(ivbytes));
            byte[] encryptedBytes = this.readFromCipherStream(unencryptedBytes, cipher);
            byte[] output = new byte[16 + encryptedBytes.length];
            System.arraycopy(ivbytes, 0, output, 0, 16);
            System.arraycopy(encryptedBytes, 0, output, 16, encryptedBytes.length);
            return DatatypeConverter.printBase64Binary((byte[])output);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Unable to encrypt secret", e);
        }
    }

    @Override
    public String decrypt(String encrypted) {
        if (!this.isValidBase64(encrypted)) {
            throw new IllegalArgumentException("Encrypted value is not valid Base 64 data: '" + encrypted + "'");
        }
        byte[] encryptedBytes = Strings.decodeBase64(encrypted);
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(encryptedBytes, 0, 16);
            cipher.init(2, (Key)this._secretKey, ivParameterSpec);
            return new String(this.readFromCipherStream(encryptedBytes, 16, encryptedBytes.length - 16, cipher), StandardCharsets.UTF_8);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Unable to decrypt secret", e);
        }
    }

    private boolean isValidBase64(String encrypted) {
        return encrypted.matches("^([\\w\\d+/]{4})*([\\w\\d+/]{2}==|[\\w\\d+/]{3}=)?$");
    }

    private byte[] readFromCipherStream(byte[] unencryptedBytes, Cipher cipher) throws IOException {
        return this.readFromCipherStream(unencryptedBytes, 0, unencryptedBytes.length, cipher);
    }

    private byte[] readFromCipherStream(byte[] unencryptedBytes, int offset, int length, Cipher cipher) throws IOException {
        byte[] encryptedBytes;
        try (CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(unencryptedBytes, offset, length), cipher);){
            int read;
            byte[] buf = new byte[512];
            int pos = 0;
            while ((read = cipherInputStream.read(buf, pos, buf.length - pos)) != -1) {
                if ((pos += read) != buf.length) continue;
                byte[] tmp = buf;
                buf = new byte[buf.length + 512];
                System.arraycopy(tmp, 0, buf, 0, tmp.length);
            }
            encryptedBytes = new byte[pos];
            System.arraycopy(buf, 0, encryptedBytes, 0, pos);
        }
        return encryptedBytes;
    }
}

