/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;

public class StoredMemoryMessage<T extends StorableMessageMetaData>
implements StoredMessage<T>,
MessageHandle<T> {
    private final long _messageNumber;
    private final int _contentSize;
    private final int _metadataSize;
    private QpidByteBuffer _content = null;
    private volatile T _metaData;

    public StoredMemoryMessage(long messageNumber, T metaData) {
        this._messageNumber = messageNumber;
        this._metaData = metaData;
        this._contentSize = this._metaData.getContentSize();
        this._metadataSize = this._metaData.getStorableSize();
    }

    @Override
    public long getMessageNumber() {
        return this._messageNumber;
    }

    @Override
    public synchronized void addContent(QpidByteBuffer src) {
        try (QpidByteBuffer content = this._content;){
            this._content = content == null ? src.slice() : QpidByteBuffer.concatenate(content, src);
        }
    }

    @Override
    public synchronized StoredMessage<T> allContentAdded() {
        return this;
    }

    @Override
    public synchronized QpidByteBuffer getContent(int offset, int length) {
        if (this._content == null) {
            return QpidByteBuffer.emptyQpidByteBuffer();
        }
        try (QpidByteBuffer combined = QpidByteBuffer.concatenate(this._content);){
            if (length == Integer.MAX_VALUE) {
                length = combined.remaining();
            }
            QpidByteBuffer qpidByteBuffer = combined.view(offset, length);
            return qpidByteBuffer;
        }
    }

    @Override
    public int getContentSize() {
        return this._contentSize;
    }

    @Override
    public int getMetadataSize() {
        return this._metadataSize;
    }

    @Override
    public T getMetaData() {
        return this._metaData;
    }

    @Override
    public synchronized void remove() {
        this._metaData.dispose();
        this._metaData = null;
        if (this._content != null) {
            this._content.dispose();
            this._content = null;
        }
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public boolean flowToDisk() {
        return false;
    }

    @Override
    public synchronized void reallocate() {
        this._metaData.reallocate();
        this._content = QpidByteBuffer.reallocateIfNecessary(this._content);
    }

    public void clear() {
        this.remove();
    }
}

