/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.store.StoreConfigurationChangeListener;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.store.AbstractConfigurationStoreUpgraderAndRecoverer;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.GenericRecoverer;
import org.apache.qpid.server.store.StoreUpgraderPhase;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.apache.qpid.server.util.FixedKeyMapCreator;

public class VirtualHostStoreUpgraderAndRecoverer
extends AbstractConfigurationStoreUpgraderAndRecoverer {
    private final VirtualHostNode<?> _virtualHostNode;
    private static final Map<String, String> DEFAULT_EXCHANGES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("amq.direct", "direct");
            this.put("amq.topic", "topic");
            this.put("amq.fanout", "fanout");
            this.put("amq.match", "headers");
        }
    });
    private final Map<String, UUID> _defaultExchangeIds;
    private static final FixedKeyMapCreator BINDING_MAP_CREATOR = new FixedKeyMapCreator("bindingKey", "destination", "arguments");
    private static final FixedKeyMapCreator NO_ARGUMENTS_BINDING_MAP_CREATOR = new FixedKeyMapCreator("bindingKey", "destination");

    public VirtualHostStoreUpgraderAndRecoverer(VirtualHostNode<?> virtualHostNode) {
        super("0.0");
        this._virtualHostNode = virtualHostNode;
        this.register(new Upgrader_0_0_to_0_1());
        this.register(new Upgrader_0_1_to_0_2());
        this.register(new Upgrader_0_2_to_0_3());
        this.register(new Upgrader_0_3_to_0_4());
        this.register(new Upgrader_0_4_to_2_0());
        this.register(new Upgrader_2_0_to_3_0());
        this.register(new Upgrader_3_0_to_6_0());
        this.register(new Upgrader_6_0_to_6_1());
        this.register(new Upgrader_6_1_to_7_0());
        HashMap<String, UUID> defaultExchangeIds = new HashMap<String, UUID>();
        for (String exchangeName : DEFAULT_EXCHANGES.keySet()) {
            UUID id = UUIDGenerator.generateExchangeUUID(exchangeName, virtualHostNode.getName());
            defaultExchangeIds.put(exchangeName, id);
        }
        this._defaultExchangeIds = Collections.unmodifiableMap(defaultExchangeIds);
    }

    public boolean upgradeAndRecover(DurableConfigurationStore durableConfigurationStore, ConfiguredObjectRecord ... initialRecords) {
        final ArrayList<ConfiguredObjectRecord> records = new ArrayList<ConfiguredObjectRecord>();
        boolean isNew = durableConfigurationStore.openConfigurationStore(new ConfiguredObjectRecordHandler(){

            @Override
            public void handle(ConfiguredObjectRecord record) {
                records.add(record);
            }
        }, initialRecords);
        List<ConfiguredObjectRecord> upgradedRecords = this.upgrade(durableConfigurationStore, records, VirtualHost.class.getSimpleName(), "modelVersion");
        this.recover(this._virtualHostNode, durableConfigurationStore, upgradedRecords, isNew);
        return isNew;
    }

    public void reloadAndRecover(DurableConfigurationStore durableConfigurationStore) {
        this.reloadAndRecoverInternal(this._virtualHostNode, durableConfigurationStore);
    }

    public void reloadAndRecoverVirtualHost(DurableConfigurationStore durableConfigurationStore) {
        this.reloadAndRecoverInternal(this._virtualHostNode.getVirtualHost(), durableConfigurationStore);
    }

    private void reloadAndRecoverInternal(ConfiguredObject<?> recoveryRoot, DurableConfigurationStore durableConfigurationStore) {
        ArrayList<ConfiguredObjectRecord> records = new ArrayList<ConfiguredObjectRecord>();
        durableConfigurationStore.reload(records::add);
        this.recover(recoveryRoot, durableConfigurationStore, records, false);
    }

    private void recover(ConfiguredObject<?> recoveryRoot, final DurableConfigurationStore durableConfigurationStore, List<ConfiguredObjectRecord> records, boolean isNew) {
        new GenericRecoverer(recoveryRoot).recover(records, isNew);
        final StoreConfigurationChangeListener configChangeListener = new StoreConfigurationChangeListener(durableConfigurationStore);
        if (this._virtualHostNode.getVirtualHost() != null) {
            this.applyRecursively(this._virtualHostNode.getVirtualHost(), new AbstractConfigurationStoreUpgraderAndRecoverer.RecursiveAction<ConfiguredObject<?>>(){

                @Override
                public boolean applyToChildren(ConfiguredObject<?> object) {
                    return object.isDurable();
                }

                @Override
                public void performAction(ConfiguredObject<?> object) {
                    object.addChangeListener(configChangeListener);
                }
            });
        }
        if (recoveryRoot instanceof VirtualHostNode) {
            this._virtualHostNode.addChangeListener(new AbstractConfigurationChangeListener(){

                @Override
                public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
                    if (child instanceof VirtualHost) {
                        VirtualHostStoreUpgraderAndRecoverer.this.applyRecursively(child, new AbstractConfigurationStoreUpgraderAndRecoverer.RecursiveAction<ConfiguredObject<?>>(){

                            @Override
                            public boolean applyToChildren(ConfiguredObject<?> object) {
                                return object.isDurable();
                            }

                            @Override
                            public void performAction(ConfiguredObject<?> object) {
                                if (object.isDurable()) {
                                    durableConfigurationStore.update(true, object.asObjectRecord());
                                    object.addChangeListener(configChangeListener);
                                }
                            }
                        });
                    }
                }

                @Override
                public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
                    if (child instanceof VirtualHost) {
                        child.removeChangeListener(configChangeListener);
                        VirtualHostStoreUpgraderAndRecoverer.this.removeVirtualHostConfiguration((VirtualHost)child, durableConfigurationStore);
                    }
                }
            });
            if (isNew && this._virtualHostNode instanceof AbstractConfiguredObject) {
                ((AbstractConfiguredObject)((Object)this._virtualHostNode)).forceUpdateAllSecureAttributes();
            }
        }
    }

    private void removeVirtualHostConfiguration(VirtualHost<?> virtualHost, DurableConfigurationStore durableConfigurationStore) {
        final HashSet records = new HashSet();
        this.applyRecursively(virtualHost, new AbstractConfigurationStoreUpgraderAndRecoverer.RecursiveAction<ConfiguredObject<?>>(){

            @Override
            public boolean applyToChildren(ConfiguredObject<?> object) {
                return object.isDurable();
            }

            @Override
            public void performAction(ConfiguredObject<?> object) {
                records.add(object.asObjectRecord());
            }
        });
        durableConfigurationStore.remove(records.toArray(new ConfiguredObjectRecord[records.size()]));
    }

    private class Upgrader_6_1_to_7_0
    extends StoreUpgraderPhase {
        private final Map<UUID, List<BindingRecord>> _exchangeBindings;
        private final Map<UUID, ConfiguredObjectRecord> _exchanges;
        private final Map<UUID, String> _queues;
        private final Map<String, List<Map<String, Object>>> _queueBindings;
        private Set<UUID> _destinationsWithAlternateExchange;

        public Upgrader_6_1_to_7_0() {
            super("modelVersion", "6.1", "7.0");
            this._exchangeBindings = new HashMap<UUID, List<BindingRecord>>();
            this._exchanges = new HashMap<UUID, ConfiguredObjectRecord>();
            this._queues = new HashMap<UUID, String>();
            this._queueBindings = new HashMap<String, List<Map<String, Object>>>();
            this._destinationsWithAlternateExchange = new HashSet<UUID>();
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                int brokerStatisticsReportingPeriod;
                HashMap<String, Object> attributes = new HashMap<String, Object>((record = this.upgradeRootRecord(record)).getAttributes());
                boolean modified = attributes.remove("queue_deadLetterQueueEnabled") != null;
                Object context = attributes.get("context");
                HashMap<String, String> contextMap = null;
                if (context instanceof Map && (modified |= (contextMap = new HashMap<String, String>((Map)context)).remove("queue.deadLetterQueueEnabled") != null)) {
                    attributes.put("context", contextMap);
                }
                if ((brokerStatisticsReportingPeriod = ((Broker)VirtualHostStoreUpgraderAndRecoverer.this._virtualHostNode.getParent()).getStatisticsReportingPeriod()) > 0) {
                    attributes.put("statisticsReportingPeriod", brokerStatisticsReportingPeriod);
                    if (contextMap == null) {
                        contextMap = new HashMap();
                    }
                    contextMap.put("qpid.virtualhost.statisticsReportPattern", "${ancestor:virtualhost:name}: messagesIn=${messagesIn}, bytesIn=${bytesIn:byteunit}, messagesOut=${messagesOut}, bytesOut=${bytesOut:byteunit}");
                    attributes.put("context", contextMap);
                    modified = true;
                }
                if (modified) {
                    record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), attributes, record.getParents());
                    this.getUpdateMap().put(record.getId(), record);
                }
            } else if ("Binding".equals(record.getType())) {
                BindingRecord binding = new BindingRecord(String.valueOf(record.getAttributes().get("name")), record.getParents().get("Queue").toString(), record.getAttributes().get("arguments"));
                UUID exchangeId = record.getParents().get("Exchange");
                List<BindingRecord> existingBindings = this._exchangeBindings.get(exchangeId);
                if (existingBindings == null) {
                    existingBindings = new ArrayList<BindingRecord>();
                    this._exchangeBindings.put(exchangeId, existingBindings);
                }
                existingBindings.add(binding);
                this.getDeleteMap().put(record.getId(), record);
            } else if ("Exchange".equals(record.getType())) {
                UUID exchangeId = record.getId();
                this._exchanges.put(exchangeId, record);
                if (record.getAttributes().containsKey("bindings")) {
                    List<BindingRecord> existingBindings = this._exchangeBindings.get(exchangeId);
                    if (existingBindings == null) {
                        existingBindings = new ArrayList<BindingRecord>();
                        this._exchangeBindings.put(exchangeId, existingBindings);
                    }
                    List bindingList = (List)record.getAttributes().get("bindings");
                    for (Map existingBinding : bindingList) {
                        existingBindings.add(new BindingRecord((String)existingBinding.get("name"), String.valueOf(existingBinding.get("queue")), existingBinding.get("arguments")));
                    }
                }
                if (record.getAttributes().containsKey("alternateExchange")) {
                    this._destinationsWithAlternateExchange.add(record.getId());
                    this.getUpdateMap().put(record.getId(), record);
                }
            } else if ("Queue".equals(record.getType())) {
                long queueFlowControlSizeBytesValue;
                HashMap<String, Object> attributes = new HashMap<String, Object>(record.getAttributes());
                Object queueFlowControlSizeBytes = attributes.remove("queueFlowControlSizeBytes");
                Object queueFlowResumeSizeBytes = attributes.remove("queueFlowResumeSizeBytes");
                if (queueFlowControlSizeBytes != null && (queueFlowControlSizeBytesValue = this.convertAttributeValueToLong("queueFlowControlSizeBytes", queueFlowControlSizeBytes)) > 0L) {
                    if (queueFlowResumeSizeBytes != null) {
                        HashMap<String, String> contextMap;
                        long queueFlowResumeSizeBytesValue = this.convertAttributeValueToLong("queueFlowResumeSizeBytes", queueFlowResumeSizeBytes);
                        double ratio = (double)queueFlowResumeSizeBytesValue / (double)queueFlowControlSizeBytesValue;
                        String flowResumeLimit = String.format("%.2f", ratio * 100.0);
                        Object context = attributes.get("context");
                        if (context instanceof Map) {
                            contextMap = (HashMap<String, String>)context;
                        } else {
                            contextMap = new HashMap<String, String>();
                            attributes.put("context", contextMap);
                        }
                        contextMap.put("queue.queueFlowResumeLimit", flowResumeLimit);
                    }
                    attributes.put("overflowPolicy", "PRODUCER_FLOW_CONTROL");
                    attributes.put("maximumQueueDepthBytes", queueFlowControlSizeBytes);
                }
                boolean addToUpdateMap = false;
                if (attributes.containsKey("alternateExchange")) {
                    this._destinationsWithAlternateExchange.add(record.getId());
                    addToUpdateMap = true;
                }
                if (attributes.containsKey("bindings")) {
                    this._queueBindings.put(String.valueOf(attributes.get("name")), (List)attributes.get("bindings"));
                    attributes.remove("bindings");
                }
                if (attributes.containsKey("messageGroupKey")) {
                    if (attributes.containsKey("messageGroupSharedGroups") && this.convertAttributeValueToBoolean("messageGroupSharedGroups", attributes.remove("messageGroupSharedGroups"))) {
                        attributes.put("messageGroupType", "SHARED_GROUPS");
                    } else {
                        attributes.put("messageGroupType", "STANDARD");
                    }
                    Object oldMessageGroupKey = attributes.remove("messageGroupKey");
                    if (!"JMSXGroupId".equals(oldMessageGroupKey)) {
                        attributes.put("messageGroupKeyOverride", oldMessageGroupKey);
                    }
                } else {
                    attributes.put("messageGroupType", "NONE");
                }
                this._queues.put(record.getId(), (String)attributes.get("name"));
                if (!attributes.equals(new HashMap<String, Object>(record.getAttributes())) || addToUpdateMap) {
                    this.getUpdateMap().put(record.getId(), new ConfiguredObjectRecordImpl(record.getId(), record.getType(), attributes, record.getParents()));
                }
            } else if (record.getType().equals("VirtualHostLogger")) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("name", "statistics-" + record.getAttributes().get("name"));
                attributes.put("level", "INFO");
                attributes.put("loggerName", "qpid.statistics.*");
                attributes.put("type", "NameAndLevel");
                ConfiguredObjectRecordImpl filterRecord = new ConfiguredObjectRecordImpl(UUID.randomUUID(), "VirtualHostLogInclusionRule", attributes, Collections.singletonMap("VirtualHostLogger", record.getId()));
                this.getUpdateMap().put(filterRecord.getId(), filterRecord);
            }
        }

        private long convertAttributeValueToLong(String attributeName, Object attributeValue) {
            long value;
            if (attributeValue instanceof Number) {
                value = ((Number)attributeValue).longValue();
            } else if (attributeValue instanceof String) {
                try {
                    value = Long.parseLong((String)attributeValue);
                }
                catch (Exception e) {
                    throw new IllegalConfigurationException(String.format("Cannot evaluate '%s': %s", attributeName, attributeValue));
                }
            } else {
                throw new IllegalConfigurationException(String.format("Cannot evaluate '%s': %s", attributeName, String.valueOf(attributeValue)));
            }
            return value;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean convertAttributeValueToBoolean(String attributeName, Object attributeValue) {
            if (attributeValue instanceof Boolean) {
                return (Boolean)attributeValue;
            }
            if (!(attributeValue instanceof String)) throw new IllegalConfigurationException(String.format("Cannot evaluate '%s': %s", attributeName, String.valueOf(attributeValue)));
            String strValue = (String)attributeValue;
            if (strValue.equalsIgnoreCase("true")) {
                return true;
            }
            if (!strValue.equalsIgnoreCase("false")) throw new IllegalConfigurationException(String.format("Cannot evaluate '%s': %s", attributeName, attributeValue));
            return false;
        }

        @Override
        public void complete() {
            for (Map.Entry<String, List<Map<String, Object>>> entry : this._queueBindings.entrySet()) {
                for (Map<String, Object> existingBinding : entry.getValue()) {
                    UUID exchangeId = existingBinding.get("exchange") instanceof UUID ? (UUID)existingBinding.get("exchange") : this.getExchangeIdFromNameOrId(existingBinding.get("exchange").toString());
                    List<BindingRecord> existingBindings = this._exchangeBindings.get(exchangeId);
                    if (existingBindings == null) {
                        existingBindings = new ArrayList<BindingRecord>();
                        this._exchangeBindings.put(exchangeId, existingBindings);
                    }
                    existingBindings.add(new BindingRecord((String)existingBinding.get("name"), entry.getKey(), existingBinding.get("arguments")));
                }
            }
            for (Map.Entry<Object, List<Object>> entry : this._exchangeBindings.entrySet()) {
                ConfiguredObjectRecord exchangeRecord = this._exchanges.get(entry.getKey());
                if (exchangeRecord == null) continue;
                List<Object> bindingRecords = entry.getValue();
                ArrayList<Map<String, Object>> actualBindings = new ArrayList<Map<String, Object>>(bindingRecords.size());
                for (BindingRecord bindingRecord : bindingRecords) {
                    if (bindingRecord._arguments == null) {
                        actualBindings.add(NO_ARGUMENTS_BINDING_MAP_CREATOR.createMap(bindingRecord._name, this.getQueueFromIdOrName(bindingRecord)));
                        continue;
                    }
                    actualBindings.add(BINDING_MAP_CREATOR.createMap(bindingRecord._name, this.getQueueFromIdOrName(bindingRecord), bindingRecord._arguments));
                }
                HashMap<String, Object> updatedAttributes = new HashMap<String, Object>(exchangeRecord.getAttributes());
                updatedAttributes.remove("bindings");
                updatedAttributes.put("durableBindings", actualBindings);
                exchangeRecord = new ConfiguredObjectRecordImpl(exchangeRecord.getId(), exchangeRecord.getType(), updatedAttributes, exchangeRecord.getParents());
                this.getUpdateMap().put(exchangeRecord.getId(), exchangeRecord);
            }
            for (UUID uUID : this._destinationsWithAlternateExchange) {
                ConfiguredObjectRecord record = this.getUpdateMap().get(uUID);
                HashMap<String, Object> attributes = new HashMap<String, Object>(record.getAttributes());
                String exchangeNameOrUuid = String.valueOf(attributes.remove("alternateExchange"));
                ConfiguredObjectRecord exchangeRecord = this.getExchangeFromNameOrUUID(exchangeNameOrUuid);
                if (exchangeRecord == null) {
                    throw new IllegalConfigurationException(String.format("Cannot upgrade record UUID '%s' as cannot find exchange with name or UUID '%s'", uUID, exchangeNameOrUuid));
                }
                attributes.put("alternateBinding", Collections.singletonMap("destination", exchangeRecord.getAttributes().get("name")));
                this.getUpdateMap().put(record.getId(), new ConfiguredObjectRecordImpl(record.getId(), record.getType(), attributes, record.getParents()));
            }
        }

        private ConfiguredObjectRecord getExchangeFromNameOrUUID(String exchangeNameOrUuid) {
            for (ConfiguredObjectRecord record : this._exchanges.values()) {
                if (exchangeNameOrUuid.equals(record.getAttributes().get("name"))) {
                    return record;
                }
                try {
                    UUID uuid = UUID.fromString(exchangeNameOrUuid);
                    if (!uuid.equals(record.getId())) continue;
                    return record;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            return null;
        }

        private UUID getExchangeIdFromNameOrId(String exchange) {
            for (ConfiguredObjectRecord record : this._exchanges.values()) {
                if (!exchange.equals(record.getAttributes().get("name"))) continue;
                return record.getId();
            }
            return UUID.fromString(exchange);
        }

        private String getQueueFromIdOrName(BindingRecord bindingRecord) {
            String queueIdOrName = bindingRecord._queueIdOrName;
            try {
                UUID queueId = UUID.fromString(queueIdOrName);
                String name = this._queues.get(queueId);
                return name == null ? queueIdOrName : name;
            }
            catch (IllegalArgumentException e) {
                return queueIdOrName;
            }
        }

        private class BindingRecord {
            private final String _name;
            private final String _queueIdOrName;
            private final Object _arguments;

            public BindingRecord(String name, String queueIdOrName, Object arguments) {
                this._name = name;
                this._queueIdOrName = queueIdOrName;
                this._arguments = arguments;
            }
        }
    }

    private class Upgrader_6_0_to_6_1
    extends StoreUpgraderPhase {
        public Upgrader_6_0_to_6_1() {
            super("modelVersion", "6.0", "6.1");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                this.upgradeRootRecord(record);
            }
        }

        @Override
        public void complete() {
        }
    }

    private class Upgrader_3_0_to_6_0
    extends StoreUpgraderPhase {
        public Upgrader_3_0_to_6_0() {
            super("modelVersion", "3.0", "6.0");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                this.upgradeRootRecord(record);
            }
        }

        @Override
        public void complete() {
        }
    }

    private class Upgrader_2_0_to_3_0
    extends StoreUpgraderPhase {
        public Upgrader_2_0_to_3_0() {
            super("modelVersion", "2.0", "3.0");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                this.upgradeRootRecord(record);
            }
        }

        @Override
        public void complete() {
        }
    }

    private class Upgrader_0_4_to_2_0
    extends StoreUpgraderPhase {
        private static final String ALTERNATE_EXCHANGE = "alternateExchange";
        private static final String DLQ_ENABLED_ARGUMENT = "x-qpid-dlq-enabled";
        private static final String DEFAULT_DLE_NAME_SUFFIX = "_DLE";
        private Map<String, String> _missingAmqpExchanges;
        private ConfiguredObjectRecord _virtualHostRecord;
        private Map<UUID, String> _queuesMissingAlternateExchange;
        private Map<String, ConfiguredObjectRecord> _exchanges;

        public Upgrader_0_4_to_2_0() {
            super("modelVersion", "0.4", "2.0");
            this._missingAmqpExchanges = new HashMap<String, String>(DEFAULT_EXCHANGES);
            this._queuesMissingAlternateExchange = new HashMap<UUID, String>();
            this._exchanges = new HashMap<String, ConfiguredObjectRecord>();
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                record = this.upgradeRootRecord(record);
                HashMap<String, Object> virtualHostAttributes = new HashMap<String, Object>(record.getAttributes());
                virtualHostAttributes.put("name", VirtualHostStoreUpgraderAndRecoverer.this._virtualHostNode.getName());
                virtualHostAttributes.put("modelVersion", this.getToVersion());
                this._virtualHostRecord = record = new ConfiguredObjectRecordImpl(record.getId(), "VirtualHost", virtualHostAttributes, Collections.emptyMap());
            } else if ("Exchange".equals(record.getType())) {
                Map<String, Object> attributes = record.getAttributes();
                String name = (String)attributes.get("name");
                this._missingAmqpExchanges.remove(name);
                this._exchanges.put(name, record);
            } else if ("Queue".equals(record.getType())) {
                this.updateQueueRecordIfNecessary(record);
            }
        }

        @Override
        public void complete() {
            for (UUID uUID : this._queuesMissingAlternateExchange.keySet()) {
                String dleExchangeName;
                ConfiguredObjectRecord alternateExchange;
                ConfiguredObjectRecord record = this.getUpdateMap().get(uUID);
                if (record == null || (alternateExchange = this._exchanges.get(dleExchangeName = this._queuesMissingAlternateExchange.get(uUID))) == null) continue;
                this.setAlternateExchangeAttribute(record, alternateExchange);
            }
            for (Map.Entry entry : this._missingAmqpExchanges.entrySet()) {
                String name = (String)entry.getKey();
                String type = (String)entry.getValue();
                UUID id = (UUID)VirtualHostStoreUpgraderAndRecoverer.this._defaultExchangeIds.get(name);
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("name", name);
                attributes.put("type", type);
                attributes.put("lifetimePolicy", "PERMANENT");
                ConfiguredObjectRecordImpl record = new ConfiguredObjectRecordImpl(id, Exchange.class.getSimpleName(), attributes, Collections.singletonMap(this._virtualHostRecord.getType(), this._virtualHostRecord.getId()));
                this.getUpdateMap().put(id, record);
            }
        }

        private ConfiguredObjectRecord updateQueueRecordIfNecessary(ConfiguredObjectRecord record) {
            Map<String, Object> attributes = record.getAttributes();
            boolean queueDLQEnabled = Boolean.parseBoolean(String.valueOf(attributes.get(DLQ_ENABLED_ARGUMENT)));
            if (queueDLQEnabled && attributes.get(ALTERNATE_EXCHANGE) == null) {
                Object queueName = attributes.get("name");
                if (queueName == null || "".equals(queueName)) {
                    throw new IllegalConfigurationException("Queue name is not found in queue configuration entry attributes: " + attributes);
                }
                String dleSuffix = System.getProperty("qpid.broker_dead_letter_exchange_suffix", DEFAULT_DLE_NAME_SUFFIX);
                String dleExchangeName = queueName + dleSuffix;
                ConfiguredObjectRecord exchangeRecord = this.findConfiguredObjectRecordInUpdateMap("Exchange", dleExchangeName);
                if (exchangeRecord == null) {
                    if (!this.getUpdateMap().containsKey(record.getId())) {
                        this.getUpdateMap().put(record.getId(), record);
                    }
                    this._queuesMissingAlternateExchange.put(record.getId(), dleExchangeName);
                } else {
                    record = this.setAlternateExchangeAttribute(record, exchangeRecord);
                }
            }
            return record;
        }

        private ConfiguredObjectRecord setAlternateExchangeAttribute(ConfiguredObjectRecord record, ConfiguredObjectRecord alternateExchange) {
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(record.getAttributes());
            attributes.put(ALTERNATE_EXCHANGE, alternateExchange.getId());
            record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), attributes, record.getParents());
            this.getUpdateMap().put(record.getId(), record);
            return record;
        }

        private ConfiguredObjectRecord findConfiguredObjectRecordInUpdateMap(String type, String name) {
            for (ConfiguredObjectRecord record : this.getUpdateMap().values()) {
                if (!type.equals(record.getType()) || !name.equals(record.getAttributes().get("name"))) continue;
                return record;
            }
            return null;
        }
    }

    private class Upgrader_0_3_to_0_4
    extends StoreUpgraderPhase {
        private static final String EXCLUSIVE = "exclusive";

        public Upgrader_0_3_to_0_4() {
            super("modelVersion", "0.3", "0.4");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                this.upgradeRootRecord(record);
            } else if (Queue.class.getSimpleName().equals(record.getType())) {
                LinkedHashMap<String, Object> newAttributes = new LinkedHashMap<String, Object>(record.getAttributes());
                if (record.getAttributes().get(EXCLUSIVE) instanceof Boolean) {
                    boolean isExclusive = (Boolean)record.getAttributes().get(EXCLUSIVE);
                    newAttributes.put(EXCLUSIVE, isExclusive ? "CONTAINER" : "NONE");
                    if (!isExclusive && record.getAttributes().containsKey("owner")) {
                        newAttributes.remove("owner");
                    }
                } else {
                    newAttributes.remove("owner");
                }
                if (!record.getAttributes().containsKey("durable")) {
                    newAttributes.put("durable", "true");
                }
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), newAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            }
        }

        @Override
        public void complete() {
        }
    }

    private class Upgrader_0_2_to_0_3
    extends StoreUpgraderPhase {
        private static final String ARGUMENTS = "arguments";
        private final Map<String, String> ATTRIBUTE_MAPPINGS;

        public Upgrader_0_2_to_0_3() {
            super("modelVersion", "0.2", "0.3");
            this.ATTRIBUTE_MAPPINGS = new LinkedHashMap<String, String>();
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-minimum-alert-repeat-gap", "alertRepeatGap");
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-maximum-message-age", "alertThresholdMessageAge");
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-maximum-message-size", "alertThresholdMessageSize");
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-maximum-message-count", "alertThresholdQueueDepthMessages");
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-maximum-queue-depth", "alertThresholdQueueDepthBytes");
            this.ATTRIBUTE_MAPPINGS.put("qpid.alert_count", "alertThresholdQueueDepthMessages");
            this.ATTRIBUTE_MAPPINGS.put("qpid.alert_size", "alertThresholdQueueDepthBytes");
            this.ATTRIBUTE_MAPPINGS.put("qpid.alert_repeat_gap", "alertRepeatGap");
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-maximum-delivery-count", "maximumDeliveryAttempts");
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-capacity", "queueFlowControlSizeBytes");
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-flow-resume-capacity", "queueFlowResumeSizeBytes");
            this.ATTRIBUTE_MAPPINGS.put("qpid.queue_sort_key", "sortKey");
            this.ATTRIBUTE_MAPPINGS.put("qpid.last_value_queue_key", "lvqKey");
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-priorities", "priorities");
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-description", "description");
            this.ATTRIBUTE_MAPPINGS.put("x-qpid-dlq-enabled", "x-qpid-dlq-enabled");
            this.ATTRIBUTE_MAPPINGS.put("qpid.group_header_key", "messageGroupKey");
            this.ATTRIBUTE_MAPPINGS.put("qpid.default-message-group", "messageGroupDefaultGroup");
            this.ATTRIBUTE_MAPPINGS.put("no-local", "noLocal");
            this.ATTRIBUTE_MAPPINGS.put("qpid.message_durability", "messageDurability");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            if ("VirtualHost".equals(record.getType())) {
                this.upgradeRootRecord(record);
            } else if ("Queue".equals(record.getType())) {
                LinkedHashMap<String, Object> newAttributes = new LinkedHashMap<String, Object>();
                if (record.getAttributes().get(ARGUMENTS) instanceof Map) {
                    newAttributes.putAll(this.convertWireArgsToModel((Map)record.getAttributes().get(ARGUMENTS)));
                }
                newAttributes.putAll(record.getAttributes());
                record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), newAttributes, record.getParents());
                this.getUpdateMap().put(record.getId(), record);
            }
        }

        @Override
        public void complete() {
        }

        private Map<String, Object> convertWireArgsToModel(Map<String, Object> wireArguments) {
            HashMap<String, Object> modelArguments = new HashMap<String, Object>();
            if (wireArguments != null) {
                for (Map.Entry<String, String> entry : this.ATTRIBUTE_MAPPINGS.entrySet()) {
                    if (!wireArguments.containsKey(entry.getKey())) continue;
                    modelArguments.put(entry.getValue(), wireArguments.get(entry.getKey()));
                }
                if (wireArguments.containsKey("qpid.last_value_queue") && !wireArguments.containsKey("qpid.last_value_queue_key")) {
                    modelArguments.put("lvqKey", "qpid.LVQ_key");
                }
                if (wireArguments.containsKey("qpid.shared_msg_group")) {
                    modelArguments.put("messageGroupSharedGroups", "1".equals(String.valueOf(wireArguments.get("qpid.shared_msg_group"))));
                }
                if (wireArguments.get("x-qpid-dlq-enabled") != null) {
                    modelArguments.put("x-qpid-dlq-enabled", Boolean.parseBoolean(wireArguments.get("x-qpid-dlq-enabled").toString()));
                }
                if (wireArguments.get("no-local") != null) {
                    modelArguments.put("noLocal", Boolean.parseBoolean(wireArguments.get("no-local").toString()));
                }
            }
            return modelArguments;
        }
    }

    private class Upgrader_0_1_to_0_2
    extends StoreUpgraderPhase {
        public Upgrader_0_1_to_0_2() {
            super("modelVersion", "0.1", "0.2");
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            String type = record.getType().substring(1 + record.getType().lastIndexOf(46));
            ConfiguredObjectRecordImpl newRecord = new ConfiguredObjectRecordImpl(record.getId(), type, record.getAttributes(), record.getParents());
            this.getUpdateMap().put(record.getId(), newRecord);
            if ("VirtualHost".equals(type)) {
                this.upgradeRootRecord(newRecord);
            }
        }

        @Override
        public void complete() {
            Iterator<Map.Entry<UUID, ConfiguredObjectRecord>> iterator = this.getUpdateMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, ConfiguredObjectRecord> entry = iterator.next();
                ConfiguredObjectRecord record = entry.getValue();
                UUID exchangeParent = record.getParents().get(Exchange.class.getSimpleName());
                UUID queueParent = record.getParents().get(Queue.class.getSimpleName());
                if (!this.isBinding(record.getType()) || exchangeParent != null && !this.unknownExchange(exchangeParent) && queueParent != null && !this.unknownQueue(queueParent)) continue;
                this.getDeleteMap().put(entry.getKey(), entry.getValue());
                iterator.remove();
            }
        }

        private boolean unknownExchange(UUID exchangeId) {
            if (VirtualHostStoreUpgraderAndRecoverer.this._defaultExchangeIds.containsValue(exchangeId)) {
                return false;
            }
            ConfiguredObjectRecord localRecord = this.getUpdateMap().get(exchangeId);
            return localRecord == null || !localRecord.getType().equals(Exchange.class.getSimpleName());
        }

        private boolean unknownQueue(UUID queueId) {
            ConfiguredObjectRecord localRecord = this.getUpdateMap().get(queueId);
            return localRecord == null || !localRecord.getType().equals(Queue.class.getSimpleName());
        }

        private boolean isBinding(String type) {
            return Binding.class.getSimpleName().equals(type);
        }
    }

    private class Upgrader_0_0_to_0_1
    extends StoreUpgraderPhase {
        private final Map<UUID, ConfiguredObjectRecord> _records;

        public Upgrader_0_0_to_0_1() {
            super("modelVersion", "0.0", "0.1");
            this._records = new HashMap<UUID, ConfiguredObjectRecord>();
        }

        @Override
        public void configuredObject(ConfiguredObjectRecord record) {
            this._records.put(record.getId(), record);
        }

        private void removeSelectorArguments(Map<String, Object> binding) {
            LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>((Map)binding.get("arguments"));
            FilterSupport.removeFilters(arguments);
            binding.put("arguments", arguments);
        }

        private boolean isTopicExchange(ConfiguredObjectRecord entry) {
            UUID exchangeId = entry.getParents().get("Exchange");
            if (exchangeId == null) {
                return false;
            }
            if (this._records.containsKey(exchangeId)) {
                return "topic".equals(this._records.get(exchangeId).getAttributes().get("type"));
            }
            return ((UUID)VirtualHostStoreUpgraderAndRecoverer.this._defaultExchangeIds.get("amq.topic")).equals(exchangeId);
        }

        private boolean hasSelectorArguments(Map<String, Object> binding) {
            Map arguments = (Map)binding.get("arguments");
            return arguments != null && FilterSupport.argumentsContainFilter(arguments);
        }

        @Override
        public void complete() {
            for (Map.Entry<UUID, ConfiguredObjectRecord> entry : this._records.entrySet()) {
                ConfiguredObjectRecord record = entry.getValue();
                String type = record.getType();
                Map<String, Object> attributes = record.getAttributes();
                UUID id = record.getId();
                if ("org.apache.qpid.server.model.VirtualHost".equals(type)) {
                    this.upgradeRootRecord(record);
                    continue;
                }
                if (!type.equals(Binding.class.getName()) || !this.hasSelectorArguments(attributes) || this.isTopicExchange(record)) continue;
                attributes = new LinkedHashMap<String, Object>(attributes);
                this.removeSelectorArguments(attributes);
                record = new ConfiguredObjectRecordImpl(id, type, attributes, record.getParents());
                this.getUpdateMap().put(id, record);
                entry.setValue(record);
            }
        }
    }
}

