/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange.topic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.server.exchange.topic.TopicMatcherResult;
import org.apache.qpid.server.exchange.topic.TopicWord;
import org.apache.qpid.server.exchange.topic.TopicWordDictionary;

public class TopicMatcherDFAState {
    private static final AtomicInteger stateId = new AtomicInteger();
    private final int _id = stateId.incrementAndGet();
    private final Collection<TopicMatcherResult> _results;
    private final Map<TopicWord, TopicMatcherDFAState> _nextStateMap;
    private static final String TOPIC_DELIMITER = "\\.";

    public TopicMatcherDFAState(Map<TopicWord, TopicMatcherDFAState> nextStateMap, Collection<TopicMatcherResult> results) {
        this._nextStateMap = nextStateMap;
        this._results = results;
    }

    public TopicMatcherDFAState nextState(TopicWord word) {
        TopicMatcherDFAState nextState = this._nextStateMap.get(word);
        return nextState == null ? this._nextStateMap.get(TopicWord.ANY_WORD) : nextState;
    }

    public Collection<TopicMatcherResult> terminate() {
        return this._results;
    }

    public Collection<TopicMatcherResult> parse(TopicWordDictionary dictionary, String routingKey) {
        return this.parse(dictionary, Arrays.asList(routingKey.split(TOPIC_DELIMITER)).iterator());
    }

    private Collection<TopicMatcherResult> parse(TopicWordDictionary dictionary, Iterator<String> tokens) {
        if (!tokens.hasNext()) {
            return this._results;
        }
        TopicWord word = dictionary.getWord(tokens.next());
        TopicMatcherDFAState nextState = this._nextStateMap.get(word);
        if (nextState == null && word != TopicWord.ANY_WORD) {
            nextState = this._nextStateMap.get(TopicWord.ANY_WORD);
        }
        if (nextState == null) {
            return Collections.EMPTY_LIST;
        }
        if (nextState == this && this._nextStateMap.size() == 1 && this._nextStateMap.containsKey(TopicWord.ANY_WORD)) {
            return this._results;
        }
        return nextState.parse(dictionary, tokens);
    }

    public TopicMatcherDFAState mergeStateMachines(TopicMatcherDFAState otherStateMachine) {
        Collection<TopicMatcherResult> results;
        HashMap<Set<TopicMatcherDFAState>, TopicMatcherDFAState> newStateMap = new HashMap<Set<TopicMatcherDFAState>, TopicMatcherDFAState>();
        if (this._results.isEmpty()) {
            results = otherStateMachine._results;
        } else if (otherStateMachine._results.isEmpty()) {
            results = this._results;
        } else {
            results = new HashSet<TopicMatcherResult>(this._results);
            results.addAll(otherStateMachine._results);
        }
        HashMap<TopicWord, TopicMatcherDFAState> newNextStateMap = new HashMap<TopicWord, TopicMatcherDFAState>();
        TopicMatcherDFAState newState = new TopicMatcherDFAState(newNextStateMap, results);
        HashSet<TopicMatcherDFAState> oldStates = new HashSet<TopicMatcherDFAState>();
        oldStates.add(this);
        oldStates.add(otherStateMachine);
        newStateMap.put(oldStates, newState);
        TopicMatcherDFAState.mergeStateMachines(oldStates, newNextStateMap, newStateMap);
        return newState;
    }

    private static void mergeStateMachines(Set<TopicMatcherDFAState> oldStates, Map<TopicWord, TopicMatcherDFAState> newNextStateMap, Map<Set<TopicMatcherDFAState>, TopicMatcherDFAState> newStateMap) {
        HashMap<TopicWord, HashSet<TopicMatcherDFAState>> nfaMap = new HashMap<TopicWord, HashSet<TopicMatcherDFAState>>();
        for (TopicMatcherDFAState topicMatcherDFAState : oldStates) {
            Map<TopicWord, TopicMatcherDFAState> map = topicMatcherDFAState._nextStateMap;
            for (Map.Entry<TopicWord, TopicMatcherDFAState> entry : map.entrySet()) {
                HashSet<TopicMatcherDFAState> states = (HashSet<TopicMatcherDFAState>)nfaMap.get(entry.getKey());
                if (states == null) {
                    states = new HashSet<TopicMatcherDFAState>();
                    nfaMap.put(entry.getKey(), states);
                }
                states.add(entry.getValue());
            }
        }
        Set anyWordStates = (Set)nfaMap.get(TopicWord.ANY_WORD);
        for (Map.Entry entry : nfaMap.entrySet()) {
            TopicMatcherDFAState nextState;
            Set destinations = (Set)entry.getValue();
            if (anyWordStates != null) {
                destinations.addAll(anyWordStates);
            }
            if ((nextState = newStateMap.get(destinations)) == null) {
                if (destinations.size() == 1) {
                    nextState = (TopicMatcherDFAState)destinations.iterator().next();
                    newStateMap.put(destinations, nextState);
                } else {
                    HashSet<TopicMatcherResult> results;
                    HashSet<Collection<TopicMatcherResult>> resultSets = new HashSet<Collection<TopicMatcherResult>>();
                    for (TopicMatcherDFAState topicMatcherDFAState : destinations) {
                        resultSets.add(topicMatcherDFAState._results);
                    }
                    resultSets.remove(Collections.EMPTY_SET);
                    if (resultSets.size() == 0) {
                        results = Collections.EMPTY_SET;
                    } else if (resultSets.size() == 1) {
                        results = (Collection)resultSets.iterator().next();
                    } else {
                        results = new HashSet();
                        for (Collection collection : resultSets) {
                            results.addAll(collection);
                        }
                    }
                    HashMap<TopicWord, TopicMatcherDFAState> nextStateMap = new HashMap<TopicWord, TopicMatcherDFAState>();
                    nextState = new TopicMatcherDFAState(nextStateMap, results);
                    newStateMap.put(destinations, nextState);
                    TopicMatcherDFAState.mergeStateMachines(destinations, nextStateMap, newStateMap);
                }
            }
            newNextStateMap.put((TopicWord)entry.getKey(), nextState);
        }
        TopicMatcherDFAState topicMatcherDFAState = newNextStateMap.get(TopicWord.ANY_WORD);
        if (topicMatcherDFAState != null) {
            ArrayList<TopicWord> arrayList = new ArrayList<TopicWord>();
            for (Map.Entry<TopicWord, TopicMatcherDFAState> entry : newNextStateMap.entrySet()) {
                if (entry.getValue() != topicMatcherDFAState || entry.getKey() == TopicWord.ANY_WORD) continue;
                arrayList.add(entry.getKey());
            }
            for (TopicWord removeKey : arrayList) {
                newNextStateMap.remove(removeKey);
            }
        }
    }

    public String toString() {
        StringBuilder transitions = new StringBuilder();
        for (Map.Entry<TopicWord, TopicMatcherDFAState> entry : this._nextStateMap.entrySet()) {
            transitions.append("[ ");
            transitions.append(entry.getKey());
            transitions.append("\t ->\t ");
            transitions.append(entry.getValue().getId());
            transitions.append(" ]\n");
        }
        return "[ State " + this.getId() + " ]\n" + transitions + "\n";
    }

    public String reachableStates() {
        int count;
        StringBuilder result = new StringBuilder("Start state: " + this.getId() + "\n");
        TreeSet<TopicMatcherDFAState> reachableStates = new TreeSet<TopicMatcherDFAState>(Comparator.comparingInt(TopicMatcherDFAState::getId));
        reachableStates.add(this);
        do {
            count = reachableStates.size();
            ArrayList<TopicMatcherDFAState> originalStates = new ArrayList<TopicMatcherDFAState>(reachableStates);
            for (TopicMatcherDFAState state : originalStates) {
                reachableStates.addAll(state._nextStateMap.values());
            }
        } while (reachableStates.size() != count);
        for (TopicMatcherDFAState state : reachableStates) {
            result.append(state.toString());
        }
        return result.toString();
    }

    int getId() {
        return this._id;
    }
}

