/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.CreateLogMessage;
import org.apache.qpid.server.logging.DeleteLogMessage;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.OperationLogMessage;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.UpdateLogMessage;
import org.apache.qpid.server.model.AccessControlSource;
import org.apache.qpid.server.model.AncestorAttributeResolver;
import org.apache.qpid.server.model.AttributeValueConverter;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfigurationSecretEncrypterSource;
import org.apache.qpid.server.model.ConfiguredAutomatedAttribute;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.ConfiguredObjectMethodAttribute;
import org.apache.qpid.server.model.ConfiguredObjectStatistic;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.ConfiguredSettableAttribute;
import org.apache.qpid.server.model.DynamicModel;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.OwnAttributeResolver;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.SystemPrincipalSource;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.TaskPrincipal;
import org.apache.qpid.server.security.encryption.ConfigurationSecretEncrypter;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.preferences.UserPreferencesCreator;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfiguredObject<X extends ConfiguredObject<X>>
implements ConfiguredObject<X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfiguredObject.class);
    public static final String SECURED_STRING_VALUE = "********";
    private static final Map<Class, Object> SECURE_VALUES = Map.of(String.class, "********", Integer.class, 0, Long.class, 0L, Byte.class, (byte)0, Short.class, (short)0, Double.class, 0.0, Float.class, Float.valueOf(0.0f));
    private ConfigurationSecretEncrypter _encrypter;
    private AccessControl _parentAccessControl;
    private Principal _systemPrincipal;
    private UserPreferences _userPreferences;
    private static final DynamicStateWithFuture UNINIT = new DynamicStateWithFuture(DynamicState.UNINIT, (ListenableFuture<Void>)Futures.immediateFuture(null));
    private static final DynamicStateWithFuture OPENED = new DynamicStateWithFuture(DynamicState.OPENED, (ListenableFuture<Void>)Futures.immediateFuture(null));
    private final AtomicReference<DynamicStateWithFuture> _dynamicState = new AtomicReference<DynamicStateWithFuture>(UNINIT);
    private final Map<String, Object> _attributes = new HashMap<String, Object>();
    private final ConfiguredObject<?> _parent;
    private final Collection<ConfigurationChangeListener> _changeListeners = new ArrayList<ConfigurationChangeListener>();
    private final Map<Class<? extends ConfiguredObject>, Collection<ConfiguredObject<?>>> _children = new ConcurrentHashMap();
    private final Map<Class<? extends ConfiguredObject>, ConcurrentMap<UUID, ConfiguredObject<?>>> _childrenById = new ConcurrentHashMap();
    private final Map<Class<? extends ConfiguredObject>, ConcurrentMap<String, ConfiguredObject<?>>> _childrenByName = new ConcurrentHashMap();
    @ManagedAttributeField
    private final UUID _id;
    private final TaskExecutor _taskExecutor;
    private final Class<? extends ConfiguredObject> _category;
    private final Class<? extends ConfiguredObject> _typeClass;
    private final Class<? extends ConfiguredObject> _bestFitInterface;
    private volatile Model _model;
    private final boolean _managesChildStorage;
    @ManagedAttributeField
    private Date _createdTime;
    @ManagedAttributeField
    private String _createdBy;
    @ManagedAttributeField
    private Date _lastUpdatedTime;
    @ManagedAttributeField
    private String _lastUpdatedBy;
    @ManagedAttributeField
    private String _name;
    @ManagedAttributeField
    private Map<String, String> _context;
    @ManagedAttributeField
    private boolean _durable;
    @ManagedAttributeField
    private String _description;
    @ManagedAttributeField
    private LifetimePolicy _lifetimePolicy;
    private final Map<String, ConfiguredObjectAttribute<?, ?>> _attributeTypes;
    private final Map<String, ConfiguredObjectTypeRegistry.AutomatedField> _automatedFields;
    private final Map<State, Map<State, Method>> _stateChangeMethods;
    @ManagedAttributeField
    private String _type;
    private final OwnAttributeResolver _ownAttributeResolver = new OwnAttributeResolver(this);
    private final AncestorAttributeResolver _ancestorAttributeResolver = new AncestorAttributeResolver(this);
    @ManagedAttributeField
    private State _desiredState;
    private volatile SettableFuture<ConfiguredObject<X>> _attainStateFuture = SettableFuture.create();
    private boolean _openComplete;
    private boolean _openFailed;
    private volatile State _state = State.UNINITIALIZED;
    private volatile Date _lastOpenedTime;
    private volatile int _awaitAttainmentTimeout;
    private static final Strings.Resolver JSON_SUBSTITUTION_RESOLVER = Strings.createSubstitutionResolver("json:", Map.of("\\", "\\\\", "\"", "\\\""));

    protected AbstractConfiguredObject(ConfiguredObject<?> parent, Map<String, Object> attributes) {
        this(parent, attributes, parent.getChildExecutor());
    }

    protected AbstractConfiguredObject(ConfiguredObject<?> parent, Map<String, Object> attributes, TaskExecutor taskExecutor) {
        this(parent, attributes, taskExecutor, parent.getModel());
    }

    protected AbstractConfiguredObject(ConfiguredObject<?> parent, Map<String, Object> attributes, TaskExecutor taskExecutor, Model model) {
        AuthenticatedPrincipal currentUser;
        UUID uuid;
        this._taskExecutor = taskExecutor;
        if (taskExecutor == null) {
            throw new NullPointerException("task executor is null");
        }
        this._model = model;
        this._parent = parent;
        this._category = ConfiguredObjectTypeRegistry.getCategory(this.getClass());
        Class<? extends ConfiguredObject> typeClass = model.getTypeRegistry().getTypeClass(this.getClass());
        this._typeClass = typeClass == null ? this._category : typeClass;
        this._attributeTypes = model.getTypeRegistry().getAttributeTypes(this.getClass());
        this._automatedFields = model.getTypeRegistry().getAutomatedFields(this.getClass());
        this._stateChangeMethods = model.getTypeRegistry().getStateChangeMethods(this.getClass());
        if (this._parent instanceof AbstractConfiguredObject && ((AbstractConfiguredObject)this._parent)._encrypter != null) {
            this._encrypter = ((AbstractConfiguredObject)this._parent)._encrypter;
        } else if (this._parent instanceof ConfigurationSecretEncrypterSource && ((ConfigurationSecretEncrypterSource)((Object)this._parent)).getEncrypter() != null) {
            this._encrypter = ((ConfigurationSecretEncrypterSource)((Object)this._parent)).getEncrypter();
        }
        if (this._parent instanceof AbstractConfiguredObject && ((AbstractConfiguredObject)this._parent).getAccessControl() != null) {
            this._parentAccessControl = ((AbstractConfiguredObject)this._parent).getAccessControl();
        } else if (this._parent instanceof AccessControlSource && ((AccessControlSource)((Object)this._parent)).getAccessControl() != null) {
            this._parentAccessControl = ((AccessControlSource)((Object)this._parent)).getAccessControl();
        }
        if (this._parent instanceof AbstractConfiguredObject && ((AbstractConfiguredObject)this._parent).getSystemPrincipal() != null) {
            this._systemPrincipal = ((AbstractConfiguredObject)this._parent).getSystemPrincipal();
        } else if (this._parent instanceof SystemPrincipalSource && ((SystemPrincipalSource)((Object)this._parent)).getSystemPrincipal() != null) {
            this._systemPrincipal = ((SystemPrincipalSource)((Object)this._parent)).getSystemPrincipal();
        }
        Object idObj = attributes.get("id");
        if (idObj == null) {
            uuid = UUID.randomUUID();
            attributes = new LinkedHashMap<String, Object>(attributes);
            attributes.put("id", uuid);
        } else {
            uuid = AttributeValueConverter.UUID_CONVERTER.convert(idObj, this);
        }
        this._id = uuid;
        this._name = AttributeValueConverter.STRING_CONVERTER.convert(attributes.get("name"), this);
        if (this._name == null) {
            throw new IllegalArgumentException("The name attribute is mandatory for " + this.getClass().getSimpleName() + " creation.");
        }
        this._type = ConfiguredObjectTypeRegistry.getType(this.getClass());
        this._managesChildStorage = this.managesChildren(this._category) || this.managesChildren(this._typeClass);
        this._bestFitInterface = this.calculateBestFitInterface();
        if (attributes.get("type") != null && !this._type.equals(attributes.get("type"))) {
            throw new IllegalConfigurationException("Provided type is " + attributes.get("type") + " but calculated type is " + this._type);
        }
        if (attributes.get("type") == null) {
            attributes = new LinkedHashMap<String, Object>(attributes);
            attributes.put("type", this._type);
        }
        this.populateChildTypeMaps();
        Object durableObj = attributes.get("durable");
        this._durable = AttributeValueConverter.BOOLEAN_CONVERTER.convert(durableObj == null ? ((ConfiguredSettableAttribute)this._attributeTypes.get("durable")).defaultValue() : durableObj, this);
        for (String string : this.getAttributeNames()) {
            Object value;
            if (!attributes.containsKey(string) || (value = attributes.get(string)) == null) continue;
            this._attributes.put(string, value);
        }
        if (!this._attributes.containsKey("createdBy") && (currentUser = AuthenticatedPrincipal.getCurrentUser()) != null) {
            this._attributes.put("createdBy", currentUser.getName());
        }
        if (!this._attributes.containsKey("createdTime")) {
            this._attributes.put("createdTime", System.currentTimeMillis());
        }
        for (ConfiguredObjectAttribute configuredObjectAttribute : this._attributeTypes.values()) {
            ConfiguredSettableAttribute autoAttr;
            if (configuredObjectAttribute.isDerived() || !(autoAttr = (ConfiguredSettableAttribute)configuredObjectAttribute).isMandatory() || this._attributes.containsKey(configuredObjectAttribute.getName()) || !"".equals(autoAttr.defaultValue())) continue;
            this.deleted();
            throw new IllegalArgumentException("Mandatory attribute " + configuredObjectAttribute.getName() + " not supplied for instance of " + this.getClass().getName());
        }
    }

    protected final void updateModel(Model model) {
        if (!(this instanceof DynamicModel && this._children.isEmpty() && this._model.getChildTypes(this.getCategoryClass()).isEmpty() && Model.isSpecialization(this._model, model, this.getCategoryClass()))) {
            throw new IllegalStateException("Cannot change the model of a class which does not implement DynamicModel, or has defined child types");
        }
        this._model = model;
        this.populateChildTypeMaps();
    }

    private void populateChildTypeMaps() {
        if (!(this._children.isEmpty() && this._childrenById.isEmpty() && this._childrenByName.isEmpty())) {
            throw new IllegalStateException("Cannot update the child type maps on a class with pre-existing child types");
        }
        for (Class<? extends ConfiguredObject> childClass : this.getModel().getChildTypes(this.getCategoryClass())) {
            this._children.put(childClass, new CopyOnWriteArrayList());
            this._childrenById.put(childClass, new ConcurrentHashMap());
            this._childrenByName.put(childClass, new ConcurrentHashMap());
        }
    }

    private boolean managesChildren(Class<? extends ConfiguredObject> clazz) {
        return clazz.getAnnotation(ManagedObject.class).managesChildren();
    }

    private Class<? extends ConfiguredObject> calculateBestFitInterface() {
        HashSet<Class<? extends ConfiguredObject>> candidates = new HashSet<Class<? extends ConfiguredObject>>();
        AbstractConfiguredObject.findBestFitInterface(this.getClass(), candidates);
        switch (candidates.size()) {
            case 0: {
                throw new ServerScopedRuntimeException("The configured object class " + this.getClass().getSimpleName() + " does not seem to implement an interface");
            }
            case 1: {
                return (Class)candidates.iterator().next();
            }
        }
        ArrayList<Class<? extends ConfiguredObject>> list = new ArrayList<Class<? extends ConfiguredObject>>(candidates);
        throw new ServerScopedRuntimeException("The configured object class " + this.getClass().getSimpleName() + " implements no single common interface which extends ConfiguredObject Identified candidates were : " + Arrays.toString(list.toArray()));
    }

    private static final void findBestFitInterface(Class<? extends ConfiguredObject> clazz, Set<Class<? extends ConfiguredObject>> candidates) {
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            if (!ConfiguredObject.class.isAssignableFrom(interfaceClass)) continue;
            AbstractConfiguredObject.checkCandidate(interfaceClass, candidates);
        }
        if (clazz.getSuperclass() != null && ConfiguredObject.class.isAssignableFrom(clazz.getSuperclass())) {
            AbstractConfiguredObject.findBestFitInterface(clazz.getSuperclass(), candidates);
        }
    }

    private static void checkCandidate(Class<? extends ConfiguredObject> interfaceClass, Set<Class<? extends ConfiguredObject>> candidates) {
        if (!candidates.contains(interfaceClass)) {
            Iterator<Class<? extends ConfiguredObject>> candidateIterator = candidates.iterator();
            while (candidateIterator.hasNext()) {
                Class<? extends ConfiguredObject> existingCandidate = candidateIterator.next();
                if (existingCandidate.isAssignableFrom(interfaceClass)) {
                    candidateIterator.remove();
                    continue;
                }
                if (!interfaceClass.isAssignableFrom(existingCandidate)) continue;
                return;
            }
            candidates.add(interfaceClass);
        }
    }

    private void automatedSetValue(String name, Object value) {
        try {
            ConfiguredAutomatedAttribute attribute = (ConfiguredAutomatedAttribute)this._attributeTypes.get(name);
            if (value == null && !"".equals(attribute.defaultValue())) {
                value = attribute.defaultValue();
            }
            ConfiguredObjectTypeRegistry.AutomatedField field = this._automatedFields.get(name);
            Object desiredValue = attribute.convert(value, this);
            field.set(this, desiredValue);
        }
        catch (IllegalAccessException e) {
            throw new ServerScopedRuntimeException("Unable to set the automated attribute " + name + " on the configure object type " + this.getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new ServerScopedRuntimeException("Unable to set the automated attribute " + name + " on the configure object type " + this.getClass().getName(), e);
        }
    }

    private boolean checkValidValues(ConfiguredSettableAttribute attribute, Object desiredValue) {
        for (String validValue : attribute.validValues()) {
            Object convertedValidValue = attribute.getConverter().convert(validValue, this);
            if (!convertedValidValue.equals(desiredValue)) continue;
            return true;
        }
        return false;
    }

    private boolean checkValidValuePattern(ConfiguredSettableAttribute attribute, Object desiredValue) {
        ParameterizedType paramType;
        Collection<String> valuesToCheck = attribute.getType().equals(String.class) ? Collections.singleton(desiredValue.toString()) : (Collection.class.isAssignableFrom(attribute.getType()) && attribute.getGenericType() instanceof ParameterizedType ? ((paramType = (ParameterizedType)attribute.getGenericType()).getActualTypeArguments().length == 1 && paramType.getActualTypeArguments()[0] == String.class ? (Collection)desiredValue : Set.of()) : Set.of());
        Pattern pattern = Pattern.compile(attribute.validValuePattern());
        for (String value : valuesToCheck) {
            if (pattern.matcher(value).matches()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void open() {
        this.doSync(this.openAsync());
    }

    @Override
    public final ListenableFuture<Void> openAsync() {
        return this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){

            @Override
            public ListenableFuture<Void> execute() {
                if (AbstractConfiguredObject.this._dynamicState.compareAndSet(UNINIT, OPENED)) {
                    AbstractConfiguredObject.this._openFailed = false;
                    OpenExceptionHandler exceptionHandler = new OpenExceptionHandler();
                    try {
                        AbstractConfiguredObject.this.doResolution(true, exceptionHandler);
                        AbstractConfiguredObject.this.doValidation(true, exceptionHandler);
                        AbstractConfiguredObject.this.doOpening(true, exceptionHandler);
                        return AbstractConfiguredObject.this.doAttainState(exceptionHandler, object -> object.logRecovered(Outcome.SUCCESS));
                    }
                    catch (RuntimeException e) {
                        exceptionHandler.handleException(e, AbstractConfiguredObject.this);
                        return Futures.immediateFuture(null);
                    }
                }
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return AbstractConfiguredObject.this.toString();
            }

            @Override
            public String getAction() {
                return "open";
            }

            @Override
            public String getArguments() {
                return null;
            }
        });
    }

    protected final <T, E extends Exception> ListenableFuture<T> doOnConfigThread(final Task<ListenableFuture<T>, E> task) {
        final SettableFuture returnVal = SettableFuture.create();
        this._taskExecutor.submit(new Task<Void, RuntimeException>(){

            @Override
            public Void execute() {
                try {
                    AbstractConfiguredObject.addFutureCallback((ListenableFuture)task.execute(), new FutureCallback<T>(){

                        public void onSuccess(T result) {
                            returnVal.set(result);
                        }

                        public void onFailure(Throwable t) {
                            returnVal.setException(t);
                        }
                    }, AbstractConfiguredObject.this.getTaskExecutor());
                }
                catch (Throwable t) {
                    returnVal.setException(t);
                }
                return null;
            }

            @Override
            public String getObject() {
                return task.getObject();
            }

            @Override
            public String getAction() {
                return task.getAction();
            }

            @Override
            public String getArguments() {
                return task.getArguments();
            }
        });
        return returnVal;
    }

    public void registerWithParents() {
        if (this._parent instanceof AbstractConfiguredObject) {
            ((AbstractConfiguredObject)this._parent).registerChild(this);
        } else if (this._parent instanceof AbstractConfiguredObjectProxy) {
            ((AbstractConfiguredObjectProxy)((Object)this._parent)).registerChild(this);
        }
    }

    protected final ListenableFuture<Void> closeChildren() {
        ArrayList childCloseFutures = new ArrayList();
        this.applyToChildren(child -> {
            ListenableFuture<Void> childCloseFuture = child.closeAsync();
            AbstractConfiguredObject.addFutureCallback(childCloseFuture, new FutureCallback<Void>(){

                public void onSuccess(Void result) {
                }

                public void onFailure(Throwable t) {
                    LOGGER.error("Exception occurred while closing {} : {}", new Object[]{child.getClass().getSimpleName(), child.getName(), t});
                }
            }, this.getTaskExecutor());
            childCloseFutures.add(childCloseFuture);
        });
        ListenableFuture combinedFuture = Futures.allAsList(childCloseFutures);
        return this.doAfter(combinedFuture, () -> {
            for (Collection<ConfiguredObject<?>> collection : this._children.values()) {
                collection.clear();
            }
            for (Map map : this._childrenById.values()) {
                map.clear();
            }
            for (Map map : this._childrenByName.values()) {
                map.clear();
            }
            LOGGER.debug("All children closed {} : {}", (Object)this.getClass().getSimpleName(), (Object)this.getName());
        });
    }

    @Override
    public void close() {
        this.doSync(this.closeAsync());
    }

    @Override
    public final ListenableFuture<Void> closeAsync() {
        return this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){

            @Override
            public ListenableFuture<Void> execute() {
                DynamicStateWithFuture currentStateWithFuture;
                LOGGER.debug("Closing " + AbstractConfiguredObject.this.getClass().getSimpleName() + " : " + AbstractConfiguredObject.this.getName());
                final SettableFuture returnFuture = SettableFuture.create();
                DynamicStateWithFuture desiredStateWithFuture = new DynamicStateWithFuture(DynamicState.CLOSED, (ListenableFuture<Void>)returnFuture);
                while ((currentStateWithFuture = AbstractConfiguredObject.this._dynamicState.get()) == OPENED) {
                    if (!AbstractConfiguredObject.this._dynamicState.compareAndSet(OPENED, desiredStateWithFuture)) continue;
                    ChainedListenableFuture<Void> future = AbstractConfiguredObject.this.doAfter(AbstractConfiguredObject.this.beforeClose(), () -> AbstractConfiguredObject.this.closeChildren()).then(() -> AbstractConfiguredObject.this.onClose()).then(() -> {
                        AbstractConfiguredObject.this.unregister(false);
                        LOGGER.debug("Closed " + AbstractConfiguredObject.this.getClass().getSimpleName() + " : " + AbstractConfiguredObject.this.getName());
                        return Futures.immediateFuture(null);
                    });
                    AbstractConfiguredObject.addFutureCallback(future, new FutureCallback<Void>(){

                        public void onSuccess(Void result) {
                            returnFuture.set(null);
                        }

                        public void onFailure(Throwable t) {
                            returnFuture.setException(t);
                        }
                    }, MoreExecutors.directExecutor());
                    return returnFuture;
                }
                return currentStateWithFuture.getFuture();
            }

            @Override
            public String getObject() {
                return AbstractConfiguredObject.this.toString();
            }

            @Override
            public String getAction() {
                return "close";
            }

            @Override
            public String getArguments() {
                return null;
            }
        });
    }

    protected ListenableFuture<Void> beforeClose() {
        return Futures.immediateFuture(null);
    }

    protected ListenableFuture<Void> onClose() {
        return Futures.immediateFuture(null);
    }

    public final void create() {
        this.doSync(this.createAsync());
    }

    public final ListenableFuture<Void> createAsync() {
        return this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){

            @Override
            public ListenableFuture<Void> execute() {
                if (AbstractConfiguredObject.this._dynamicState.compareAndSet(UNINIT, OPENED)) {
                    AbstractConfiguredObject.this.initializeAttributes();
                    CreateExceptionHandler createExceptionHandler = new CreateExceptionHandler();
                    try {
                        AbstractConfiguredObject.this.doResolution(true, createExceptionHandler);
                        AbstractConfiguredObject.this.doValidation(true, createExceptionHandler);
                        AbstractConfiguredObject.this.validateOnCreate();
                        AbstractConfiguredObject.this.registerWithParents();
                        AbstractConfiguredObject.this.createUserPreferences();
                    }
                    catch (RuntimeException e) {
                        createExceptionHandler.handleException(e, AbstractConfiguredObject.this);
                    }
                    CreateExceptionHandler unregisteringExceptionHandler = new CreateExceptionHandler(true);
                    try {
                        AbstractConfiguredObject.this.doCreation(true, unregisteringExceptionHandler);
                        AbstractConfiguredObject.this.doOpening(true, unregisteringExceptionHandler);
                        return AbstractConfiguredObject.this.doAttainState(unregisteringExceptionHandler, object -> object.logCreated(AbstractConfiguredObject.this.getActualAttributes(), Outcome.SUCCESS));
                    }
                    catch (RuntimeException e) {
                        unregisteringExceptionHandler.handleException(e, AbstractConfiguredObject.this);
                    }
                }
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return AbstractConfiguredObject.this.toString();
            }

            @Override
            public String getAction() {
                return "create";
            }

            @Override
            public String getArguments() {
                return null;
            }
        });
    }

    private void createUserPreferences() {
        if (this instanceof UserPreferencesCreator) {
            return;
        }
        UserPreferencesCreator preferenceCreator = this.getAncestor(UserPreferencesCreator.class);
        if (preferenceCreator != null) {
            UserPreferences userPreferences = preferenceCreator.createUserPreferences(this);
            this.setUserPreferences(userPreferences);
        }
    }

    private void initializeAttributes() {
        AuthenticatedPrincipal currentUser = AuthenticatedPrincipal.getCurrentUser();
        if (currentUser != null) {
            String currentUserName = currentUser.getName();
            this._attributes.put("lastUpdatedBy", currentUserName);
            this._attributes.put("createdBy", currentUserName);
        }
        Date currentTime = new Date();
        this._attributes.put("lastUpdatedTime", currentTime);
        this._attributes.put("createdTime", currentTime);
        ConfiguredObject<?> proxyForInitialization = null;
        for (ConfiguredObjectAttribute<?, ?> attr : this._attributeTypes.values()) {
            boolean hasDefault;
            if (attr.isDerived()) continue;
            ConfiguredSettableAttribute autoAttr = (ConfiguredSettableAttribute)attr;
            boolean isPresent = this._attributes.containsKey(attr.getName());
            boolean bl = hasDefault = !"".equals(autoAttr.defaultValue());
            if (isPresent || !hasDefault) continue;
            switch (autoAttr.getInitialization()) {
                case copy: {
                    this._attributes.put(autoAttr.getName(), autoAttr.defaultValue());
                    break;
                }
                case materialize: {
                    if (proxyForInitialization == null) {
                        proxyForInitialization = this.createProxyForInitialization(this._attributes);
                    }
                    this._attributes.put(autoAttr.getName(), autoAttr.convert(autoAttr.defaultValue(), proxyForInitialization));
                }
            }
        }
    }

    protected void validateOnCreate() {
    }

    protected boolean rethrowRuntimeExceptionsOnOpen() {
        return false;
    }

    protected final void handleExceptionOnOpen(RuntimeException e) {
        if (this.rethrowRuntimeExceptionsOnOpen() || e instanceof ServerScopedRuntimeException) {
            throw e;
        }
        LOGGER.error("Failed to open object with name '" + this.getName() + "'.  Object will be put into ERROR state.", (Throwable)e);
        try {
            this.onExceptionInOpen(e);
        }
        catch (RuntimeException re) {
            LOGGER.error("Unexpected exception while handling exception on open for " + this.getName(), (Throwable)e);
        }
        if (!this._openComplete) {
            this._openFailed = true;
            this._dynamicState.compareAndSet(OPENED, UNINIT);
        }
        this.setState(State.ERRORED);
    }

    protected void onExceptionInOpen(RuntimeException e) {
    }

    private ListenableFuture<Void> doAttainState(final AbstractConfiguredObjectExceptionHandler exceptionHandler, final Action<AbstractConfiguredObject<?>> postAction) {
        ArrayList childStateFutures = new ArrayList();
        this.applyToChildren(child -> {
            if (child instanceof AbstractConfiguredObject) {
                AbstractConfiguredObject abstractConfiguredChild = (AbstractConfiguredObject)child;
                if (abstractConfiguredChild._dynamicState.get().getDynamicState() == DynamicState.OPENED) {
                    AbstractConfiguredObject configuredObject = abstractConfiguredChild;
                    childStateFutures.add(configuredObject.doAttainState(exceptionHandler, postAction));
                }
            } else if (child instanceof AbstractConfiguredObjectProxy && ((AbstractConfiguredObjectProxy)((Object)child)).getDynamicState() == DynamicState.OPENED) {
                AbstractConfiguredObjectProxy configuredObject = (AbstractConfiguredObjectProxy)((Object)child);
                childStateFutures.add(configuredObject.doAttainState(exceptionHandler));
            }
        });
        ListenableFuture combinedChildStateFuture = Futures.allAsList(childStateFutures);
        final SettableFuture returnVal = SettableFuture.create();
        AbstractConfiguredObject.addFutureCallback(combinedChildStateFuture, new FutureCallback<List<Void>>(){

            public void onSuccess(List<Void> result) {
                try {
                    AbstractConfiguredObject.addFutureCallback(AbstractConfiguredObject.this.attainState(), new FutureCallback<Void>(){

                        public void onSuccess(Void result1) {
                            postAction.performAction(AbstractConfiguredObject.this);
                            returnVal.set(null);
                        }

                        public void onFailure(Throwable t) {
                            try {
                                if (t instanceof RuntimeException) {
                                    try {
                                        exceptionHandler.handleException((RuntimeException)t, AbstractConfiguredObject.this);
                                        returnVal.set(null);
                                    }
                                    catch (RuntimeException r) {
                                        returnVal.setException((Throwable)r);
                                    }
                                }
                            }
                            finally {
                                if (!returnVal.isDone()) {
                                    returnVal.setException(t);
                                }
                            }
                        }
                    }, AbstractConfiguredObject.this.getTaskExecutor());
                }
                catch (RuntimeException e) {
                    try {
                        exceptionHandler.handleException(e, AbstractConfiguredObject.this);
                        returnVal.set(null);
                    }
                    catch (Throwable t) {
                        returnVal.setException(t);
                    }
                }
            }

            public void onFailure(Throwable t) {
                returnVal.setException(t);
            }
        }, this.getTaskExecutor());
        return returnVal;
    }

    protected final void doOpening(boolean skipCheck, AbstractConfiguredObjectExceptionHandler exceptionHandler) {
        if (skipCheck || this._dynamicState.compareAndSet(UNINIT, OPENED)) {
            this.onOpen();
            this.notifyStateChanged(State.UNINITIALIZED, this.getState());
            this.applyToChildren(child -> {
                if (child.getState() != State.ERRORED) {
                    try {
                        if (child instanceof AbstractConfiguredObject) {
                            AbstractConfiguredObject configuredObject = (AbstractConfiguredObject)child;
                            configuredObject.doOpening(false, exceptionHandler);
                        } else if (child instanceof AbstractConfiguredObjectProxy) {
                            AbstractConfiguredObjectProxy configuredObject = (AbstractConfiguredObjectProxy)((Object)child);
                            configuredObject.doOpening(false, exceptionHandler);
                        }
                    }
                    catch (RuntimeException e) {
                        exceptionHandler.handleException(e, (ConfiguredObject<?>)child);
                    }
                }
            });
            this._openComplete = true;
            this._lastOpenedTime = new Date();
        }
    }

    protected final void doValidation(boolean skipCheck, AbstractConfiguredObjectExceptionHandler exceptionHandler) {
        if (skipCheck || this._dynamicState.get().getDynamicState() != DynamicState.OPENED) {
            this.applyToChildren(child -> {
                if (child.getState() != State.ERRORED) {
                    try {
                        if (child instanceof AbstractConfiguredObject) {
                            AbstractConfiguredObject configuredObject = (AbstractConfiguredObject)child;
                            configuredObject.doValidation(false, exceptionHandler);
                        } else if (child instanceof AbstractConfiguredObjectProxy) {
                            AbstractConfiguredObjectProxy configuredObject = (AbstractConfiguredObjectProxy)((Object)child);
                            configuredObject.doValidation(false, exceptionHandler);
                        }
                    }
                    catch (RuntimeException e) {
                        exceptionHandler.handleException(e, (ConfiguredObject<?>)child);
                    }
                }
            });
            this.onValidate();
        }
    }

    protected final void doResolution(boolean skipCheck, AbstractConfiguredObjectExceptionHandler exceptionHandler) {
        if (skipCheck || this._dynamicState.get().getDynamicState() != DynamicState.OPENED) {
            this.onResolve();
            this.postResolve();
            this.applyToChildren(child -> {
                try {
                    if (child instanceof AbstractConfiguredObject) {
                        AbstractConfiguredObject configuredObject = (AbstractConfiguredObject)child;
                        configuredObject.doResolution(false, exceptionHandler);
                    } else if (child instanceof AbstractConfiguredObjectProxy) {
                        AbstractConfiguredObjectProxy configuredObject = (AbstractConfiguredObjectProxy)((Object)child);
                        configuredObject.doResolution(false, exceptionHandler);
                    }
                }
                catch (RuntimeException e) {
                    exceptionHandler.handleException(e, (ConfiguredObject<?>)child);
                }
            });
            this.postResolveChildren();
        }
    }

    protected void postResolveChildren() {
    }

    protected void postResolve() {
        if (this.getActualAttributes().get("createdBy") != null) {
            this._createdBy = (String)this.getActualAttributes().get("createdBy");
        }
        if (this.getActualAttributes().get("createdTime") != null) {
            this._createdTime = AttributeValueConverter.DATE_CONVERTER.convert(this.getActualAttributes().get("createdTime"), this);
        }
        if (this.getActualAttributes().get("lastUpdatedBy") != null) {
            this._lastUpdatedBy = (String)this.getActualAttributes().get("lastUpdatedBy");
        }
        if (this.getActualAttributes().get("lastUpdatedTime") != null) {
            this._lastUpdatedTime = AttributeValueConverter.DATE_CONVERTER.convert(this.getActualAttributes().get("lastUpdatedTime"), this);
        }
    }

    protected final void doCreation(boolean skipCheck, AbstractConfiguredObjectExceptionHandler exceptionHandler) {
        if (skipCheck || this._dynamicState.get().getDynamicState() != DynamicState.OPENED) {
            this.onCreate();
            this.applyToChildren(child -> {
                try {
                    if (child instanceof AbstractConfiguredObject) {
                        AbstractConfiguredObject configuredObject = (AbstractConfiguredObject)child;
                        configuredObject.doCreation(false, exceptionHandler);
                    } else if (child instanceof AbstractConfiguredObjectProxy) {
                        AbstractConfiguredObjectProxy configuredObject = (AbstractConfiguredObjectProxy)((Object)child);
                        configuredObject.doCreation(false, exceptionHandler);
                    }
                }
                catch (RuntimeException e) {
                    exceptionHandler.handleException(e, (ConfiguredObject<?>)child);
                }
            });
        }
    }

    protected void applyToChildren(Action<ConfiguredObject<?>> action) {
        for (Class<? extends ConfiguredObject> childClass : this.getModel().getChildTypes(this.getCategoryClass())) {
            Collection<? extends ConfiguredObject> children = this.getChildren(childClass);
            if (children == null) continue;
            for (ConfiguredObject configuredObject : children) {
                action.performAction(configuredObject);
            }
        }
    }

    public void onValidate() {
        for (ConfiguredObjectAttribute<?, ?> attr : this._attributeTypes.values()) {
            Object desiredValueOrDefault;
            if (attr.isDerived()) continue;
            ConfiguredSettableAttribute autoAttr = (ConfiguredSettableAttribute)attr;
            if (autoAttr.hasValidValues()) {
                desiredValueOrDefault = autoAttr.getValue(this);
                if (desiredValueOrDefault != null && !this.checkValidValues(autoAttr, desiredValueOrDefault)) {
                    throw new IllegalConfigurationException("Attribute '" + autoAttr.getName() + "' instance of " + this.getClass().getName() + " named '" + this.getName() + "' cannot have value '" + desiredValueOrDefault + "'. Valid values are: " + autoAttr.validValues());
                }
            } else if (!"".equals(autoAttr.validValuePattern()) && (desiredValueOrDefault = autoAttr.getValue(this)) != null && !this.checkValidValuePattern(autoAttr, desiredValueOrDefault)) {
                throw new IllegalConfigurationException("Attribute '" + autoAttr.getName() + "' instance of " + this.getClass().getName() + " named '" + this.getName() + "' cannot have value '" + desiredValueOrDefault + "'. Valid values pattern is: " + autoAttr.validValuePattern());
            }
            if (!autoAttr.isMandatory() || autoAttr.getValue(this) != null) continue;
            throw new IllegalConfigurationException("Attribute '" + autoAttr.getName() + "' instance of " + this.getClass().getName() + " named '" + this.getName() + "' cannot be null, as it is mandatory");
        }
    }

    protected final void setEncrypter(ConfigurationSecretEncrypter encrypter) {
        this._encrypter = encrypter;
        this.applyToChildren(object -> {
            if (object instanceof AbstractConfiguredObject) {
                ((AbstractConfiguredObject)object).setEncrypter(encrypter);
            }
        });
    }

    protected void onResolve() {
        HashSet unresolved = new HashSet();
        HashSet derived = new HashSet();
        for (ConfiguredObjectAttribute<?, ?> attr : this._attributeTypes.values()) {
            if (attr.isDerived()) {
                derived.add(attr);
                continue;
            }
            unresolved.add(attr);
        }
        ConfiguredObjectAttribute<?, ?> contextAttribute = this._attributeTypes.get("context");
        if (contextAttribute != null && !contextAttribute.isDerived()) {
            if (contextAttribute.isAutomated()) {
                this.resolveAutomatedAttribute((ConfiguredSettableAttribute)contextAttribute);
            }
            unresolved.remove(contextAttribute);
        }
        boolean changed = true;
        while (!unresolved.isEmpty() || !changed) {
            changed = false;
            Iterator attrIter = unresolved.iterator();
            while (attrIter.hasNext()) {
                ConfiguredObjectAttribute attr = (ConfiguredObjectAttribute)attrIter.next();
                if (this.dependsOn(attr, unresolved) || !derived.isEmpty() && this.dependsOn(attr, derived)) continue;
                if (attr.isAutomated()) {
                    this.resolveAutomatedAttribute((ConfiguredSettableAttribute)attr);
                }
                attrIter.remove();
                changed = true;
            }
            if (changed || derived.isEmpty()) continue;
            changed = true;
            derived.clear();
        }
    }

    private boolean dependsOn(ConfiguredObjectAttribute<?, ?> attr, Set<ConfiguredObjectAttribute<?, ?>> unresolved) {
        String interpolated;
        Object value = this._attributes.get(attr.getName());
        if (value == null && !"".equals(((ConfiguredSettableAttribute)attr).defaultValue())) {
            value = ((ConfiguredSettableAttribute)attr).defaultValue();
        }
        if (value instanceof String && (interpolated = AbstractConfiguredObject.interpolate(this, (String)value)).contains("${this:")) {
            for (ConfiguredObjectAttribute<?, ?> unresolvedAttr : unresolved) {
                if (!interpolated.contains("${this:" + unresolvedAttr.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void resolveAutomatedAttribute(ConfiguredSettableAttribute<?, ?> autoAttr) {
        String attrName = autoAttr.getName();
        if (this._attributes.containsKey(attrName)) {
            this.automatedSetValue(attrName, this._attributes.get(attrName));
        } else if (!"".equals(autoAttr.defaultValue())) {
            this.automatedSetValue(attrName, autoAttr.defaultValue());
        }
    }

    private ListenableFuture<Void> attainStateIfOpenedOrReopenFailed() {
        if (this._openComplete || this.getDesiredState() == State.DELETED) {
            return this.attainState();
        }
        if (this._openFailed) {
            return this.openAsync();
        }
        return Futures.immediateFuture(null);
    }

    protected void onOpen() {
    }

    protected ListenableFuture<Void> attainState() {
        return this.attainState(this.getDesiredState());
    }

    private ListenableFuture<Void> attainState(State desiredState) {
        ListenableFuture returnVal;
        final State currentState = this.getState();
        if (this._attainStateFuture.isDone()) {
            this._attainStateFuture = SettableFuture.create();
        }
        if (currentState != desiredState) {
            Method stateChangingMethod = this.getStateChangeMethod(currentState, desiredState);
            if (stateChangingMethod != null) {
                try {
                    final SettableFuture stateTransitionResult = SettableFuture.create();
                    ListenableFuture stateTransitionFuture = (ListenableFuture)stateChangingMethod.invoke((Object)this, new Object[0]);
                    AbstractConfiguredObject.addFutureCallback(stateTransitionFuture, new FutureCallback<Void>(){

                        public void onSuccess(Void result) {
                            try {
                                if (AbstractConfiguredObject.this.getState() != currentState) {
                                    AbstractConfiguredObject.this.notifyStateChanged(currentState, AbstractConfiguredObject.this.getState());
                                }
                                stateTransitionResult.set(null);
                            }
                            catch (Throwable e) {
                                stateTransitionResult.setException(e);
                            }
                            finally {
                                AbstractConfiguredObject.this._attainStateFuture.set((Object)AbstractConfiguredObject.this);
                            }
                        }

                        public void onFailure(Throwable t) {
                            AbstractConfiguredObject.this._attainStateFuture.set((Object)AbstractConfiguredObject.this);
                            stateTransitionResult.setException(t);
                        }
                    }, this.getTaskExecutor());
                    returnVal = stateTransitionResult;
                }
                catch (IllegalAccessException e) {
                    throw new ServerScopedRuntimeException("Unexpected access exception when calling state transition", e);
                }
                catch (InvocationTargetException e) {
                    this._attainStateFuture.set((Object)this);
                    Throwable underlying = e.getTargetException();
                    if (underlying instanceof RuntimeException) {
                        throw (RuntimeException)underlying;
                    }
                    if (underlying instanceof Error) {
                        throw (Error)underlying;
                    }
                    throw new ServerScopedRuntimeException("Unexpected checked exception when calling state transition", underlying);
                }
            } else {
                returnVal = Futures.immediateFuture(null);
                this._attainStateFuture.set((Object)this);
            }
        } else {
            returnVal = Futures.immediateFuture(null);
            this._attainStateFuture.set((Object)this);
        }
        return returnVal;
    }

    private Method getStateChangeMethod(State currentState, State desiredState) {
        Map<State, Method> stateChangeMethodMap = this._stateChangeMethods.get((Object)currentState);
        Method method = null;
        if (stateChangeMethodMap != null) {
            method = stateChangeMethodMap.get((Object)desiredState);
        }
        return method;
    }

    protected void onCreate() {
    }

    @Override
    public final UUID getId() {
        return this._id;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final boolean isDurable() {
        return this._durable;
    }

    @Override
    public final ConfiguredObjectFactory getObjectFactory() {
        return this.getModel().getObjectFactory();
    }

    @Override
    public final Model getModel() {
        return this._model;
    }

    @Override
    public Class<? extends ConfiguredObject> getCategoryClass() {
        return this._category;
    }

    @Override
    public Class<? extends ConfiguredObject> getTypeClass() {
        return this._typeClass;
    }

    @Override
    public boolean managesChildStorage() {
        return this._managesChildStorage;
    }

    @Override
    public Map<String, String> getContext() {
        return this._context == null ? Map.of() : Collections.unmodifiableMap(this._context);
    }

    @Override
    public State getDesiredState() {
        return this._desiredState;
    }

    private ListenableFuture<Void> setDesiredState(final State desiredState) throws IllegalStateTransitionException, AccessControlException {
        return this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){

            @Override
            public ListenableFuture<Void> execute() {
                State state = AbstractConfiguredObject.this.getState();
                State currentDesiredState = AbstractConfiguredObject.this.getDesiredState();
                if (desiredState == currentDesiredState && desiredState != state) {
                    return AbstractConfiguredObject.this.doAfter(AbstractConfiguredObject.this.attainStateIfOpenedOrReopenFailed(), () -> {
                        State currentState = AbstractConfiguredObject.this.getState();
                        if (currentState != state) {
                            AbstractConfiguredObject.this.notifyStateChanged(state, currentState);
                        }
                    });
                }
                if (desiredState == State.DELETED) {
                    return AbstractConfiguredObject.this.deleteAsync();
                }
                Map<String, State> attributes = Collections.singletonMap("desiredState", desiredState);
                ConfiguredObject<?> proxyForValidation = AbstractConfiguredObject.this.createProxyForValidation(attributes);
                AbstractConfiguredObject.this.authoriseSetAttributes(proxyForValidation, attributes);
                AbstractConfiguredObject.this.validateChange(proxyForValidation, attributes.keySet());
                if (AbstractConfiguredObject.this.changeAttribute("desiredState", (Object)desiredState)) {
                    AbstractConfiguredObject.this.attributeSet("desiredState", (Object)currentDesiredState, (Object)desiredState);
                    return AbstractConfiguredObject.this.attainStateIfOpenedOrReopenFailed();
                }
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return AbstractConfiguredObject.this.toString();
            }

            @Override
            public String getAction() {
                return "set desired state";
            }

            @Override
            public String getArguments() {
                return String.valueOf((Object)desiredState);
            }
        });
    }

    protected void validateChildDelete(ConfiguredObject<?> child) {
    }

    @Override
    public State getState() {
        return this._state;
    }

    protected void setState(State state) {
        this._state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateChanged(State currentState, State desiredState) {
        ArrayList<ConfigurationChangeListener> copy;
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
        }
        for (ConfigurationChangeListener listener : copy) {
            listener.stateChanged(this, currentState, desiredState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ConfigurationChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot add a null listener");
        }
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            if (!this._changeListeners.contains(listener)) {
                this._changeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChangeListener(ConfigurationChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot remove a null listener");
        }
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            return this._changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void childAdded(ConfiguredObject<?> child) {
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            ArrayList<ConfigurationChangeListener> copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
            for (ConfigurationChangeListener listener : copy) {
                listener.childAdded(this, child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void childRemoved(ConfiguredObject<?> child) {
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            ArrayList<ConfigurationChangeListener> copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
            for (ConfigurationChangeListener listener : copy) {
                listener.childRemoved(this, child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attributeSet(String attributeName, Object oldAttributeValue, Object newAttributeValue) {
        AuthenticatedPrincipal currentUser = AuthenticatedPrincipal.getCurrentUser();
        if (currentUser != null) {
            this._attributes.put("lastUpdatedBy", currentUser.getName());
            this._lastUpdatedBy = currentUser.getName();
        }
        Date currentTime = new Date();
        this._attributes.put("lastUpdatedTime", currentTime);
        this._lastUpdatedTime = currentTime;
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            ArrayList<ConfigurationChangeListener> copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
            for (ConfigurationChangeListener listener : copy) {
                listener.attributeSet(this, attributeName, oldAttributeValue, newAttributeValue);
            }
        }
    }

    @Override
    public final Object getAttribute(String name) {
        ConfiguredObjectAttribute<?, ?> attr = this._attributeTypes.get(name);
        if (attr != null) {
            Object value = attr.getValue(this);
            if (value != null && !this.isSystemProcess() && attr.isSecureValue(value)) {
                return SECURE_VALUES.get(value.getClass());
            }
            return value;
        }
        throw new IllegalArgumentException("Unknown attribute: '" + name + "'");
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return this._lifetimePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Object> getActualAttributes() {
        Map<String, Object> map = this._attributes;
        synchronized (map) {
            return new HashMap<String, Object>(this._attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getActualAttribute(String name) {
        Map<String, Object> map = this._attributes;
        synchronized (map) {
            return this._attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeAttribute(String name, Object desired) {
        Map<String, Object> map = this._attributes;
        synchronized (map) {
            Object actualValue = this._attributes.get(name);
            ConfiguredObjectAttribute<?, ?> attr = this._attributeTypes.get(name);
            if (attr.updateAttributeDespiteUnchangedValue() || actualValue != null && !actualValue.equals(desired) || actualValue == null && desired != null) {
                this._attributes.put(name, desired);
                if (attr != null && attr.isAutomated()) {
                    this.automatedSetValue(name, desired);
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public ConfiguredObject<?> getParent() {
        return this._parent;
    }

    public final <T> T getAncestor(Class<T> clazz) {
        return this.getModel().getAncestor(clazz, this);
    }

    @Override
    public final Collection<String> getAttributeNames() {
        return this.getTypeRegistry().getAttributeNames(this.getClass());
    }

    public String toString() {
        return this.getCategoryClass().getSimpleName() + "[id=" + this._id + ", name=" + this.getName() + ", type=" + this.getType() + "]";
    }

    @Override
    public final ConfiguredObjectRecord asObjectRecord() {
        return new ConfiguredObjectRecord(){

            @Override
            public UUID getId() {
                return AbstractConfiguredObject.this.getId();
            }

            @Override
            public String getType() {
                return AbstractConfiguredObject.this.getCategoryClass().getSimpleName();
            }

            @Override
            public Map<String, Object> getAttributes() {
                return Subject.doAs(AbstractConfiguredObject.this.getSubjectWithAddedSystemRights(), () -> {
                    LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
                    Map<String, Object> actualAttributes = AbstractConfiguredObject.this.getActualAttributes();
                    for (ConfiguredObjectAttribute<?, ?> attr : AbstractConfiguredObject.this._attributeTypes.values()) {
                        Object value;
                        if (!attr.isPersisted() || "id".equals(attr.getName())) continue;
                        if (attr.isDerived()) {
                            value = AbstractConfiguredObject.this.getAttribute(attr.getName());
                            attributes.put(attr.getName(), this.toRecordedForm(attr, value));
                            continue;
                        }
                        if (!actualAttributes.containsKey(attr.getName())) continue;
                        value = actualAttributes.get(attr.getName());
                        attributes.put(attr.getName(), this.toRecordedForm(attr, value));
                    }
                    return attributes;
                });
            }

            public Object toRecordedForm(ConfiguredObjectAttribute<?, ?> attr, Object value) {
                block10: {
                    if (value instanceof ConfiguredObject) {
                        value = ((ConfiguredObject)value).getId();
                    }
                    if (attr.isSecure() && AbstractConfiguredObject.this._encrypter != null && value != null) {
                        if (value instanceof Collection || value instanceof Map) {
                            ObjectMapper mapper = ConfiguredObjectJacksonModule.newObjectMapper(false);
                            try (StringWriter stringWriter = new StringWriter();){
                                mapper.writeValue((Writer)stringWriter, value);
                                value = AbstractConfiguredObject.this._encrypter.encrypt(stringWriter.toString());
                                break block10;
                            }
                            catch (IOException e) {
                                throw new IllegalConfigurationException("Failure when encrypting a secret value", e);
                            }
                        }
                        value = AbstractConfiguredObject.this._encrypter.encrypt(value.toString());
                    }
                }
                return value;
            }

            @Override
            public Map<String, UUID> getParents() {
                LinkedHashMap<String, UUID> parents = new LinkedHashMap<String, UUID>();
                Class<? extends ConfiguredObject> parentClass = AbstractConfiguredObject.this.getModel().getParentType(AbstractConfiguredObject.this.getCategoryClass());
                ConfiguredObject<?> parent = AbstractConfiguredObject.this.getParent();
                if (parent != null) {
                    parents.put(parentClass.getSimpleName(), parent.getId());
                }
                return parents;
            }

            public String toString() {
                return AbstractConfiguredObject.this.getClass().getSimpleName() + "[name=" + AbstractConfiguredObject.this.getName() + ", categoryClass=" + AbstractConfiguredObject.this.getCategoryClass() + ", type=" + this.getType() + ", id=" + this.getId() + ", attributes=" + this.getAttributes() + "]";
            }
        };
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes) {
        return (C)((ConfiguredObject)this.doSync(this.createChildAsync(childClass, attributes)));
    }

    @Override
    public <C extends ConfiguredObject> ListenableFuture<C> createChildAsync(final Class<C> childClass, final Map<String, Object> attributes) {
        return this.doOnConfigThread(new Task<ListenableFuture<C>, RuntimeException>(){

            @Override
            public ListenableFuture<C> execute() {
                ListenableFuture result = null;
                try {
                    result = this.create();
                }
                finally {
                    if (result == null) {
                        AbstractConfiguredObject.this.logCreated(childClass, attributes, Outcome.FAILURE);
                    }
                }
                return result;
            }

            private ListenableFuture<C> create() {
                AbstractConfiguredObject.this.authoriseCreateChild(childClass, attributes);
                return AbstractConfiguredObject.this.doAfter(AbstractConfiguredObject.this.addChildAsync(childClass, attributes), child -> {
                    if (child != null) {
                        AbstractConfiguredObject.this.childAdded((ConfiguredObject<?>)child);
                    }
                    return Futures.immediateFuture((Object)child);
                });
            }

            @Override
            public String getObject() {
                return AbstractConfiguredObject.this.toString();
            }

            @Override
            public String getAction() {
                return "create child";
            }

            @Override
            public String getArguments() {
                if (attributes != null) {
                    return "childClass=" + childClass.getSimpleName() + ", name=" + attributes.get("name") + ", type=" + attributes.get("type");
                }
                return "childClass=" + childClass.getSimpleName();
            }
        });
    }

    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes) {
        return this.getObjectFactory().createAsync(childClass, attributes, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends ConfiguredObject> void registerChild(C child) {
        Map<Class<? extends ConfiguredObject>, Collection<ConfiguredObject<?>>> map = this._children;
        synchronized (map) {
            Class<ConfiguredObject> categoryClass = child.getCategoryClass();
            UUID childId = child.getId();
            String name = child.getName();
            ConfiguredObject existingWithSameId = (ConfiguredObject)this._childrenById.get(categoryClass).get(childId);
            if (existingWithSameId != null) {
                throw new DuplicateIdException(existingWithSameId);
            }
            ConfiguredObject<?> existingWithSameName = this._childrenByName.get(categoryClass).putIfAbsent(name, child);
            if (existingWithSameName != null) {
                throw new DuplicateNameException(existingWithSameName);
            }
            this._childrenByName.get(categoryClass).put(name, child);
            this._children.get(categoryClass).add(child);
            this._childrenById.get(categoryClass).put(childId, child);
        }
    }

    public final void stop() {
        this.doSync(this.setDesiredState(State.STOPPED));
    }

    @Override
    public final void delete() {
        this.doSync(this.deleteAsync());
    }

    protected final <R> R doSync(ListenableFuture<R> async) {
        try {
            return (R)async.get();
        }
        catch (InterruptedException e) {
            throw new ServerScopedRuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause != null) {
                throw new ServerScopedRuntimeException(cause);
            }
            throw new ServerScopedRuntimeException(e);
        }
    }

    protected final <R> R doSync(ListenableFuture<R> async, long timeout, TimeUnit units) throws TimeoutException {
        try {
            return (R)async.get(timeout, units);
        }
        catch (InterruptedException e) {
            throw new ServerScopedRuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause != null) {
                throw new ServerScopedRuntimeException(cause);
            }
            throw new ServerScopedRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ListenableFuture<Void> deleteAsync() {
        State currentDesiredState = this.getDesiredState();
        if (currentDesiredState == State.DELETED) {
            return Futures.immediateFuture(null);
        }
        ListenableFuture<Void> result = null;
        try {
            result = this.deleteWithChecks();
            AbstractConfiguredObject.addFutureCallback(result, new FutureCallback<Void>(){

                public void onSuccess(Void result11) {
                    AbstractConfiguredObject.this.logDeleted(Outcome.SUCCESS);
                }

                public void onFailure(Throwable t) {
                    AbstractConfiguredObject.this.logDeleted(Outcome.FAILURE);
                }
            }, MoreExecutors.directExecutor());
            ListenableFuture<Void> listenableFuture = result;
            return listenableFuture;
        }
        finally {
            if (result == null) {
                this.logDeleted(Outcome.FAILURE);
            }
        }
    }

    private ListenableFuture<Void> deleteWithChecks() {
        Map<String, State> attributes = Collections.singletonMap("desiredState", State.DELETED);
        ConfiguredObject<?> proxyForValidation = this.createProxyForValidation(attributes);
        this.authoriseSetAttributes(proxyForValidation, attributes);
        this.validateChange(proxyForValidation, attributes.keySet());
        this.checkReferencesOnDelete(this.getHierarchyRoot(this), this);
        if (this._parent instanceof AbstractConfiguredObject) {
            ((AbstractConfiguredObject)this._parent).validateChildDelete(this);
        } else if (this._parent instanceof AbstractConfiguredObjectProxy) {
            ((AbstractConfiguredObjectProxy)((Object)this._parent)).validateChildDelete(this);
        }
        return this.deleteNoChecks();
    }

    private void checkReferencesOnDelete(ConfiguredObject<?> referrer, ConfiguredObject<?> referee) {
        if (!this.managesChildren(referee)) {
            this.getModel().getChildTypes(referee.getCategoryClass()).forEach(childClass -> referee.getChildren(childClass).forEach(child -> this.checkReferencesOnDelete(referrer, (ConfiguredObject<?>)child)));
        }
        this.checkReferences(referrer, referee);
    }

    private ConfiguredObject<?> getHierarchyRoot(AbstractConfiguredObject<X> o) {
        ConfiguredObject<?> parent;
        ConfiguredObject<Object> object = o;
        while ((parent = object.getParent()) != null && !this.managesChildren(parent)) {
            object = parent;
        }
        return object;
    }

    private boolean managesChildren(ConfiguredObject<?> object) {
        return this.managesChildren(object.getCategoryClass()) || this.managesChildren(object.getTypeClass());
    }

    private void checkReferences(ConfiguredObject<?> referrer, ConfiguredObject<?> referee) {
        if (this.hasReference(referrer, referee)) {
            if (referee == this) {
                throw new IntegrityViolationException(String.format("%s '%s' is in use by %s '%s'.", referee.getCategoryClass().getSimpleName(), referee.getName(), referrer.getCategoryClass().getSimpleName(), referrer.getName()));
            }
            throw new IntegrityViolationException(String.format("Cannot delete %s '%s' as descendant %s '%s' is in use by %s '%s'.", this.getCategoryClass().getSimpleName(), this.getName(), referee.getCategoryClass().getSimpleName(), referee.getName(), referrer.getCategoryClass().getSimpleName(), referrer.getName()));
        }
        if (!this.managesChildren(referrer)) {
            this.getModel().getChildTypes(referrer.getCategoryClass()).forEach(childClass -> referrer.getChildren(childClass).stream().filter(child -> child != this).forEach(child -> this.checkReferences((ConfiguredObject<?>)child, referee)));
        }
    }

    private boolean hasReference(ConfiguredObject<?> referrer, ConfiguredObject<?> referee) {
        if (referrer instanceof AbstractConfiguredObject) {
            return this.getModel().getTypeRegistry().getAttributes(referrer.getClass()).stream().anyMatch(attribute -> {
                Class type = attribute.getType();
                Type genericType = attribute.getGenericType();
                return this.isReferred(referee, type, genericType, () -> {
                    Object value = attribute.getValue(referrer);
                    return value;
                });
            });
        }
        return referrer.getAttributeNames().stream().anyMatch(name -> {
            Object value = referrer.getAttribute((String)name);
            if (value != null) {
                Class<?> type = value.getClass();
                return this.isReferred(referee, type, type, () -> value);
            }
            return false;
        });
    }

    private boolean isReferred(ConfiguredObject<?> referee, Class<?> attributeValueType, Type attributeGenericType, Supplier<?> attributeValue) {
        Class<ConfiguredObject> referrerCategory = referee.getCategoryClass();
        if (referrerCategory.isAssignableFrom(attributeValueType)) {
            return attributeValue.get() == referee;
        }
        if (this.hasParameterOfType(attributeGenericType, referrerCategory)) {
            Object value = attributeValue.get();
            if (value instanceof Collection) {
                return ((Collection)value).stream().anyMatch(m -> m == referee);
            }
            if (value instanceof Object[]) {
                return Arrays.stream((Object[])value).anyMatch(m -> m == referee);
            }
            if (value instanceof Map) {
                return ((Map)value).entrySet().stream().anyMatch(e -> e.getKey() == referee || e.getValue() == referee);
            }
        }
        return false;
    }

    private boolean hasParameterOfType(Type genericType, Class<?> parameterType) {
        if (genericType instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
            return Arrays.stream(types).anyMatch(type -> {
                if (type instanceof Class && parameterType.isAssignableFrom((Class)type)) {
                    return true;
                }
                if (type instanceof ParameterizedType) {
                    Type rawType = ((ParameterizedType)type).getRawType();
                    return rawType instanceof Class && parameterType.isAssignableFrom((Class)rawType);
                }
                if (type instanceof TypeVariable) {
                    Type[] bounds = ((TypeVariable)type).getBounds();
                    return Arrays.stream(bounds).anyMatch(boundType -> this.hasParameterOfType((Type)boundType, parameterType));
                }
                return false;
            });
        }
        return false;
    }

    protected ListenableFuture<Void> deleteNoChecks() {
        String simpleClassName = this.getClass().getSimpleName();
        final SettableFuture returnFuture = SettableFuture.create();
        State currentDesiredState = this.getDesiredState();
        ChainedListenableFuture<Void> future = this.doAfter(this.beforeDelete(), this::deleteChildren).then(this::onDelete).then(() -> {
            State currentState = this.getState();
            this.setState(State.DELETED);
            this.notifyStateChanged(currentState, State.DELETED);
            this.changeAttribute("desiredState", (Object)State.DELETED);
            this.attributeSet("desiredState", (Object)currentDesiredState, (Object)State.DELETED);
            this.unregister(true);
            return Futures.immediateFuture(null);
        });
        AbstractConfiguredObject.addFutureCallback(future, new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                returnFuture.set(null);
            }

            public void onFailure(Throwable t) {
                returnFuture.setException(t);
            }
        }, MoreExecutors.directExecutor());
        return returnFuture;
    }

    protected final ListenableFuture<Void> deleteChildren() {
        if (this.managesChildStorage()) {
            return Futures.immediateFuture(null);
        }
        ArrayList childDeleteFutures = new ArrayList();
        this.applyToChildren(child -> {
            ListenableFuture<Void> childDeleteFuture = child instanceof AbstractConfiguredObject ? ((AbstractConfiguredObject)child).deleteNoChecks() : (child instanceof AbstractConfiguredObjectProxy ? ((AbstractConfiguredObjectProxy)((Object)child)).deleteNoChecks() : Futures.immediateFuture(null));
            AbstractConfiguredObject.addFutureCallback(childDeleteFuture, new FutureCallback<Void>(){

                public void onSuccess(Void result) {
                    if (child instanceof AbstractConfiguredObject) {
                        ((AbstractConfiguredObject)child).logDeleted(Outcome.SUCCESS);
                    }
                }

                public void onFailure(Throwable t) {
                    LOGGER.error("Exception occurred while deleting {} : {}", new Object[]{child.getClass().getSimpleName(), child.getName(), t});
                    if (child instanceof AbstractConfiguredObject) {
                        ((AbstractConfiguredObject)child).logDeleted(Outcome.FAILURE);
                    }
                }
            }, this.getTaskExecutor());
            childDeleteFutures.add(childDeleteFuture);
        });
        ListenableFuture combinedFuture = Futures.allAsList(childDeleteFutures);
        return Futures.transform((ListenableFuture)combinedFuture, input -> null, (Executor)this.getTaskExecutor());
    }

    protected ListenableFuture<Void> beforeDelete() {
        return Futures.immediateFuture(null);
    }

    protected ListenableFuture<Void> onDelete() {
        return Futures.immediateFuture(null);
    }

    public final void start() {
        this.doSync(this.startAsync());
    }

    public ListenableFuture<Void> startAsync() {
        return this.setDesiredState(State.ACTIVE);
    }

    private void deleted() {
        this.unregister(true);
    }

    private void unregister(boolean removed) {
        if (this._parent instanceof AbstractConfiguredObject) {
            AbstractConfiguredObject parentObj = (AbstractConfiguredObject)this._parent;
            parentObj.unregisterChild(this);
            if (removed) {
                parentObj.childRemoved(this);
            }
        } else if (this._parent instanceof AbstractConfiguredObjectProxy) {
            AbstractConfiguredObjectProxy parentObj = (AbstractConfiguredObjectProxy)((Object)this._parent);
            parentObj.unregisterChild(this);
            if (removed) {
                parentObj.childRemoved(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends ConfiguredObject> void unregisterChild(C child) {
        Class<ConfiguredObject> categoryClass = child.getCategoryClass();
        Map<Class<? extends ConfiguredObject>, Collection<ConfiguredObject<?>>> map = this._children;
        synchronized (map) {
            this._children.get(categoryClass).remove(child);
            this._childrenById.get(categoryClass).remove(child.getId(), child);
            this._childrenByName.get(categoryClass).remove(child.getName(), child);
        }
    }

    @Override
    public final <C extends ConfiguredObject> C getChildById(Class<C> clazz, UUID id) {
        return (C)((ConfiguredObject)this._childrenById.get(ConfiguredObjectTypeRegistry.getCategory(clazz)).get(id));
    }

    @Override
    public final <C extends ConfiguredObject> C getChildByName(Class<C> clazz, String name) {
        Class<? extends ConfiguredObject> categoryClass = ConfiguredObjectTypeRegistry.getCategory(clazz);
        return (C)((ConfiguredObject)this._childrenByName.get(categoryClass).get(name));
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        Collection<ConfiguredObject<?>> children = this._children.get(clazz);
        if (children == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList((List)children);
    }

    @Override
    public <C extends ConfiguredObject> ListenableFuture<C> getAttainedChildByName(Class<C> childClass, String name) {
        C child = this.getChildByName(childClass, name);
        if (child instanceof AbstractConfiguredObject) {
            return ((AbstractConfiguredObject)child).getAttainStateFuture();
        }
        if (child instanceof AbstractConfiguredObjectProxy) {
            return ((AbstractConfiguredObjectProxy)child).getAttainStateFuture();
        }
        return Futures.immediateFuture(child);
    }

    @Override
    public <C extends ConfiguredObject> ListenableFuture<C> getAttainedChildById(Class<C> childClass, UUID id) {
        C child = this.getChildById(childClass, id);
        if (child instanceof AbstractConfiguredObject) {
            return ((AbstractConfiguredObject)child).getAttainStateFuture();
        }
        if (child instanceof AbstractConfiguredObjectProxy) {
            return ((AbstractConfiguredObjectProxy)child).getAttainStateFuture();
        }
        return Futures.immediateFuture(child);
    }

    private <C extends ConfiguredObject> ListenableFuture<C> getAttainStateFuture() {
        return this._attainStateFuture;
    }

    @Override
    public final TaskExecutor getTaskExecutor() {
        return this._taskExecutor;
    }

    @Override
    public TaskExecutor getChildExecutor() {
        return this.getTaskExecutor();
    }

    protected final <T, E extends Exception> T runTask(Task<T, E> task) throws E {
        return this._taskExecutor.run(task);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        this.doSync(this.setAttributesAsync(attributes));
    }

    protected void postSetAttributes(Set<String> actualUpdatedAttributes) {
    }

    protected final ChainedListenableFuture<Void> doAfter(ListenableFuture<?> first, Runnable second) {
        return AbstractConfiguredObject.doAfter((Executor)this.getTaskExecutor(), first, second);
    }

    protected static <V> ChainedListenableFuture<Void> doAfter(Executor executor, ListenableFuture<V> first, final Runnable second) {
        final ChainedSettableFuture<Void> returnVal = new ChainedSettableFuture<Void>(executor);
        AbstractConfiguredObject.addFutureCallback(first, new FutureCallback<V>(){

            public void onSuccess(V result) {
                try {
                    second.run();
                    returnVal.set(null);
                }
                catch (Throwable e) {
                    returnVal.setException(e);
                }
            }

            public void onFailure(Throwable t) {
                returnVal.setException(t);
            }
        }, executor);
        return returnVal;
    }

    protected final <V> ChainedListenableFuture<V> doAfter(ListenableFuture<V> first, Callable<ListenableFuture<V>> second) {
        return AbstractConfiguredObject.doAfter((Executor)this.getTaskExecutor(), first, second);
    }

    protected final <V, A> ChainedListenableFuture<V> doAfter(ListenableFuture<A> first, CallableWithArgument<ListenableFuture<V>, A> second) {
        return AbstractConfiguredObject.doAfter((Executor)this.getTaskExecutor(), first, second);
    }

    protected static <V> ChainedListenableFuture<V> doAfter(final Executor executor, ListenableFuture<V> first, final Callable<ListenableFuture<V>> second) {
        final ChainedSettableFuture returnVal = new ChainedSettableFuture(executor);
        AbstractConfiguredObject.addFutureCallback(first, new FutureCallback<V>(){

            public void onSuccess(V result) {
                try {
                    ListenableFuture future = (ListenableFuture)second.call();
                    AbstractConfiguredObject.addFutureCallback(future, new FutureCallback<V>(){

                        public void onSuccess(V result) {
                            returnVal.set(result);
                        }

                        public void onFailure(Throwable t) {
                            returnVal.setException(t);
                        }
                    }, executor);
                }
                catch (Throwable e) {
                    returnVal.setException(e);
                }
            }

            public void onFailure(Throwable t) {
                returnVal.setException(t);
            }
        }, executor);
        return returnVal;
    }

    protected static <V, A> ChainedListenableFuture<V> doAfter(final Executor executor, ListenableFuture<A> first, final CallableWithArgument<ListenableFuture<V>, A> second) {
        final ChainedSettableFuture returnVal = new ChainedSettableFuture(executor);
        AbstractConfiguredObject.addFutureCallback(first, new FutureCallback<A>(){

            public void onSuccess(A result) {
                try {
                    ListenableFuture future = (ListenableFuture)second.call(result);
                    AbstractConfiguredObject.addFutureCallback(future, new FutureCallback<V>(){

                        public void onSuccess(V result) {
                            returnVal.set(result);
                        }

                        public void onFailure(Throwable t) {
                            returnVal.setException(t);
                        }
                    }, executor);
                }
                catch (Throwable e) {
                    returnVal.setException(e);
                }
            }

            public void onFailure(Throwable t) {
                returnVal.setException(t);
            }
        }, executor);
        return returnVal;
    }

    protected <V> ChainedListenableFuture<Void> doAfterAlways(ListenableFuture<V> future, Runnable after) {
        return AbstractConfiguredObject.doAfterAlways(this.getTaskExecutor(), future, after);
    }

    protected static <V> ChainedListenableFuture<Void> doAfterAlways(Executor executor, ListenableFuture<V> future, final Runnable after) {
        final ChainedSettableFuture<Void> returnVal = new ChainedSettableFuture<Void>(executor);
        AbstractConfiguredObject.addFutureCallback(future, new FutureCallback<V>(){

            public void onSuccess(V result) {
                try {
                    after.run();
                    returnVal.set(null);
                }
                catch (Throwable e) {
                    returnVal.setException(e);
                }
            }

            public void onFailure(Throwable t) {
                try {
                    after.run();
                }
                finally {
                    returnVal.setException(t);
                }
            }
        }, executor);
        return returnVal;
    }

    public static <V> void addFutureCallback(ListenableFuture<V> future, final FutureCallback<V> callback, Executor taskExecutor) {
        final Subject subject = Subject.getSubject(AccessController.getContext());
        Futures.addCallback(future, (FutureCallback)new FutureCallback<V>(){

            public void onSuccess(V result) {
                Subject.doAs(subject, () -> {
                    callback.onSuccess(result);
                    return null;
                });
            }

            public void onFailure(Throwable t) {
                Subject.doAs(subject, () -> {
                    callback.onFailure(t);
                    return null;
                });
            }
        }, (Executor)taskExecutor);
    }

    @Override
    public ListenableFuture<Void> setAttributesAsync(final Map<String, Object> attributes) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        final HashMap<String, Object> updateAttributes = new HashMap<String, Object>(attributes);
        Object desiredState = updateAttributes.remove("desiredState");
        this.runTask(new Task<Void, RuntimeException>(){

            @Override
            public Void execute() {
                Outcome outcome = Outcome.FAILURE;
                try {
                    this.setAttributes();
                    outcome = Outcome.SUCCESS;
                }
                finally {
                    AbstractConfiguredObject.this.logUpdated(updateAttributes, outcome);
                }
                return null;
            }

            private void setAttributes() {
                AbstractConfiguredObject.this.authoriseSetAttributes(AbstractConfiguredObject.this.createProxyForValidation(attributes), attributes);
                if (!AbstractConfiguredObject.this.isSystemProcess()) {
                    AbstractConfiguredObject.this.validateChange(AbstractConfiguredObject.this.createProxyForValidation(attributes), attributes.keySet());
                }
                AbstractConfiguredObject.this.changeAttributes(updateAttributes);
            }

            @Override
            public String getObject() {
                return AbstractConfiguredObject.this.toString();
            }

            @Override
            public String getAction() {
                return "set attributes";
            }

            @Override
            public String getArguments() {
                return "attributes number=" + attributes.size();
            }
        });
        if (desiredState != null) {
            State state;
            if (desiredState instanceof State) {
                state = (State)((Object)desiredState);
            } else if (desiredState instanceof String) {
                state = State.valueOf((String)desiredState);
            } else {
                throw new IllegalArgumentException("Cannot convert an object of type " + desiredState.getClass().getName() + " to a State");
            }
            return this.setDesiredState(state);
        }
        return Futures.immediateFuture(null);
    }

    public void forceUpdateAllSecureAttributes() {
        this.applyToChildren(object -> {
            if (object instanceof AbstractConfiguredObject) {
                ((AbstractConfiguredObject)object).forceUpdateAllSecureAttributes();
            } else if (object instanceof AbstractConfiguredObjectProxy) {
                ((AbstractConfiguredObjectProxy)((Object)object)).forceUpdateAllSecureAttributes();
            }
        });
        this.doUpdateSecureAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateSecureAttributes() {
        Map<String, Object> secureAttributeValues = this.getSecureAttributeValues();
        if (!secureAttributeValues.isEmpty()) {
            this.bulkChangeStart();
            for (Map.Entry<String, Object> attribute : secureAttributeValues.entrySet()) {
                Collection<ConfigurationChangeListener> collection = this._changeListeners;
                synchronized (collection) {
                    ArrayList<ConfigurationChangeListener> copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
                    for (ConfigurationChangeListener listener : copy) {
                        listener.attributeSet(this, attribute.getKey(), attribute.getValue(), attribute.getValue());
                    }
                }
            }
            this.bulkChangeEnd();
        }
    }

    private Map<String, Object> getSecureAttributeValues() {
        HashMap<String, Object> secureAttributeValues = new HashMap<String, Object>();
        for (Map.Entry<String, ConfiguredObjectAttribute<?, ?>> attribute : this._attributeTypes.entrySet()) {
            if (!attribute.getValue().isSecure() || !this._attributes.containsKey(attribute.getKey())) continue;
            secureAttributeValues.put(attribute.getKey(), this._attributes.get(attribute.getKey()));
        }
        return secureAttributeValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkChangeStart() {
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            ArrayList<ConfigurationChangeListener> copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
            for (ConfigurationChangeListener listener : copy) {
                listener.bulkChangeStart(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkChangeEnd() {
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            ArrayList<ConfigurationChangeListener> copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
            for (ConfigurationChangeListener listener : copy) {
                listener.bulkChangeEnd(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeAttributes(Map<String, Object> attributes) {
        Collection<String> names = this.getAttributeNames();
        HashSet<String> updatedAttributes = new HashSet<String>(attributes.size());
        try {
            this.bulkChangeStart();
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String attributeName = entry.getKey();
                if (!names.contains(attributeName)) continue;
                Object desired = entry.getValue();
                Object expected = this.getAttribute(attributeName);
                if (!this.changeAttribute(attributeName, desired)) continue;
                this.attributeSet(attributeName, expected, desired);
                updatedAttributes.add(attributeName);
            }
        }
        finally {
            try {
                this.postSetAttributes(updatedAttributes);
            }
            finally {
                this.bulkChangeEnd();
            }
        }
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        for (ConfiguredObjectAttribute<?, ?> attr : this._attributeTypes.values()) {
            Object desiredValueOrDefault;
            if (attr.isDerived() || !changedAttributes.contains(attr.getName())) continue;
            ConfiguredSettableAttribute autoAttr = (ConfiguredSettableAttribute)attr;
            if (autoAttr.isImmutable() && !Objects.equals(autoAttr.getValue(this), autoAttr.getValue(proxyForValidation))) {
                throw new IllegalConfigurationException("Attribute '" + autoAttr.getName() + "' cannot be changed.");
            }
            if (autoAttr.hasValidValues()) {
                Object desiredValue = autoAttr.getValue(proxyForValidation);
                if ((autoAttr.isMandatory() || desiredValue != null) && !this.checkValidValues(autoAttr, desiredValue)) {
                    throw new IllegalConfigurationException("Attribute '" + autoAttr.getName() + "' instance of " + this.getClass().getName() + " named '" + this.getName() + "' cannot have value '" + desiredValue + "'. Valid values are: " + autoAttr.validValues());
                }
            } else if (!"".equals(autoAttr.validValuePattern()) && (desiredValueOrDefault = autoAttr.getValue(proxyForValidation)) != null && !this.checkValidValuePattern(autoAttr, desiredValueOrDefault)) {
                throw new IllegalConfigurationException("Attribute '" + autoAttr.getName() + "' instance of " + this.getClass().getName() + " named '" + this.getName() + "' cannot have value '" + desiredValueOrDefault + "'. Valid values pattern is: " + autoAttr.validValuePattern());
            }
            if (!autoAttr.isMandatory() || autoAttr.getValue(proxyForValidation) != null) continue;
            throw new IllegalConfigurationException("Attribute '" + autoAttr.getName() + "' instance of " + this.getClass().getName() + " named '" + this.getName() + "' cannot be null, as it is mandatory");
        }
    }

    private ConfiguredObject<?> createProxyForValidation(Map<String, Object> attributes) {
        return (ConfiguredObject)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this._bestFitInterface}, (InvocationHandler)new AttributeGettingHandler(attributes, this._attributeTypes, this));
    }

    private ConfiguredObject<?> createProxyForInitialization(Map<String, Object> attributes) {
        return (ConfiguredObject)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this._bestFitInterface}, (InvocationHandler)new AttributeInitializationInvocationHandler(attributes, this._attributeTypes, this));
    }

    private ConfiguredObject<?> createProxyForAuthorisation(Class<? extends ConfiguredObject> category, Map<String, Object> attributes, ConfiguredObject<?> parent) {
        return (ConfiguredObject)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{category}, (InvocationHandler)new AuthorisationProxyInvocationHandler(attributes, this.getTypeRegistry().getAttributeTypes(category), category, parent));
    }

    protected final <C extends ConfiguredObject<?>> void authoriseCreateChild(Class<C> childClass, Map<String, Object> attributes) throws AccessControlException {
        ConfiguredObject<?> configuredObject = this.createProxyForAuthorisation(childClass, attributes, this);
        this.authorise(configuredObject, null, Operation.CREATE, Map.of());
    }

    @Override
    public final void authorise(Operation operation) throws AccessControlException {
        this.authorise(this, null, operation, Map.of());
    }

    @Override
    public final void authorise(Operation operation, Map<String, Object> arguments) throws AccessControlException {
        this.authorise(this, null, operation, arguments);
    }

    @Override
    public final void authorise(SecurityToken token, Operation operation, Map<String, Object> arguments) throws AccessControlException {
        this.authorise(this, token, operation, arguments);
    }

    @Override
    public final SecurityToken newToken(Subject subject) {
        AccessControl accessControl = this.getAccessControl();
        return accessControl == null ? null : (SecurityToken)accessControl.newToken(subject);
    }

    private void authorise(ConfiguredObject<?> configuredObject, SecurityToken token, Operation operation, Map<String, Object> arguments) {
        AccessControl accessControl = this.getAccessControl();
        if (accessControl != null) {
            Result result = accessControl.authorise(token, operation, configuredObject, arguments);
            LOGGER.debug("authorise returned {}", (Object)result);
            if (result == Result.DEFER) {
                result = accessControl.getDefault();
                LOGGER.debug("authorise returned DEFER, returing default: {}", (Object)result);
            }
            if (result == Result.DENIED) {
                Class<ConfiguredObject> categoryClass = configuredObject.getCategoryClass();
                String objectName = (String)configuredObject.getAttribute("name");
                String operationName = operation.getName().equals(operation.getType().name()) ? operation.getName() : operation.getType().name() + "(" + operation.getName() + ")";
                StringBuilder exceptionMessage = new StringBuilder(String.format("Permission %s is denied for : %s '%s'", operationName, categoryClass.getSimpleName(), objectName));
                Model model = configuredObject.getModel();
                Class<? extends ConfiguredObject> parentClass = model.getParentType(categoryClass);
                if (parentClass != null) {
                    exceptionMessage.append(" on");
                    String objectCategory = parentClass.getSimpleName();
                    ConfiguredObject<?> parent = configuredObject.getParent();
                    exceptionMessage.append(" ").append(objectCategory);
                    if (parent != null) {
                        exceptionMessage.append(" '").append(parent.getAttribute("name")).append("'");
                    }
                }
                throw new AccessControlException(exceptionMessage.toString());
            }
        }
    }

    private final void authoriseSetAttributes(ConfiguredObject<?> proxyForValidation, Map<String, Object> modifiedAttributes) {
        if (modifiedAttributes.containsKey("desiredState") && State.DELETED.equals((Object)proxyForValidation.getDesiredState())) {
            this.authorise(Operation.DELETE);
            if (modifiedAttributes.size() == 1) {
                return;
            }
        }
        this.authorise(this, null, Operation.UPDATE, modifiedAttributes);
    }

    protected Principal getSystemPrincipal() {
        return this._systemPrincipal;
    }

    protected final Subject getSubjectWithAddedSystemRights() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        subject = subject == null ? new Subject() : new Subject(false, subject.getPrincipals(), subject.getPublicCredentials(), subject.getPrivateCredentials());
        subject.getPrincipals().add(this.getSystemPrincipal());
        subject.setReadOnly();
        return subject;
    }

    protected final AccessControlContext getSystemTaskControllerContext(String taskName, Principal principal) {
        Subject subject = this.getSystemTaskSubject(taskName, principal);
        return AccessController.doPrivileged(() -> new AccessControlContext(AccessController.getContext(), new SubjectDomainCombiner(subject)), null);
    }

    protected Subject getSystemTaskSubject(String taskName) {
        return this.getSystemSubject(new TaskPrincipal(taskName));
    }

    protected final Subject getSystemTaskSubject(String taskName, Principal principal) {
        return this.getSystemSubject(new TaskPrincipal(taskName), principal);
    }

    protected final boolean isSystemProcess() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        return this.isSystemSubject(subject);
    }

    protected boolean isSystemSubject(Subject subject) {
        return subject != null && subject.getPrincipals().contains(this.getSystemPrincipal());
    }

    private Subject getSystemSubject(Principal ... principals) {
        HashSet<Principal> principalSet = new HashSet<Principal>(Arrays.asList(principals));
        principalSet.add(this.getSystemPrincipal());
        return new Subject(true, principalSet, Set.of(), Set.of());
    }

    private int getAwaitAttainmentTimeout() {
        if (this._awaitAttainmentTimeout == 0) {
            try {
                this._awaitAttainmentTimeout = this.getContextValue(Integer.class, "awaitAttainmentTimeout");
            }
            catch (IllegalArgumentException e) {
                this._awaitAttainmentTimeout = 5000;
            }
        }
        return this._awaitAttainmentTimeout;
    }

    protected final <C extends ConfiguredObject> C awaitChildClassToAttainState(Class<C> childClass, String name) {
        ListenableFuture<C> attainedChildByName = this.getAttainedChildByName(childClass, name);
        try {
            return (C)((ConfiguredObject)this.doSync(attainedChildByName, this.getAwaitAttainmentTimeout(), TimeUnit.MILLISECONDS));
        }
        catch (TimeoutException e) {
            LOGGER.warn("Gave up waiting for {} '{}' to attain state. Check object's state via Management.", (Object)childClass.getSimpleName(), (Object)name);
            return null;
        }
    }

    protected final <C extends ConfiguredObject> C awaitChildClassToAttainState(Class<C> childClass, UUID id) {
        ListenableFuture<C> attainedChildByName = this.getAttainedChildById(childClass, id);
        try {
            return (C)((ConfiguredObject)this.doSync(attainedChildByName, this.getAwaitAttainmentTimeout(), TimeUnit.MILLISECONDS));
        }
        catch (TimeoutException e) {
            LOGGER.warn("Gave up waiting for {} with ID {} to attain state. Check object's state via Management.", (Object)childClass.getSimpleName(), (Object)id);
            return null;
        }
    }

    protected AccessControl getAccessControl() {
        return this._parentAccessControl;
    }

    @Override
    public final String getLastUpdatedBy() {
        return this._lastUpdatedBy;
    }

    @Override
    public final Date getLastUpdatedTime() {
        return this._lastUpdatedTime;
    }

    @Override
    public final String getCreatedBy() {
        return this._createdBy;
    }

    @Override
    public final Date getCreatedTime() {
        return this._createdTime;
    }

    @Override
    public final String getType() {
        return this._type;
    }

    @Override
    public Map<String, Object> getStatistics() {
        return this.getStatistics(List.of());
    }

    @Override
    public Map<String, Object> getStatistics(List<String> statistics) {
        Collection<ConfiguredObjectStatistic<?, ?>> stats = this.getTypeRegistry().getStatistics(this.getClass());
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean allStats = statistics == null || statistics.isEmpty();
        for (ConfiguredObjectStatistic<?, ?> stat : stats) {
            Object value;
            if (!allStats && !statistics.contains(stat.getName()) || (value = stat.getValue(this)) == null) continue;
            map.put(stat.getName(), value);
        }
        return map;
    }

    @Override
    public String setContextVariable(String name, String value) {
        LinkedHashMap<String, String> context = new LinkedHashMap<String, String>(this.getContext());
        String previousValue = context.put(name, value);
        this.setAttributes(Collections.singletonMap("context", context));
        return previousValue;
    }

    @Override
    public String removeContextVariable(String name) {
        LinkedHashMap<String, String> context = new LinkedHashMap<String, String>(this.getContext());
        String previousValue = (String)context.remove(name);
        this.setAttributes(Collections.singletonMap("context", context));
        return previousValue;
    }

    @Override
    public <Y extends ConfiguredObject<Y>> Y findConfiguredObject(Class<Y> clazz, String name) {
        Collection<Y> reachable = this.getModel().getReachableObjects(this, clazz);
        for (ConfiguredObject candidate : reachable) {
            if (!candidate.getName().equals(name)) continue;
            return (Y)candidate;
        }
        return null;
    }

    @Override
    public final <T> T getContextValue(Class<T> clazz, String propertyName) {
        return this.getContextValue(clazz, clazz, propertyName);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, Type type, String propertyName) {
        AttributeValueConverter<T> converter = AttributeValueConverter.getConverter(clazz, type);
        return converter.convert("${" + propertyName + "}", this);
    }

    @Override
    public Set<String> getContextKeys(boolean excludeSystem) {
        HashMap<String, String> inheritedContext = new HashMap<String, String>(this.getTypeRegistry().getDefaultContext());
        if (!excludeSystem) {
            inheritedContext.putAll(System.getenv());
            inheritedContext.putAll((Map)System.getProperties().clone());
        }
        AbstractConfiguredObject.generateInheritedContext(this.getModel(), this, inheritedContext);
        return Collections.unmodifiableSet(inheritedContext.keySet());
    }

    private ConfiguredObjectTypeRegistry getTypeRegistry() {
        return this.getModel().getTypeRegistry();
    }

    private OwnAttributeResolver getOwnAttributeResolver() {
        return this._ownAttributeResolver;
    }

    private AncestorAttributeResolver getAncestorAttributeResolver() {
        return this._ancestorAttributeResolver;
    }

    @Override
    public boolean hasEncrypter() {
        return this._encrypter != null;
    }

    @Override
    public void decryptSecrets() {
        if (this._encrypter != null) {
            for (Map.Entry<String, Object> entry : this._attributes.entrySet()) {
                ConfiguredObjectAttribute<?, ?> attr = this._attributeTypes.get(entry.getKey());
                if (attr == null || !attr.isSecure() || !(entry.getValue() instanceof String)) continue;
                String decrypt = this._encrypter.decrypt((String)entry.getValue());
                entry.setValue(decrypt);
            }
        }
    }

    @Override
    public final Date getLastOpenedTime() {
        return this._lastOpenedTime;
    }

    @Override
    public UserPreferences getUserPreferences() {
        return this._userPreferences;
    }

    @Override
    public void setUserPreferences(UserPreferences userPreferences) {
        this._userPreferences = userPreferences;
    }

    private EventLogger getEventLogger() {
        EventLogger eventLogger;
        if (this._parent instanceof EventLoggerProvider) {
            return ((EventLoggerProvider)((Object)this._parent)).getEventLogger();
        }
        if (this._parent instanceof AbstractConfiguredObject && (eventLogger = ((AbstractConfiguredObject)this._parent).getEventLogger()) != null) {
            return eventLogger;
        }
        return null;
    }

    protected void logOperation(String operation) {
        EventLogger eventLogger = this.getEventLogger();
        if (eventLogger != null) {
            eventLogger.message(new OperationLogMessage(this, operation));
        } else {
            LOGGER.info("{} : {} ({}) : Operation : {}", new Object[]{LogMessage.getActor(), this.getCategoryClass().getSimpleName(), this.getName(), operation});
        }
    }

    protected void logUpdated(Map<String, Object> attributes, Outcome outcome) {
        EventLogger eventLogger = this.getEventLogger();
        if (eventLogger != null) {
            eventLogger.message(new UpdateLogMessage(this, this.attributesAsString(attributes), outcome));
        } else {
            LOGGER.info("{} : {} ({}) : Update : {} : {}", new Object[]{LogMessage.getActor(), this.getCategoryClass().getSimpleName(), this.getName(), outcome, this.attributesAsString(attributes)});
        }
    }

    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        this.logCreated(this.getCategoryClass(), attributes, outcome);
    }

    private void logCreated(Class<? extends ConfiguredObject> categoryClass, Map<String, Object> attributes, Outcome outcome) {
        EventLogger eventLogger = this.getEventLogger();
        if (eventLogger != null) {
            String name = attributes != null && attributes.containsKey("name") ? String.valueOf(attributes.get("name")) : "";
            eventLogger.message(new CreateLogMessage(outcome, categoryClass, name, this.attributesAsString(attributes)));
        } else {
            LOGGER.info("{} : {} ({}) : Create : {} : {}", new Object[]{LogMessage.getActor(), this.getCategoryClass().getSimpleName(), this.getName(), outcome, this.attributesAsString(this.getActualAttributes())});
        }
    }

    protected void logRecovered(Outcome outcome) {
        LOGGER.debug("{} : {} ({}) : Recover : {}", new Object[]{LogMessage.getActor(), this.getCategoryClass().getSimpleName(), this.getName(), outcome});
    }

    protected void logDeleted(Outcome outcome) {
        EventLogger eventLogger = this.getEventLogger();
        if (eventLogger != null) {
            eventLogger.message(new DeleteLogMessage(this, outcome));
        } else {
            LOGGER.debug("{} : {} ({}) : Delete : {}", new Object[]{LogMessage.getActor(), this.getCategoryClass().getSimpleName(), this.getName(), outcome});
        }
    }

    protected String attributesAsString(Map<String, Object> attributes) {
        return attributes.entrySet().stream().filter(e -> this._attributeTypes.get(e.getKey()) != null).sorted(Map.Entry.comparingByKey()).map(e -> {
            Object value;
            ConfiguredObjectAttribute<?, ?> attributeType = this._attributeTypes.get(e.getKey());
            if (attributeType.isSecureValue(value = e.getValue())) {
                value = SECURED_STRING_VALUE;
            } else if (value instanceof Date) {
                value = ((Date)value).toInstant().toString();
            }
            return String.format("%s=%s", e.getKey(), value);
        }).collect(Collectors.joining(",", "{", "}"));
    }

    static String interpolate(ConfiguredObject<?> object, String value) {
        if (object == null) {
            return value;
        }
        HashMap<String, String> inheritedContext = new HashMap<String, String>();
        AbstractConfiguredObject.generateInheritedContext(object.getModel(), object, inheritedContext);
        return Strings.expand(value, false, JSON_SUBSTITUTION_RESOLVER, AbstractConfiguredObject.getOwnAttributeResolver(object), AbstractConfiguredObject.getAncestorAttributeResolver(object), new Strings.MapResolver(inheritedContext), Strings.JAVA_SYS_PROPS_RESOLVER, Strings.ENV_VARS_RESOLVER, object.getModel().getTypeRegistry().getDefaultContextResolver());
    }

    static String interpolate(Model model, String value) {
        return Strings.expand(value, false, JSON_SUBSTITUTION_RESOLVER, Strings.JAVA_SYS_PROPS_RESOLVER, Strings.ENV_VARS_RESOLVER, model.getTypeRegistry().getDefaultContextResolver());
    }

    private static OwnAttributeResolver getOwnAttributeResolver(ConfiguredObject<?> object) {
        return object instanceof AbstractConfiguredObject ? ((AbstractConfiguredObject)object).getOwnAttributeResolver() : new OwnAttributeResolver(object);
    }

    private static AncestorAttributeResolver getAncestorAttributeResolver(ConfiguredObject<?> object) {
        return object instanceof AbstractConfiguredObject ? ((AbstractConfiguredObject)object).getAncestorAttributeResolver() : new AncestorAttributeResolver(object);
    }

    static void generateInheritedContext(Model model, ConfiguredObject<?> object, Map<String, String> inheritedContext) {
        ConfiguredObject<?> parent;
        Class<? extends ConfiguredObject> parentClass = model.getParentType(object.getCategoryClass());
        if (parentClass != null && (parent = object.getParent()) != null) {
            AbstractConfiguredObject.generateInheritedContext(model, parent, inheritedContext);
        }
        if (object.getContext() != null) {
            inheritedContext.putAll(object.getContext());
        }
    }

    private static interface AbstractConfiguredObjectProxy {
        public void registerChild(ConfiguredObject var1);

        public DynamicState getDynamicState();

        public ListenableFuture<Void> doAttainState(AbstractConfiguredObjectExceptionHandler var1);

        public void doOpening(boolean var1, AbstractConfiguredObjectExceptionHandler var2);

        public void handleExceptionOnOpen(RuntimeException var1);

        public void unregister(boolean var1);

        public void doValidation(boolean var1, AbstractConfiguredObjectExceptionHandler var2);

        public void doResolution(boolean var1, AbstractConfiguredObjectExceptionHandler var2);

        public void doCreation(boolean var1, AbstractConfiguredObjectExceptionHandler var2);

        public void validateChildDelete(ConfiguredObject var1);

        public void unregisterChild(ConfiguredObject var1);

        public void childRemoved(ConfiguredObject var1);

        public ListenableFuture getAttainStateFuture();

        public void forceUpdateAllSecureAttributes();

        public ListenableFuture<Void> deleteNoChecks();
    }

    private static class CreateExceptionHandler
    implements AbstractConfiguredObjectExceptionHandler {
        private final boolean _unregister;

        private CreateExceptionHandler() {
            this(false);
        }

        private CreateExceptionHandler(boolean unregister) {
            this._unregister = unregister;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleException(RuntimeException exception, ConfiguredObject<?> source) {
            try {
                if (source.getState() != State.DELETED) {
                    if (source instanceof AbstractConfiguredObject) {
                        AbstractConfiguredObject object = (AbstractConfiguredObject)source;
                        object.logCreated(object.getActualAttributes(), Outcome.FAILURE);
                        object.deleteNoChecks();
                    }
                    if (source instanceof AbstractConfiguredObjectProxy) {
                        ((AbstractConfiguredObjectProxy)((Object)source)).deleteNoChecks();
                    }
                    source.deleteAsync();
                }
            }
            finally {
                if (this._unregister) {
                    if (source instanceof AbstractConfiguredObject) {
                        ((AbstractConfiguredObject)source).unregister(false);
                    } else if (source instanceof AbstractConfiguredObjectProxy) {
                        ((AbstractConfiguredObjectProxy)((Object)source)).unregister(false);
                    }
                }
                throw exception;
            }
        }
    }

    private static class OpenExceptionHandler
    implements AbstractConfiguredObjectExceptionHandler {
        private OpenExceptionHandler() {
        }

        @Override
        public void handleException(RuntimeException exception, ConfiguredObject<?> source) {
            if (source instanceof AbstractConfiguredObject) {
                AbstractConfiguredObject object = (AbstractConfiguredObject)source;
                object.logRecovered(Outcome.FAILURE);
                object.handleExceptionOnOpen(exception);
            } else if (source instanceof AbstractConfiguredObjectProxy) {
                ((AbstractConfiguredObjectProxy)((Object)source)).handleExceptionOnOpen(exception);
            }
        }
    }

    static interface AbstractConfiguredObjectExceptionHandler {
        public void handleException(RuntimeException var1, ConfiguredObject<?> var2);
    }

    public static class DuplicateNameException
    extends IllegalArgumentException {
        private final ConfiguredObject<?> _existing;

        protected DuplicateNameException(ConfiguredObject<?> existing) {
            this("Child of type " + existing.getClass().getSimpleName() + " already exists with name of " + existing.getName(), existing);
        }

        protected DuplicateNameException(String message, ConfiguredObject<?> existing) {
            super(message);
            this._existing = existing;
        }

        public String getName() {
            return this._existing.getName();
        }

        public ConfiguredObject<?> getExisting() {
            return this._existing;
        }
    }

    public static final class DuplicateIdException
    extends IllegalArgumentException {
        private DuplicateIdException(ConfiguredObject<?> existing) {
            super("Child of type " + existing.getClass().getSimpleName() + " already exists with id of " + existing.getId());
        }
    }

    private static class AuthorisationProxyInvocationHandler
    extends AttributeGettingHandler {
        private final Class<? extends ConfiguredObject> _category;
        private final ConfiguredObject<?> _parent;
        private final Map<String, Object> _attributes;

        AuthorisationProxyInvocationHandler(Map<String, Object> attributes, Map<String, ConfiguredObjectAttribute<?, ?>> attributeTypes, Class<? extends ConfiguredObject> categoryClass, ConfiguredObject<?> parent) {
            super(attributes, attributeTypes, null);
            this._parent = parent;
            this._category = categoryClass;
            this._attributes = attributes;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getParent") && (args == null || args.length == 0)) {
                return this._parent;
            }
            if (method.getName().equals("getCategoryClass")) {
                return this._category;
            }
            if (method.getName().equals("getModel") && (args == null || args.length == 0)) {
                return this._parent.getModel();
            }
            return super.invoke(proxy, method, args);
        }

        @Override
        protected Object convert(ConfiguredSettableAttribute attribute, Object value) {
            return attribute.convert(value, this._parent);
        }

        @Override
        protected Class<? extends ConfiguredObject> getCategoryClass() {
            return this._category;
        }

        @Override
        protected String getType() {
            return String.valueOf(this._attributes.get("type"));
        }
    }

    private static class AttributeInitializationInvocationHandler
    extends AttributeGettingHandler {
        AttributeInitializationInvocationHandler(Map<String, Object> modifiedAttributes, Map<String, ConfiguredObjectAttribute<?, ?>> attributeTypes, ConfiguredObject<?> configuredObject) {
            super(modifiedAttributes, attributeTypes, configuredObject);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Arrays.asList("getModel", "getCategoryClass", "getParent").contains(method.getName())) {
                return method.invoke(this.getConfiguredObject(), args);
            }
            return super.invoke(proxy, method, args);
        }
    }

    private static class AttributeGettingHandler
    implements InvocationHandler {
        private final Map<String, Object> _attributes;
        private final Map<String, ConfiguredObjectAttribute<?, ?>> _attributeTypes;
        private final ConfiguredObject<?> _configuredObject;

        AttributeGettingHandler(Map<String, Object> modifiedAttributes, Map<String, ConfiguredObjectAttribute<?, ?>> attributeTypes, ConfiguredObject<?> configuredObject) {
            HashMap<String, Object> combinedAttributes = new HashMap<String, Object>();
            if (configuredObject != null) {
                combinedAttributes.putAll(configuredObject.getActualAttributes());
            }
            combinedAttributes.putAll(modifiedAttributes);
            this._attributes = combinedAttributes;
            this._attributeTypes = attributeTypes;
            this._configuredObject = configuredObject;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ConfiguredObjectAttribute<?, ?> attribute = this.getAttributeFromMethod(method);
            if (attribute != null && attribute.isAutomated()) {
                return this.getValue(attribute);
            }
            if (method.getName().equals("getAttribute") && args != null && args.length == 1 && args[0] instanceof String) {
                attribute = this._attributeTypes.get((String)args[0]);
                if (attribute != null) {
                    return this.getValue(attribute);
                }
                return null;
            }
            if (method.getName().equals("getActualAttributes") && (args == null || args.length == 0)) {
                return Collections.unmodifiableMap(this._attributes);
            }
            if (method.getName().equals("toString") && (args == null || args.length == 0)) {
                return "ValidationProxy{" + this.getCategoryClass().getSimpleName() + "/" + this.getType() + "}";
            }
            if (method.getName().equals("getModel") && (args == null || args.length == 0)) {
                return this._configuredObject.getModel();
            }
            throw new UnsupportedOperationException("This class is only intended for value validation, and only getters on managed attributes are permitted.");
        }

        protected Object getValue(ConfiguredObjectAttribute attribute) {
            if (!attribute.isDerived()) {
                ConfiguredSettableAttribute settableAttr = (ConfiguredSettableAttribute)attribute;
                Object value = this._attributes.get(attribute.getName());
                if (value == null && !"".equals(settableAttr.defaultValue())) {
                    value = settableAttr.defaultValue();
                }
                return this.convert(settableAttr, value);
            }
            if (this._attributes.containsKey(attribute.getName())) {
                return this._attributes.get(attribute.getName());
            }
            if (this._configuredObject != null) {
                return this._configuredObject.getAttribute(attribute.getName());
            }
            return null;
        }

        protected Object convert(ConfiguredSettableAttribute attribute, Object value) {
            return attribute.convert(value, this._configuredObject);
        }

        private ConfiguredObjectAttribute getAttributeFromMethod(Method method) {
            if (!Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 0) {
                for (ConfiguredObjectAttribute<?, ?> attribute : this._attributeTypes.values()) {
                    if (!(attribute instanceof ConfiguredObjectMethodAttribute) || !((ConfiguredObjectMethodAttribute)attribute).getGetter().getName().equals(method.getName())) continue;
                    return attribute;
                }
            }
            return null;
        }

        protected String getType() {
            return this._configuredObject.getType();
        }

        protected Class<? extends ConfiguredObject> getCategoryClass() {
            return this._configuredObject.getCategoryClass();
        }

        ConfiguredObject<?> getConfiguredObject() {
            return this._configuredObject;
        }
    }

    public static class ChainedSettableFuture<V>
    extends AbstractFuture<V>
    implements ChainedListenableFuture<V> {
        private final Executor _exector;

        public ChainedSettableFuture(Executor executor) {
            this._exector = executor;
        }

        public boolean set(V value) {
            return super.set(value);
        }

        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        @Override
        public ChainedListenableFuture<Void> then(Runnable r) {
            return AbstractConfiguredObject.doAfter(this._exector, this, r);
        }

        @Override
        public ChainedListenableFuture<V> then(Callable<ListenableFuture<V>> r) {
            return AbstractConfiguredObject.doAfter(this._exector, this, r);
        }

        @Override
        public <A> ChainedListenableFuture<A> then(CallableWithArgument<ListenableFuture<A>, V> r) {
            return AbstractConfiguredObject.doAfter(this._exector, this, r);
        }
    }

    public static interface ChainedListenableFuture<V>
    extends ListenableFuture<V> {
        public ChainedListenableFuture<Void> then(Runnable var1);

        public ChainedListenableFuture<V> then(Callable<ListenableFuture<V>> var1);

        public <A> ChainedListenableFuture<A> then(CallableWithArgument<ListenableFuture<A>, V> var1);
    }

    public static interface CallableWithArgument<V, A> {
        public V call(A var1) throws Exception;
    }

    private static class DynamicStateWithFuture {
        private final DynamicState _dynamicState;
        private final ListenableFuture<Void> _future;

        private DynamicStateWithFuture(DynamicState dynamicState, ListenableFuture<Void> future) {
            this._dynamicState = dynamicState;
            this._future = future;
        }

        public DynamicState getDynamicState() {
            return this._dynamicState;
        }

        public ListenableFuture<Void> getFuture() {
            return this._future;
        }
    }

    private static enum DynamicState {
        UNINIT,
        OPENED,
        CLOSED;

    }
}

