/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Defaults;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeValue;
import org.apache.qpid.server.model.ManagedAttributeValueTypeDerivedMethod;
import org.apache.qpid.server.model.UnknownConfiguredObjectException;
import org.apache.qpid.server.model.preferences.GenericPrincipal;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.Strings;

abstract class AttributeValueConverter<T> {
    static final AttributeValueConverter<String> STRING_CONVERTER = new AttributeValueConverter<String>(){

        @Override
        public String convert(Object value, ConfiguredObject object) {
            return value == null ? null : AbstractConfiguredObject.interpolate(object, value.toString());
        }
    };
    private static final DateTimeFormatter ISO_DATE_TIME_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter().withChronology(IsoChronology.INSTANCE);
    static final AttributeValueConverter<Object> OBJECT_CONVERTER = new AttributeValueConverter<Object>(){

        @Override
        public Object convert(Object value, ConfiguredObject object) {
            if (value instanceof String) {
                return AbstractConfiguredObject.interpolate(object, (String)value);
            }
            if (value == null) {
                return null;
            }
            return value;
        }
    };
    static final AttributeValueConverter<UUID> UUID_CONVERTER = new AttributeValueConverter<UUID>(){

        @Override
        public UUID convert(Object value, ConfiguredObject object) {
            if (value instanceof UUID) {
                return (UUID)value;
            }
            if (value instanceof String) {
                return UUID.fromString(AbstractConfiguredObject.interpolate(object, (String)value));
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a UUID");
        }
    };
    static final AttributeValueConverter<URI> URI_CONVERTER = new AttributeValueConverter<URI>(){

        @Override
        URI convert(Object value, ConfiguredObject object) {
            if (value instanceof URI) {
                return (URI)value;
            }
            if (value instanceof String) {
                return URI.create(AbstractConfiguredObject.interpolate(object, (String)value));
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a URI");
        }
    };
    static final AttributeValueConverter<byte[]> BINARY_CONVERTER = new AttributeValueConverter<byte[]>(){

        @Override
        byte[] convert(Object value, ConfiguredObject object) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                return Strings.decodeBase64(interpolated);
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a byte[]");
        }
    };
    public static final Pattern BASE64_PATTERN = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");
    static final AttributeValueConverter<Certificate> CERTIFICATE_CONVERTER = new AttributeValueConverter<Certificate>(){

        @Override
        public Certificate convert(Object value, ConfiguredObject object) {
            if (value instanceof Certificate) {
                return (Certificate)value;
            }
            if (value instanceof byte[]) {
                Certificate certificate;
                ByteArrayInputStream is = new ByteArrayInputStream((byte[])value);
                try {
                    certificate = SSLUtil.getCertificateFactory().generateCertificate(is);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException | CertificateException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                is.close();
                return certificate;
            }
            if (value instanceof String) {
                String strValue = AbstractConfiguredObject.interpolate(object, (String)value);
                if (BASE64_PATTERN.matcher(strValue).matches()) {
                    byte[] certificateBytes = (byte[])BINARY_CONVERTER.convert(strValue, object);
                    return this.convert(certificateBytes, object);
                }
                return this.convert(strValue.getBytes(StandardCharsets.UTF_8), object);
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Certificate");
        }
    };
    static final AttributeValueConverter<Long> LONG_CONVERTER = new AttributeValueConverter<Long>(){

        @Override
        public Long convert(Object value, ConfiguredObject object) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                try {
                    return Long.valueOf(interpolated);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot convert string '" + interpolated + "' to a long integer", e);
                }
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Long");
        }
    };
    static final AttributeValueConverter<Integer> INT_CONVERTER = new AttributeValueConverter<Integer>(){

        @Override
        public Integer convert(Object value, ConfiguredObject object) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                try {
                    return Integer.valueOf(interpolated);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot convert string '" + interpolated + "' to an integer", e);
                }
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to an Integer");
        }
    };
    static final AttributeValueConverter<Short> SHORT_CONVERTER = new AttributeValueConverter<Short>(){

        @Override
        public Short convert(Object value, ConfiguredObject object) {
            if (value instanceof Short) {
                return (Short)value;
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                try {
                    return Short.valueOf(interpolated);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot convert string '" + interpolated + "' to a short integer", e);
                }
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Short");
        }
    };
    static final AttributeValueConverter<Double> DOUBLE_CONVERTER = new AttributeValueConverter<Double>(){

        @Override
        public Double convert(Object value, ConfiguredObject object) {
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                try {
                    return Double.valueOf(interpolated);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot convert string '" + interpolated + "' to a Double", e);
                }
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Double");
        }
    };
    static final AttributeValueConverter<Boolean> BOOLEAN_CONVERTER = new AttributeValueConverter<Boolean>(){

        @Override
        public Boolean convert(Object value, ConfiguredObject object) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf(AbstractConfiguredObject.interpolate(object, (String)value));
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Boolean");
        }
    };
    static final AttributeValueConverter<List> LIST_CONVERTER = new AttributeValueConverter<List>(){

        @Override
        public List convert(Object value, ConfiguredObject object) {
            if (value instanceof List) {
                return Collections.unmodifiableList((List)value);
            }
            if (value instanceof Object[]) {
                return this.convert(Arrays.asList((Object[])value), object);
            }
            if (value instanceof String) {
                return Collections.unmodifiableList(AttributeValueConverter.convertFromJson((String)value, object, List.class));
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a List");
        }
    };
    static final AttributeValueConverter<Set> SET_CONVERTER = new AttributeValueConverter<Set>(){

        @Override
        public Set convert(Object value, ConfiguredObject object) {
            if (value instanceof Set) {
                return Collections.unmodifiableSet((Set)value);
            }
            if (value instanceof Object[]) {
                return this.convert(new HashSet<Object>(Arrays.asList((Object[])value)), object);
            }
            if (value instanceof String) {
                return Collections.unmodifiableSet(AttributeValueConverter.convertFromJson((String)value, object, Set.class));
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Set");
        }
    };
    static final AttributeValueConverter<Collection> COLLECTION_CONVERTER = new AttributeValueConverter<Collection>(){

        @Override
        public Collection convert(Object value, ConfiguredObject object) {
            if (value instanceof Collection) {
                return Collections.unmodifiableCollection((Collection)value);
            }
            if (value instanceof Object[]) {
                return this.convert(Arrays.asList((Object[])value), object);
            }
            if (value instanceof String) {
                return Collections.unmodifiableCollection(AttributeValueConverter.convertFromJson((String)value, object, Collection.class));
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Collection");
        }
    };
    static final AttributeValueConverter<Map> MAP_CONVERTER = new AttributeValueConverter<Map>(){

        @Override
        public Map convert(Object value, ConfiguredObject object) {
            if (value instanceof Map) {
                Map originalMap = (Map)value;
                LinkedHashMap resolvedMap = new LinkedHashMap(originalMap.size());
                for (Map.Entry entry : originalMap.entrySet()) {
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    resolvedMap.put(key instanceof String ? AbstractConfiguredObject.interpolate(object, (String)key) : key, val instanceof String ? AbstractConfiguredObject.interpolate(object, (String)val) : val);
                }
                return Collections.unmodifiableMap(resolvedMap);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return Collections.unmodifiableMap(AttributeValueConverter.convertFromJson((String)value, object, Map.class));
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Map");
        }
    };
    static final AttributeValueConverter<Date> DATE_CONVERTER = new AttributeValueConverter<Date>(){

        @Override
        public Date convert(Object value, ConfiguredObject object) {
            if (value instanceof Date) {
                return (Date)value;
            }
            if (value instanceof Number) {
                return new Date(((Number)value).longValue());
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                try {
                    return new Date(Long.valueOf(interpolated));
                }
                catch (NumberFormatException e) {
                    try {
                        return ISO_DATE_TIME_FORMAT.parse(interpolated).query(this::convertToDate);
                    }
                    catch (DateTimeParseException e1) {
                        throw new IllegalArgumentException("Cannot convert string '" + interpolated + "' to a Date. It is neither a ISO-8601 date or date time nor a string containing a numeric value.");
                    }
                }
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Date");
        }

        private Date convertToDate(TemporalAccessor t) {
            if (!t.isSupported(ChronoField.INSTANT_SECONDS)) {
                t = LocalDateTime.of(LocalDate.from(t), LocalTime.MIN).atOffset(ZoneOffset.UTC);
            }
            return new Date(t.getLong(ChronoField.INSTANT_SECONDS) * 1000L + t.getLong(ChronoField.MILLI_OF_SECOND));
        }
    };
    public static final AttributeValueConverter<Principal> PRINCIPAL_CONVERTER = new AttributeValueConverter<Principal>(){

        @Override
        public Principal convert(Object value, ConfiguredObject object) {
            if (value instanceof Principal) {
                return (Principal)value;
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                return new GenericPrincipal(interpolated);
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Principal");
        }
    };

    AttributeValueConverter() {
    }

    private static <T> T convertFromJson(String value, ConfiguredObject object, Class<T> valueType) {
        String interpolated = AbstractConfiguredObject.interpolate(object, value);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (T)objectMapper.readValue(interpolated, valueType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot convert String '" + value + "'" + (String)(value.equals(interpolated) ? "" : " (interpolated to '" + interpolated + "')") + " to a " + valueType.getSimpleName());
        }
    }

    static <X> AttributeValueConverter<X> getConverter(Class<X> type, Type returnType) {
        if (type == String.class) {
            return STRING_CONVERTER;
        }
        if (type == Integer.class) {
            return INT_CONVERTER;
        }
        if (type == Short.class) {
            return SHORT_CONVERTER;
        }
        if (type == Long.class) {
            return LONG_CONVERTER;
        }
        if (type == Double.class) {
            return DOUBLE_CONVERTER;
        }
        if (type == Boolean.class) {
            return BOOLEAN_CONVERTER;
        }
        if (type == Date.class) {
            return DATE_CONVERTER;
        }
        if (type == UUID.class) {
            return UUID_CONVERTER;
        }
        if (type == URI.class) {
            return URI_CONVERTER;
        }
        if (type == byte[].class) {
            return BINARY_CONVERTER;
        }
        if (Certificate.class.isAssignableFrom(type)) {
            return CERTIFICATE_CONVERTER;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return new EnumConverter<X>(type);
        }
        if (List.class.isAssignableFrom(type)) {
            if (returnType instanceof ParameterizedType) {
                Type parameterizedType = ((ParameterizedType)returnType).getActualTypeArguments()[0];
                return new GenericListConverter(parameterizedType);
            }
            return LIST_CONVERTER;
        }
        if (Set.class.isAssignableFrom(type)) {
            if (returnType instanceof ParameterizedType) {
                Type parameterizedType = ((ParameterizedType)returnType).getActualTypeArguments()[0];
                return new GenericSetConverter(parameterizedType);
            }
            return SET_CONVERTER;
        }
        if (Map.class.isAssignableFrom(type)) {
            if (returnType instanceof ParameterizedType) {
                Type keyType = ((ParameterizedType)returnType).getActualTypeArguments()[0];
                Type valueType = ((ParameterizedType)returnType).getActualTypeArguments()[1];
                return new GenericMapConverter(keyType, valueType);
            }
            return MAP_CONVERTER;
        }
        if (Collection.class.isAssignableFrom(type)) {
            if (returnType instanceof ParameterizedType) {
                Type parameterizedType = ((ParameterizedType)returnType).getActualTypeArguments()[0];
                return new GenericCollectionConverter(parameterizedType);
            }
            return COLLECTION_CONVERTER;
        }
        if (Principal.class.isAssignableFrom(type)) {
            return PRINCIPAL_CONVERTER;
        }
        if (ConfiguredObject.class.isAssignableFrom(type)) {
            return new ConfiguredObjectConverter<X>(type);
        }
        if (ManagedAttributeValue.class.isAssignableFrom(type)) {
            return new ManageableAttributeTypeConverter<X>(type);
        }
        if (Object.class == type) {
            return OBJECT_CONVERTER;
        }
        throw new IllegalArgumentException("Cannot create attribute converter of type " + type.getName());
    }

    static Class<?> getTypeFromMethod(Method m) {
        return AttributeValueConverter.convertPrimitiveToBoxed(m.getReturnType());
    }

    static Class<?> convertPrimitiveToBoxed(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                type = Boolean.class;
            } else if (type == Byte.TYPE) {
                type = Byte.class;
            } else if (type == Short.TYPE) {
                type = Short.class;
            } else if (type == Integer.TYPE) {
                type = Integer.class;
            } else if (type == Long.TYPE) {
                type = Long.class;
            } else if (type == Float.TYPE) {
                type = Float.class;
            } else if (type == Double.TYPE) {
                type = Double.class;
            } else if (type == Character.TYPE) {
                type = Character.class;
            }
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getNameFromMethod(Method m, Class<?> type) {
        String baseName;
        String methodName = m.getName();
        if (type == Boolean.class) {
            if ((methodName.startsWith("get") || methodName.startsWith("has")) && methodName.length() >= 4) {
                baseName = methodName.substring(3);
            } else {
                if (!methodName.startsWith("is")) throw new IllegalArgumentException("Method name " + methodName + " does not conform to the required pattern for ManagedAttributes");
                if (methodName.length() < 3) throw new IllegalArgumentException("Method name " + methodName + " does not conform to the required pattern for ManagedAttributes");
                baseName = methodName.substring(2);
            }
        } else {
            if (!methodName.startsWith("get")) throw new IllegalArgumentException("Method name " + methodName + " does not conform to the required pattern for ManagedAttributes");
            if (methodName.length() < 4) throw new IllegalArgumentException("Method name " + methodName + " does not conform to the required pattern for ManagedAttributes");
            baseName = methodName.substring(3);
        }
        String name = baseName.length() == 1 ? baseName.toLowerCase() : baseName.substring(0, 1).toLowerCase() + baseName.substring(1);
        return name.replace('_', '.');
    }

    abstract T convert(Object var1, ConfiguredObject var2);

    private static Class getRawType(Type t) {
        Type[] bounds;
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof TypeVariable && (bounds = ((TypeVariable)t).getBounds()).length == 1) {
            return AttributeValueConverter.getRawType(bounds[0]);
        }
        throw new ServerScopedRuntimeException("Unable to process type when constructing configuration model: " + t);
    }

    static final class ManageableAttributeTypeConverter<X extends ManagedAttributeValue>
    extends AttributeValueConverter<X> {
        private static final Pattern STATIC_METHOD_PATTERN = Pattern.compile("([\\w][\\w\\d_]+\\.)+[\\w][\\w\\d_\\$]*#[\\w\\d_]+\\s*\\(\\s*\\)");
        private static final Pattern OBJECT_METHOD_PATTERN = Pattern.compile("#[\\w\\d_]+\\s*\\(\\s*\\)");
        private final Class<X> _klazz;
        private final Map<Method, AttributeValueConverter<?>> _propertyConverters = new HashMap();
        private final Map<Method, ValueMethod<X>> _derivedValueMethod = new HashMap<Method, ValueMethod<X>>();
        private Method _factoryMethod;

        private ManageableAttributeTypeConverter(Class<X> klazz) {
            this._klazz = klazz;
            for (Method method : klazz.getMethods()) {
                ManagedAttributeValueTypeDerivedMethod derivedMethodAnnotation;
                String methodName = method.getName();
                if (method.getParameterTypes().length == 0 && !Arrays.asList(Object.class.getMethods()).contains(method) && (methodName.startsWith("get") || methodName.startsWith("is") || methodName.startsWith("has"))) {
                    this._propertyConverters.put(method, AttributeValueConverter.getConverter(ManageableAttributeTypeConverter.getTypeFromMethod(method), method.getGenericReturnType()));
                }
                if ((derivedMethodAnnotation = method.getAnnotation(ManagedAttributeValueTypeDerivedMethod.class)) != null) {
                    String derivedMethodValue = derivedMethodAnnotation.value();
                    if (STATIC_METHOD_PATTERN.matcher(derivedMethodValue).matches()) {
                        try {
                            String className = derivedMethodValue.split("#")[0].trim();
                            String sourceMethodName = derivedMethodValue.split("#")[1].split("\\(")[0].trim();
                            Class<?> sourceMethodClass = Class.forName(className);
                            Method sourceMethod = sourceMethodClass.getMethod(sourceMethodName, klazz);
                            this._derivedValueMethod.put(method, new StaticMethodValueMethod(sourceMethod));
                        }
                        catch (ClassNotFoundException | NoSuchMethodException e) {
                            throw new IllegalArgumentException(e);
                        }
                    } else if (OBJECT_METHOD_PATTERN.matcher(derivedMethodValue).matches()) {
                        try {
                            Method sourceMethod = klazz.getMethod(derivedMethodValue.substring(1, derivedMethodValue.indexOf(40)), new Class[0]);
                            this._derivedValueMethod.put(method, new ObjectMethodValueMethod(sourceMethod));
                        }
                        catch (NoSuchMethodException e) {
                            throw new IllegalArgumentException(e);
                        }
                    } else {
                        this._derivedValueMethod.put(method, new ConstantValueMethod(derivedMethodValue));
                    }
                }
                if (!method.getName().equals("newInstance") || !Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !method.getReturnType().equals(klazz) || method.getParameterCount() != 1 || !method.getParameterTypes()[0].equals(klazz)) continue;
                this._factoryMethod = method;
            }
        }

        @Override
        X convert(final Object value, final ConfiguredObject object) {
            if (value == null) {
                return null;
            }
            if (this._klazz.isInstance(value)) {
                return (X)((ManagedAttributeValue)value);
            }
            if (value instanceof Map) {
                ManagedAttributeValue proxyObject = (ManagedAttributeValue)Proxy.newProxyInstance(this._klazz.getClassLoader(), new Class[]{this._klazz}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        AttributeValueConverter<?> converter = _propertyConverters.get(method);
                        Map map = (Map)value;
                        if (converter != null) {
                            return this.convertValue(map, converter, method, proxy);
                        }
                        if ("toString".equals(method.getName()) && method.getParameterTypes().length == 0) {
                            return _klazz.getSimpleName() + " : " + map.toString();
                        }
                        if ("hashCode".equals(method.getName()) && method.getParameterTypes().length == 0) {
                            return map.hashCode();
                        }
                        if ("equals".equals(method.getName()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
                            if (_klazz.isInstance(args[0])) {
                                for (Map.Entry<Method, AttributeValueConverter<?>> entry : _propertyConverters.entrySet()) {
                                    AttributeValueConverter<?> conv = entry.getValue();
                                    Method meth = entry.getKey();
                                    Object lvalue = this.convertValue(map, conv, meth, proxy);
                                    Object rvalue = meth.invoke(args[0], new Object[0]);
                                    if ((lvalue != null || rvalue == null) && (lvalue == null || lvalue.equals(rvalue))) continue;
                                    return false;
                                }
                                return true;
                            }
                            return false;
                        }
                        throw new UnsupportedOperationException("The proxy class implements only attribute getters and toString(), hashCode() and equals()");
                    }

                    private Object convertValue(Map map, AttributeValueConverter<?> converter, Method method, Object proxy) {
                        String attributeName = AttributeValueConverter.getNameFromMethod(method, AttributeValueConverter.getTypeFromMethod(method));
                        if (_derivedValueMethod.containsKey(method)) {
                            return converter.convert(_derivedValueMethod.get(method).getValue((ManagedAttributeValue)proxy), object);
                        }
                        if (map.containsKey(attributeName)) {
                            return converter.convert(map.get(attributeName), object);
                        }
                        return Defaults.defaultValue(method.getReturnType());
                    }
                });
                if (this._factoryMethod != null) {
                    try {
                        ManagedAttributeValue createdObject = (ManagedAttributeValue)this._factoryMethod.invoke(null, proxyObject);
                        return (X)createdObject;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new IllegalArgumentException("Cannot convert to " + this._klazz.getName() + " due to error invoking factory method", e);
                    }
                }
                return (X)proxyObject;
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                if (interpolated.trim().isEmpty()) {
                    return null;
                }
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return (X)this.convert(objectMapper.readValue(interpolated, Map.class), object);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a " + this._klazz.getName(), e);
                }
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a " + this._klazz.getName());
        }
    }

    private static class StaticMethodValueMethod<X extends ManagedAttributeValue>
    implements ValueMethod<X> {
        private final Method _sourceMethod;

        public StaticMethodValueMethod(Method sourceMethod) {
            this._sourceMethod = sourceMethod;
        }

        @Override
        public Object getValue(X object) {
            try {
                return this._sourceMethod.invoke(null, object);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static class ObjectMethodValueMethod<X extends ManagedAttributeValue>
    implements ValueMethod<X> {
        private final Method _sourceMethod;

        public ObjectMethodValueMethod(Method sourceMethod) {
            this._sourceMethod = sourceMethod;
        }

        @Override
        public Object getValue(X object) {
            try {
                return this._sourceMethod.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static class ConstantValueMethod<X extends ManagedAttributeValue>
    implements ValueMethod<X> {
        private final String _value;

        public ConstantValueMethod(String derivedMethodValue) {
            this._value = derivedMethodValue;
        }

        @Override
        public Object getValue(X object) {
            return this._value;
        }
    }

    private static interface ValueMethod<X extends ManagedAttributeValue> {
        public Object getValue(X var1);
    }

    static final class ConfiguredObjectConverter<X extends ConfiguredObject<X>>
    extends AttributeValueConverter<X> {
        private final Class<X> _klazz;

        private ConfiguredObjectConverter(Class<X> klazz) {
            this._klazz = klazz;
        }

        @Override
        public X convert(Object value, ConfiguredObject object) {
            if (value == null) {
                return null;
            }
            if (this._klazz.isInstance(value)) {
                return (X)((ConfiguredObject)value);
            }
            if (value instanceof UUID) {
                Collection<X> reachable = object.getModel().getReachableObjects(object, this._klazz);
                for (ConfiguredObject candidate : reachable) {
                    if (!candidate.getId().equals(value)) continue;
                    return (X)candidate;
                }
                throw new UnknownConfiguredObjectException(this._klazz, (UUID)value);
            }
            if (value instanceof String) {
                String valueStr = AbstractConfiguredObject.interpolate(object, (String)value);
                Collection<X> reachable = object.getModel().getReachableObjects(object, this._klazz);
                for (ConfiguredObject candidate : reachable) {
                    if (!candidate.getName().equals(valueStr)) continue;
                    return (X)candidate;
                }
                try {
                    UUID id = UUID.fromString(valueStr);
                    return (X)this.convert(id, object);
                }
                catch (IllegalArgumentException e) {
                    throw new UnknownConfiguredObjectException(this._klazz, valueStr);
                }
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a " + this._klazz.getName());
        }
    }

    static final class EnumConverter<X extends Enum<X>>
    extends AttributeValueConverter<X> {
        private final Class<X> _klazz;

        private EnumConverter(Class<X> klazz) {
            this._klazz = klazz;
        }

        @Override
        public X convert(Object value, ConfiguredObject object) {
            if (value == null) {
                return null;
            }
            if (this._klazz.isInstance(value)) {
                return (X)((Enum)value);
            }
            if (value instanceof String) {
                return Enum.valueOf(this._klazz, AbstractConfiguredObject.interpolate(object, (String)value));
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a " + this._klazz.getName());
        }
    }

    public static class GenericMapConverter
    extends AttributeValueConverter<Map> {
        private final AttributeValueConverter<?> _keyConverter;
        private final AttributeValueConverter<?> _valueConverter;

        public GenericMapConverter(Type keyType, Type valueType) {
            this._keyConverter = GenericMapConverter.getConverter(AttributeValueConverter.getRawType(keyType), keyType);
            this._valueConverter = GenericMapConverter.getConverter(AttributeValueConverter.getRawType(valueType), valueType);
        }

        @Override
        public Map convert(Object value, ConfiguredObject object) {
            if (value instanceof Map) {
                Map original = (Map)value;
                LinkedHashMap converted = new LinkedHashMap(original.size());
                for (Map.Entry entry : original.entrySet()) {
                    converted.put(this._keyConverter.convert(entry.getKey(), object), this._valueConverter.convert(entry.getValue(), object));
                }
                return Collections.unmodifiableMap(converted);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return this.convert(objectMapper.readValue(interpolated, Map.class), object);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Cannot convert type " + value.getClass() + " to a Map");
        }
    }

    public static class GenericCollectionConverter
    extends AttributeValueConverter<Collection> {
        private final AttributeValueConverter<?> _memberConverter;

        public GenericCollectionConverter(Type genericType) {
            this._memberConverter = GenericCollectionConverter.getConverter(AttributeValueConverter.getRawType(genericType), genericType);
        }

        @Override
        public Collection convert(Object value, ConfiguredObject object) {
            if (value instanceof Collection) {
                Collection original = (Collection)value;
                ArrayList converted = new ArrayList(original.size());
                for (Object member : original) {
                    converted.add(this._memberConverter.convert(member, object));
                }
                return Collections.unmodifiableCollection(converted);
            }
            if (value instanceof Object[]) {
                return this.convert(Arrays.asList((Object[])value), object);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return this.convert(objectMapper.readValue(interpolated, List.class), object);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return Collections.unmodifiableCollection(Collections.singletonList(this._memberConverter.convert(value, object)));
        }
    }

    public static class GenericSetConverter
    extends AttributeValueConverter<Set> {
        private final AttributeValueConverter<?> _memberConverter;

        public GenericSetConverter(Type genericType) {
            this._memberConverter = GenericSetConverter.getConverter(AttributeValueConverter.getRawType(genericType), genericType);
        }

        @Override
        public Set convert(Object value, ConfiguredObject object) {
            if (value instanceof Collection) {
                Collection original = (Collection)value;
                HashSet converted = new HashSet(original.size());
                for (Object member : original) {
                    converted.add(this._memberConverter.convert(member, object));
                }
                return Collections.unmodifiableSet(converted);
            }
            if (value instanceof Object[]) {
                return this.convert(new HashSet<Object>(Arrays.asList((Object[])value)), object);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return this.convert(objectMapper.readValue(interpolated, Set.class), object);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return Collections.unmodifiableSet(Collections.singleton(this._memberConverter.convert(value, object)));
        }
    }

    public static class GenericListConverter
    extends AttributeValueConverter<List> {
        private final AttributeValueConverter<?> _memberConverter;

        public GenericListConverter(Type genericType) {
            this._memberConverter = GenericListConverter.getConverter(AttributeValueConverter.getRawType(genericType), genericType);
        }

        @Override
        public List convert(Object value, ConfiguredObject object) {
            if (value instanceof Collection) {
                Collection original = (Collection)value;
                ArrayList converted = new ArrayList(original.size());
                for (Object member : original) {
                    converted.add(this._memberConverter.convert(member, object));
                }
                return Collections.unmodifiableList(converted);
            }
            if (value instanceof Object[]) {
                return this.convert(Arrays.asList((Object[])value), object);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String interpolated = AbstractConfiguredObject.interpolate(object, (String)value);
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return this.convert(objectMapper.readValue(interpolated, List.class), object);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return "".equals(value) ? List.of() : List.of(this._memberConverter.convert(value, object));
        }
    }
}

