/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.AttributeValueConverter;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.OperationParameter;
import org.apache.qpid.server.model.OperationParameterFromAnnotation;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class ConfiguredObjectMethodOperation<C extends ConfiguredObject<?>>
implements ConfiguredObjectOperation<C> {
    private final Method _operation;
    private final OperationParameterFromAnnotation[] _params;
    private final Set<String> _validNames;
    private final String _objectType;
    private final ConfiguredObjectTypeRegistry _typeRegistry;

    public ConfiguredObjectMethodOperation(Class<C> clazz, Method operation, ConfiguredObjectTypeRegistry typeRegistry) {
        this._objectType = clazz.getSimpleName();
        this._operation = operation;
        this._typeRegistry = typeRegistry;
        Annotation[][] allParameterAnnotations = this._operation.getParameterAnnotations();
        this._params = new OperationParameterFromAnnotation[allParameterAnnotations.length];
        LinkedHashSet<String> validNames = new LinkedHashSet<String>();
        for (int i = 0; i < allParameterAnnotations.length; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = allParameterAnnotations[i]) {
                if (!(annotation instanceof Param)) continue;
                this._params[i] = new OperationParameterFromAnnotation((Param)annotation, this._operation.getParameterTypes()[i], this._operation.getGenericParameterTypes()[i]);
                validNames.add(this._params[i].getName());
            }
            if (this._params[i] != null) continue;
            throw new IllegalArgumentException("Parameter doesn't have a @Param annotation");
        }
        this._validNames = Collections.unmodifiableSet(validNames);
    }

    @Override
    public String getName() {
        return this._operation.getName();
    }

    @Override
    public List<OperationParameter> getParameters() {
        return Collections.unmodifiableList(Arrays.asList(this._params));
    }

    @Override
    public Object perform(C subject, Map<String, Object> parameters) {
        Map<String, ConfiguredObjectOperation<?>> operationsOnSubject = this._typeRegistry.getOperations(subject.getClass());
        if (operationsOnSubject == null || operationsOnSubject.get(this._operation.getName()) == null) {
            throw new IllegalArgumentException("No operation " + this._operation.getName() + " on " + subject.getClass().getSimpleName());
        }
        if (!this.hasSameParameters(operationsOnSubject.get(this._operation.getName()))) {
            throw new IllegalArgumentException("Operation " + this._operation.getName() + " on " + this._objectType + " cannot be used on an object of type " + subject.getClass().getSimpleName());
        }
        if (operationsOnSubject.get(this._operation.getName()) != this) {
            return operationsOnSubject.get(this._operation.getName()).perform(subject, parameters);
        }
        HashSet<String> providedNames = new HashSet<String>(parameters.keySet());
        providedNames.removeAll(this._validNames);
        if (!providedNames.isEmpty()) {
            throw new IllegalArgumentException("Parameters " + providedNames + " are not accepted by " + this.getName());
        }
        Object[] paramValues = new Object[this._params.length];
        for (int i = 0; i < this._params.length; ++i) {
            paramValues[i] = this.getParameterValue(subject, parameters, this._params[i]);
        }
        try {
            return this._operation.invoke(subject, paramValues);
        }
        catch (IllegalAccessException e) {
            throw new ServerScopedRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new ServerScopedRuntimeException(e);
        }
    }

    protected Object getParameterValue(C subject, Map<String, Object> parameters, OperationParameter param) {
        Object convertedVal;
        Object providedVal = parameters.containsKey(param.getName()) ? parameters.get(param.getName()) : (!"".equals(param.getDefaultValue()) ? param.getDefaultValue() : null);
        if (providedVal == null && param.isMandatory()) {
            throw new IllegalArgumentException(String.format("Parameter '%s' of operation %s in %s requires a non-null value", param.getName(), this._operation.getName(), this._objectType));
        }
        AttributeValueConverter<?> converter = AttributeValueConverter.getConverter(AttributeValueConverter.convertPrimitiveToBoxed(param.getType()), param.getGenericType());
        try {
            convertedVal = converter.convert(providedVal, (ConfiguredObject)subject);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + " for parameter '" + param.getName() + "' in " + this._objectType + "." + this._operation.getName() + "(...) operation", e.getCause());
        }
        return convertedVal;
    }

    @Override
    public boolean hasSameParameters(ConfiguredObjectOperation<?> other) {
        List<OperationParameter> otherParams = other.getParameters();
        if (this._params.length == otherParams.size()) {
            for (int i = 0; i < this._params.length; ++i) {
                if (this._params[i].isCompatible(otherParams.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getReturnType() {
        return this._operation.getReturnType();
    }

    @Override
    public String getDescription() {
        return this._operation.getAnnotation(ManagedOperation.class).description();
    }

    @Override
    public boolean isNonModifying() {
        return this._operation.getAnnotation(ManagedOperation.class).nonModifying();
    }

    @Override
    public boolean isAssociateAsIfChildren() {
        return this._operation.getAnnotation(ManagedOperation.class).associateAsIfChildren();
    }

    @Override
    public boolean isSecure(C subject, Map<String, Object> arguments) {
        return this._operation.getAnnotation(ManagedOperation.class).secure() || this.requiresSecure(subject, arguments);
    }

    private boolean requiresSecure(C subject, Map<String, Object> arguments) {
        String secureParam = this._operation.getAnnotation(ManagedOperation.class).paramRequiringSecure();
        for (OperationParameterFromAnnotation param : this._params) {
            if (!secureParam.equals(param.getName())) continue;
            Object value = this.getParameterValue(subject, arguments, param);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return value != null;
        }
        return false;
    }

    @Override
    public Type getGenericReturnType() {
        return this._operation.getGenericReturnType();
    }
}

