/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Producer;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.session.AbstractAMQPSession;

public class ProducerImpl<X extends Producer<X>>
extends AbstractConfiguredObject<ProducerImpl<X>>
implements Producer<ProducerImpl<X>> {
    private final String _sessionId;
    private final String _sessionName;
    private final String _principal;
    private final String _remoteAddress;
    private final Producer.DeliveryType _deliveryType;
    private final AtomicInteger _messagesOut = new AtomicInteger();
    private final AtomicLong _bytesOut = new AtomicLong();
    private Producer.DestinationType _destinationType;
    private String _destination;

    public ProducerImpl(AbstractAMQPSession<?, ?> session, PublishingLink publishingLink, MessageDestination messageDestination) {
        super(session, ProducerImpl.createAttributeMap(publishingLink));
        this._sessionId = String.valueOf(session.getId());
        this._sessionName = session.getName();
        this._principal = session.getAMQPConnection().getPrincipal();
        this._remoteAddress = session.getAMQPConnection().getRemoteAddress();
        String string = this._destination = messageDestination == null ? null : messageDestination.getName();
        if (messageDestination == null) {
            this._deliveryType = Producer.DeliveryType.DELAYED_DELIVERY;
            this._destinationType = null;
        } else {
            this._deliveryType = Producer.DeliveryType.STANDARD_DELIVERY;
            this._destinationType = messageDestination instanceof Exchange ? Producer.DestinationType.EXCHANGE : Producer.DestinationType.QUEUE;
        }
        this.registerWithParents();
        this.open();
    }

    private static Map<String, Object> createAttributeMap(PublishingLink publishingLink) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("id", UUID.randomUUID());
        attributes.put("name", publishingLink.getName());
        attributes.put("durable", false);
        attributes.put("lifetimePolicy", (Object)LifetimePolicy.DELETE_ON_SESSION_END);
        attributes.put("state", (Object)State.ACTIVE);
        return attributes;
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @Override
    public ListenableFuture<Void> deleteNoChecks() {
        return super.deleteNoChecks();
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesOut.incrementAndGet();
        this._bytesOut.addAndGet(messageSize);
    }

    @Override
    public String getSessionId() {
        return this._sessionId;
    }

    @Override
    public String getSessionName() {
        return this._sessionName;
    }

    @Override
    public String getPrincipal() {
        return this._principal;
    }

    @Override
    public String getRemoteAddress() {
        return this._remoteAddress;
    }

    @Override
    public String getDestination() {
        return this._destination;
    }

    @Override
    public void setDestination(String destination) {
        this._destination = destination;
    }

    @Override
    public Producer.DestinationType getDestinationType() {
        return this._destinationType;
    }

    @Override
    public void setDestinationType(Producer.DestinationType destinationType) {
        this._destinationType = destinationType;
    }

    @Override
    public Producer.DeliveryType getDeliveryType() {
        return this._deliveryType;
    }

    @Override
    public int getMessagesOut() {
        return this._messagesOut.get();
    }

    @Override
    public long getBytesOut() {
        return this._bytesOut.get();
    }

    @Override
    public void resetStatistics() {
        this._bytesOut.set(0L);
        this._messagesOut.set(0);
    }
}

