/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.plugin;

import org.apache.qpid.server.model.Protocol;

public class AMQPProtocolVersionWrapper {
    static final String DELIMITER = "_";
    private int _major;
    private int _minor;
    private int _patch;

    public AMQPProtocolVersionWrapper(Protocol amqpProtocol) {
        if (!amqpProtocol.isAMQP()) {
            throw new IllegalArgumentException("Protocol must be of type " + Protocol.ProtocolType.AMQP);
        }
        String[] parts = amqpProtocol.name().split(DELIMITER);
        block5: for (int i = 0; i < parts.length; ++i) {
            switch (i) {
                case 1: {
                    this._major = Integer.parseInt(parts[i]);
                    continue block5;
                }
                case 2: {
                    this._minor = Integer.parseInt(parts[i]);
                    continue block5;
                }
                case 3: {
                    this._patch = Integer.parseInt(parts[i]);
                }
            }
        }
    }

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public int getPatch() {
        return this._patch;
    }

    public Protocol getProtocol() {
        return Protocol.valueOf(this.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AMQPProtocolVersionWrapper number = (AMQPProtocolVersionWrapper)o;
        if (this._major != number._major) {
            return false;
        }
        if (this._minor != number._minor) {
            return false;
        }
        return this._patch == number._patch;
    }

    public int hashCode() {
        int result = this._major;
        result = 31 * result + this._minor;
        result = 31 * result + this._patch;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Protocol.ProtocolType.AMQP.name()).append(DELIMITER).append(this._major).append(DELIMITER).append(this._minor);
        if (this._patch != 0) {
            sb.append(DELIMITER).append(this._patch);
        }
        return sb.toString();
    }
}

