/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.ManagedUser;
import org.apache.qpid.server.security.auth.sasl.PasswordSource;

public abstract class ConfigModelPasswordManagingAuthenticationProvider<X extends ConfigModelPasswordManagingAuthenticationProvider<X>>
extends AbstractAuthenticationManager<X>
implements PasswordCredentialManagingAuthenticationProvider<X> {
    static final Charset ASCII = StandardCharsets.US_ASCII;
    protected Map<String, ManagedUser> _users = new ConcurrentHashMap<String, ManagedUser>();

    protected ConfigModelPasswordManagingAuthenticationProvider(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    public ManagedUser getUser(String username) {
        return this._users.get(username);
    }

    protected PasswordSource getPasswordSource() {
        return username -> {
            ManagedUser user = this.getUser(username);
            if (user == null) {
                return null;
            }
            return user.getPassword().toCharArray();
        };
    }

    @Override
    public boolean createUser(final String username, final String password, Map<String, String> attributes) {
        return this.runTask(new Task<Boolean, RuntimeException>(){

            @Override
            public Boolean execute() {
                HashMap<String, Object> userAttrs = new HashMap<String, Object>();
                userAttrs.put("id", UUID.randomUUID());
                userAttrs.put("name", username);
                userAttrs.put("password", password);
                userAttrs.put("type", "managed");
                User user = ConfigModelPasswordManagingAuthenticationProvider.this.createChild(User.class, userAttrs);
                return user != null;
            }

            @Override
            public String getObject() {
                return ConfigModelPasswordManagingAuthenticationProvider.this.toString();
            }

            @Override
            public String getAction() {
                return "create user";
            }

            @Override
            public String getArguments() {
                return username;
            }
        });
    }

    @Override
    public void deleteUser(String user) throws AccountNotFoundException {
        ManagedUser authUser = this.getUser(user);
        if (authUser == null) {
            throw new AccountNotFoundException("No such user: '" + user + "'");
        }
        authUser.delete();
    }

    @Override
    public Map<String, Map<String, String>> getUsers() {
        return this.runTask(new Task<Map<String, Map<String, String>>, RuntimeException>(){

            @Override
            public Map<String, Map<String, String>> execute() {
                HashMap<String, Map<String, String>> users = new HashMap<String, Map<String, String>>();
                for (String user : ConfigModelPasswordManagingAuthenticationProvider.this._users.keySet()) {
                    users.put(user, Map.of());
                }
                return users;
            }

            @Override
            public String getObject() {
                return ConfigModelPasswordManagingAuthenticationProvider.this.toString();
            }

            @Override
            public String getAction() {
                return "get users";
            }

            @Override
            public String getArguments() {
                return null;
            }
        });
    }

    @Override
    public void reload() throws IOException {
    }

    @Override
    public void setPassword(final String username, final String password) throws AccountNotFoundException {
        this.runTask(new Task<Object, AccountNotFoundException>(){

            @Override
            public Void execute() throws AccountNotFoundException {
                ManagedUser authUser = ConfigModelPasswordManagingAuthenticationProvider.this.getUser(username);
                if (authUser != null) {
                    authUser.setPassword(password);
                    return null;
                }
                throw new AccountNotFoundException("No such user: '" + username + "'");
            }

            @Override
            public String getObject() {
                return ConfigModelPasswordManagingAuthenticationProvider.this.toString();
            }

            @Override
            public String getAction() {
                return "set password";
            }

            @Override
            public String getArguments() {
                return username;
            }
        });
    }

    protected abstract String createStoredPassword(String var1);

    Map<String, ManagedUser> getUserMap() {
        return this._users;
    }

    @Override
    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes) {
        if (childClass == User.class) {
            String username = (String)attributes.get("name");
            if (this._users.containsKey(username)) {
                throw new IllegalArgumentException("User '" + username + "' already exists");
            }
            attributes.put("password", this.createStoredPassword((String)attributes.get("password")));
            ManagedUser user = new ManagedUser(attributes, this);
            user.create();
            return Futures.immediateFuture((Object)this.getUser(username));
        }
        return super.addChildAsync(childClass, attributes);
    }

    abstract void validateUser(ManagedUser var1);

    public static Map<String, Collection<String>> getSupportedUserTypes() {
        return Map.of(User.class.getSimpleName(), Set.of("managed"));
    }
}

