/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager.oauth2.cloudfoundry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.oauth2.IdentityResolverException;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2AuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2IdentityResolverService;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2Utils;
import org.apache.qpid.server.util.ConnectionBuilder;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class CloudFoundryOAuth2IdentityResolverService
implements OAuth2IdentityResolverService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudFoundryOAuth2IdentityResolverService.class);
    public static final String TYPE = "CloudFoundryIdentityResolver";
    private final ObjectMapper _objectMapper = new ObjectMapper();

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate(OAuth2AuthenticationProvider<?> authProvider) throws IllegalConfigurationException {
    }

    @Override
    public Principal getUserPrincipal(OAuth2AuthenticationProvider<?> authenticationProvider, String accessToken, NamedAddressSpace addressSpace) throws IOException, IdentityResolverException {
        URL checkTokenEndpoint = authenticationProvider.getIdentityResolverEndpointURI(addressSpace).toURL();
        TrustStore trustStore = authenticationProvider.getTrustStore();
        String clientId = authenticationProvider.getClientId();
        String clientSecret = authenticationProvider.getClientSecret();
        ConnectionBuilder connectionBuilder = new ConnectionBuilder(checkTokenEndpoint);
        connectionBuilder.setConnectTimeout(authenticationProvider.getConnectTimeout()).setReadTimeout(authenticationProvider.getReadTimeout());
        if (trustStore != null) {
            try {
                connectionBuilder.setTrustMangers(trustStore.getTrustManagers());
            }
            catch (GeneralSecurityException e) {
                throw new ServerScopedRuntimeException("Cannot initialise TLS", e);
            }
        }
        connectionBuilder.setTlsProtocolAllowList(authenticationProvider.getTlsProtocolAllowList()).setTlsProtocolDenyList(authenticationProvider.getTlsProtocolDenyList()).setTlsCipherSuiteAllowList(authenticationProvider.getTlsCipherSuiteAllowList()).setTlsCipherSuiteDenyList(authenticationProvider.getTlsCipherSuiteDenyList());
        LOGGER.debug("About to call identity service '{}'", (Object)checkTokenEndpoint);
        HttpURLConnection connection = connectionBuilder.build();
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + StandardCharsets.UTF_8.name());
        connection.setRequestProperty("Accept", "application/json");
        String encoded = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8));
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        Map<String, String> requestParameters = Collections.singletonMap("token", accessToken);
        connection.connect();
        try (OutputStream output = connection.getOutputStream();){
            UsernamePrincipal usernamePrincipal;
            block19: {
                output.write(OAuth2Utils.buildRequestQuery(requestParameters).getBytes(StandardCharsets.UTF_8));
                output.close();
                InputStream input = OAuth2Utils.getResponseStream(connection);
                try {
                    int responseCode = connection.getResponseCode();
                    LOGGER.debug("Call to identity service '{}' complete, response code : {}", (Object)checkTokenEndpoint, (Object)responseCode);
                    Map responseMap = null;
                    try {
                        responseMap = (Map)this._objectMapper.readValue(input, Map.class);
                    }
                    catch (JsonProcessingException e) {
                        throw new IOException(String.format("Identity resolver '%s' did not return json", checkTokenEndpoint), e);
                    }
                    if (responseCode != 200) {
                        throw new IdentityResolverException(String.format("Identity resolver '%s' failed, response code %d, error '%s', description '%s'", checkTokenEndpoint, responseCode, responseMap.get("error"), responseMap.get("error_description")));
                    }
                    String userName = (String)responseMap.get("user_name");
                    if (userName == null) {
                        throw new IdentityResolverException(String.format("Identity resolver '%s' failed, response did not include 'user_name'", checkTokenEndpoint));
                    }
                    usernamePrincipal = new UsernamePrincipal(userName, authenticationProvider);
                    if (input == null) break block19;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return usernamePrincipal;
        }
    }

    @Override
    public URI getDefaultAuthorizationEndpointURI(OAuth2AuthenticationProvider<?> oAuth2AuthenticationProvider) {
        return null;
    }

    @Override
    public URI getDefaultTokenEndpointURI(OAuth2AuthenticationProvider<?> oAuth2AuthenticationProvider) {
        return null;
    }

    @Override
    public URI getDefaultIdentityResolverEndpointURI(OAuth2AuthenticationProvider<?> oAuth2AuthenticationProvider) {
        return null;
    }

    @Override
    public String getDefaultScope(OAuth2AuthenticationProvider<?> oAuth2AuthenticationProvider) {
        return "";
    }
}

