/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.encryption;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.qpid.server.security.encryption.ConfigurationSecretEncrypter;
import org.apache.qpid.server.security.encryption.EncryptionHelper;
import org.apache.qpid.server.util.Strings;

@Deprecated(since="9.2.0", forRemoval=true)
class AESKeyFileEncrypter
implements ConfigurationSecretEncrypter {
    private static final String CIPHER_NAME = "AES/CBC/PKCS5Padding";
    private static final int AES_INITIALIZATION_VECTOR_LENGTH = 16;
    private static final String AES_ALGORITHM = "AES";
    private final SecretKey _secretKey;
    private final SecureRandom _random = new SecureRandom();

    AESKeyFileEncrypter(SecretKey secretKey) {
        if (secretKey == null) {
            throw new NullPointerException("A non null secret key must be supplied");
        }
        if (!AES_ALGORITHM.equals(secretKey.getAlgorithm())) {
            throw new IllegalArgumentException("Provided secret key was for the algorithm: " + secretKey.getAlgorithm() + "whenAESwas needed.");
        }
        this._secretKey = secretKey;
    }

    @Override
    public String encrypt(String unencrypted) {
        byte[] unencryptedBytes = unencrypted.getBytes(StandardCharsets.UTF_8);
        try {
            byte[] ivbytes = new byte[16];
            this._random.nextBytes(ivbytes);
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            cipher.init(1, (Key)this._secretKey, new IvParameterSpec(ivbytes));
            byte[] encryptedBytes = EncryptionHelper.readFromCipherStream(unencryptedBytes, cipher);
            byte[] output = new byte[16 + encryptedBytes.length];
            System.arraycopy(ivbytes, 0, output, 0, 16);
            System.arraycopy(encryptedBytes, 0, output, 16, encryptedBytes.length);
            return Base64.getEncoder().encodeToString(output);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Unable to encrypt secret", e);
        }
    }

    @Override
    public String decrypt(String encrypted) {
        if (!EncryptionHelper.isValidBase64(encrypted)) {
            throw new IllegalArgumentException("Encrypted value is not valid Base 64 data: '" + encrypted + "'");
        }
        byte[] encryptedBytes = Strings.decodeBase64(encrypted);
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(encryptedBytes, 0, 16);
            cipher.init(2, (Key)this._secretKey, ivParameterSpec);
            return new String(EncryptionHelper.readFromCipherStream(encryptedBytes, 16, encryptedBytes.length - 16, cipher), StandardCharsets.UTF_8);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Unable to decrypt secret", e);
        }
    }
}

