/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.util.FileHelper;
import org.apache.qpid.server.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonFileStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJsonFileStore.class);
    private final FileHelper _fileHelper = new FileHelper();
    private String _directoryName;
    private FileLock _fileLock;
    private String _configFileName;
    private String _backupFileName;
    private String _tempFileName;
    private String _lockFileName;

    protected AbstractJsonFileStore() {
    }

    protected abstract ObjectMapper getSerialisationObjectMapper();

    protected void setup(String name, String storePath, String posixFileAttributes, Object initialData) {
        boolean isFile;
        if (storePath == null) {
            throw new StoreException("Cannot determine path for configuration storage");
        }
        File fileFromSettings = new File(storePath);
        File parentFromSettings = fileFromSettings.getAbsoluteFile().getParentFile();
        boolean bl = isFile = fileFromSettings.exists() && fileFromSettings.isFile();
        if (!isFile) {
            if (fileFromSettings.exists()) {
                isFile = false;
            } else if (fileFromSettings.getName().endsWith(File.separator)) {
                isFile = false;
            } else if (fileFromSettings.getName().endsWith(".json")) {
                isFile = true;
            } else if (parentFromSettings.isDirectory() && fileFromSettings.getName().contains(".")) {
                isFile = true;
            }
        }
        if (isFile) {
            this._directoryName = parentFromSettings.getAbsolutePath();
            this._configFileName = fileFromSettings.getName();
            this._backupFileName = fileFromSettings.getName() + ".bak";
            this._tempFileName = fileFromSettings.getName() + ".tmp";
            this._lockFileName = fileFromSettings.getName() + ".lck";
        } else {
            this._directoryName = storePath;
            this._configFileName = name + ".json";
            this._backupFileName = name + ".bak";
            this._tempFileName = name + ".tmp";
            this._lockFileName = name + ".lck";
        }
        this.checkDirectoryIsWritable(this._directoryName);
        this.getFileLock();
        Path storeFile = new File(this._directoryName, this._configFileName).toPath();
        Path backupFile = new File(this._directoryName, this._backupFileName).toPath();
        if (!Files.exists(storeFile, new LinkOption[0])) {
            if (!Files.exists(backupFile, new LinkOption[0])) {
                try {
                    storeFile = this._fileHelper.createNewFile(storeFile, posixFileAttributes);
                    this.getSerialisationObjectMapper().writeValue(storeFile.toFile(), initialData);
                }
                catch (IOException e) {
                    throw new StoreException("Could not write configuration file " + storeFile, e);
                }
            }
            try {
                this._fileHelper.atomicFileMoveOrReplace(backupFile, storeFile);
            }
            catch (IOException e) {
                throw new StoreException("Could not move backup to configuration file " + storeFile, e);
            }
        }
        try {
            Files.deleteIfExists(backupFile);
        }
        catch (IOException e) {
            throw new StoreException("Could not delete backup file " + backupFile, e);
        }
    }

    protected void cleanup() {
        this.releaseFileLock();
    }

    private void getFileLock() {
        File lockFile = new File(this._directoryName, this._lockFileName);
        try {
            lockFile.createNewFile();
            lockFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(lockFile);
            FileChannel channel = out.getChannel();
            this._fileLock = channel.tryLock();
        }
        catch (IOException ioe) {
            throw new StoreException("Cannot create the lock file " + lockFile.getName(), ioe);
        }
        catch (OverlappingFileLockException e) {
            this._fileLock = null;
        }
        if (this._fileLock == null) {
            throw new StoreException("Cannot get lock on file " + lockFile.getAbsolutePath() + ". Is another instance running?");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkDirectoryIsWritable(String directoryName) {
        File dir = new File(directoryName);
        if (dir.exists()) {
            if (!dir.isDirectory()) throw new StoreException("Configuration path " + directoryName + " exists, but is not a directory");
            if (dir.canWrite()) return;
            throw new StoreException("Configuration path " + directoryName + " exists, but is not writable");
        }
        if (dir.mkdirs()) return;
        throw new StoreException("Cannot create directory " + directoryName);
    }

    protected void save(Object data) {
        try {
            Path tmpFile = new File(this._directoryName, this._tempFileName).toPath();
            this._fileHelper.writeFileSafely(new File(this._directoryName, this._configFileName).toPath(), new File(this._directoryName, this._backupFileName).toPath(), tmpFile, file -> this.getSerialisationObjectMapper().writeValue(file, data));
        }
        catch (IOException e) {
            throw new StoreException("Cannot save to store", e);
        }
    }

    private void releaseFileLock() {
        if (this._fileLock != null) {
            try {
                this._fileLock.release();
                this._fileLock.channel().close();
            }
            catch (IOException e) {
                throw new StoreException("Failed to release lock " + this._fileLock, e);
            }
            finally {
                this._fileLock = null;
            }
        }
    }

    protected File getConfigFile() {
        return new File(this._directoryName, this._configFileName);
    }

    protected void delete(String storePath) {
        if (storePath != null) {
            File configFile;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleting store " + storePath);
            }
            if (!FileUtils.delete(configFile = new File(storePath), true)) {
                LOGGER.info("Failed to delete the store at location " + storePath);
            }
        }
        this._configFileName = null;
        this._directoryName = null;
    }
}

