/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.store.ConfiguredObjectRecord;

public class ConfiguredObjectRecordImpl
implements ConfiguredObjectRecord {
    private final UUID _id;
    private final String _type;
    private final Map<String, Object> _attributes;
    private final Map<String, UUID> _parents;

    public ConfiguredObjectRecordImpl(ConfiguredObjectRecord record) {
        this(record.getId(), record.getType(), record.getAttributes(), record.getParents());
    }

    public ConfiguredObjectRecordImpl(UUID id, String type, Map<String, Object> attributes) {
        this(id, type, attributes, Map.of());
    }

    public ConfiguredObjectRecordImpl(UUID id, String type, Map<String, Object> attributes, Map<String, UUID> parents) {
        this._id = id;
        this._type = type;
        this._attributes = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(attributes));
        this._parents = Collections.unmodifiableMap(new LinkedHashMap<String, UUID>(parents));
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attributes;
    }

    @Override
    public Map<String, UUID> getParents() {
        return this._parents;
    }

    public String toString() {
        return "ConfiguredObjectRecord [id=" + this._id + ", type=" + this._type + ", attributes=" + this._attributes + ", parents=" + this._parents + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfiguredObjectRecordImpl that = (ConfiguredObjectRecordImpl)o;
        return this._type.equals(that._type) && this._id.equals(that._id) && this._attributes.equals(that._attributes);
    }

    public int hashCode() {
        int result = this._id.hashCode();
        result = 31 * result + this._type.hashCode();
        result = 31 * result + this._attributes.hashCode();
        return result;
    }
}

