/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport.network.security.ssl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.transport.TransportException;
import org.apache.qpid.server.transport.network.security.ssl.QpidMultipleTrustManager;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.Strings;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLUtil {
    private static final Logger LOGGER;
    private static final Integer DNS_NAME_TYPE;
    private static final String[] TLS_PROTOCOL_PREFERENCES;
    private static final Pattern DNS_NAME_PATTERN;
    private static final Provider PROVIDER;
    private static final boolean CA_SIGNED = false;
    private static final boolean CRITICAL = true;
    private static final CertificateFactory CERTIFICATE_FACTORY;

    private SSLUtil() {
    }

    public static CertificateFactory getCertificateFactory() {
        if (CERTIFICATE_FACTORY == null) {
            throw new ServerScopedRuntimeException("Certificate factory is null");
        }
        return CERTIFICATE_FACTORY;
    }

    public static void verifyHostname(SSLEngine engine, String hostnameExpected) {
        try {
            Certificate cert = engine.getSession().getPeerCertificates()[0];
            if (!(cert instanceof X509Certificate)) {
                throw new TransportException("Cannot verify peer's hostname as peer does not present a X509Certificate. Presented certificate : " + cert);
            }
            SSLUtil.verifyHostname(hostnameExpected, (X509Certificate)cert);
        }
        catch (SSLPeerUnverifiedException e) {
            throw new TransportException("Failed to verify peer's hostname", e);
        }
    }

    public static void verifyHostname(String hostnameExpected, X509Certificate cert) {
        try {
            SortedSet<String> names = SSLUtil.getNamesFromCert(cert);
            if (names.isEmpty()) {
                throw new TransportException("SSL hostname verification failed. Certificate for did not contain CN or DNS subjectAlt");
            }
            boolean match = SSLUtil.verifyHostname(hostnameExpected, names);
            if (!match) {
                throw new TransportException("SSL hostname verification failed. Expected : " + hostnameExpected + " Found in cert : " + names);
            }
        }
        catch (InvalidNameException e) {
            X500Principal p = cert.getSubjectX500Principal();
            String dn = p.getName();
            throw new TransportException("SSL hostname verification failed. Could not parse name " + dn, e);
        }
        catch (CertificateParsingException e) {
            throw new TransportException("SSL hostname verification failed. Could not parse certificate:  " + e.getMessage(), e);
        }
    }

    public static boolean checkHostname(String hostname, X509Certificate cert) {
        try {
            return SSLUtil.verifyHostname(hostname, SSLUtil.getNamesFromCert(cert));
        }
        catch (CertificateParsingException | InvalidNameException e) {
            return false;
        }
    }

    private static boolean verifyHostname(String hostnameExpected, SortedSet<String> names) {
        boolean match = false;
        String hostName = hostnameExpected.trim().toLowerCase();
        for (String cn : names) {
            boolean doWildcard;
            boolean bl = doWildcard = cn.startsWith("*.") && cn.lastIndexOf(46) >= 3 && !cn.matches("\\*\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
            boolean bl2 = doWildcard ? hostName.endsWith(cn.substring(1)) && hostName.indexOf(".") == 1 + hostName.length() - cn.length() : hostName.equals(cn);
            match = bl2;
            if (!match) continue;
            break;
        }
        return match;
    }

    private static SortedSet<String> getNamesFromCert(X509Certificate cert) throws InvalidNameException, CertificateParsingException {
        X500Principal p = cert.getSubjectX500Principal();
        String dn = p.getName();
        TreeSet<String> names = new TreeSet<String>();
        LdapName ldapName = new LdapName(dn);
        for (Rdn rdn : ldapName.getRdns()) {
            if (!rdn.getType().equalsIgnoreCase("CN")) continue;
            names.add(rdn.getValue().toString());
            break;
        }
        if (cert.getSubjectAlternativeNames() != null) {
            for (List list : cert.getSubjectAlternativeNames()) {
                if (!DNS_NAME_TYPE.equals(list.get(0))) continue;
                names.add((String)list.get(1));
            }
        }
        return names;
    }

    public static String getIdFromSubjectDN(String dn) {
        String cnStr = null;
        StringBuilder dcStr = null;
        if (dn == null) {
            return "";
        }
        try {
            LdapName ln = new LdapName(dn);
            for (Rdn rdn : ln.getRdns()) {
                if ("CN".equalsIgnoreCase(rdn.getType())) {
                    cnStr = rdn.getValue().toString();
                    continue;
                }
                if (!"DC".equalsIgnoreCase(rdn.getType())) continue;
                if (dcStr == null) {
                    dcStr = new StringBuilder(rdn.getValue().toString());
                    continue;
                }
                dcStr.insert(0, rdn.getValue().toString() + ".");
            }
            return cnStr == null || cnStr.length() == 0 ? "" : (dcStr == null ? cnStr : cnStr + "@" + dcStr);
        }
        catch (InvalidNameException e) {
            LOGGER.warn("Invalid name: '{}'", (Object)dn);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getInitializedKeyStore(String storePath, String storePassword, String keyStoreType) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        InputStream in = null;
        try {
            File f = new File(storePath);
            in = f.exists() ? new FileInputStream(f) : Thread.currentThread().getContextClassLoader().getResourceAsStream(storePath);
            if (in == null && !"PKCS11".equalsIgnoreCase(keyStoreType)) {
                throw new IOException("Unable to load keystore resource: " + storePath);
            }
            char[] storeCharPassword = storePassword == null ? null : storePassword.toCharArray();
            ks.load(in, storeCharPassword);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    public static KeyStore getInitializedKeyStore(URL storePath, String storePassword, String keyStoreType) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        try (InputStream in = storePath.openStream();){
            if (in == null && !"PKCS11".equalsIgnoreCase(keyStoreType)) {
                throw new IOException("Unable to load keystore resource: " + storePath);
            }
            char[] storeCharPassword = storePassword == null ? null : storePassword.toCharArray();
            ks.load(in, storeCharPassword);
        }
        catch (IOException ioe) {
            if (ioe.getCause() instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)ioe.getCause();
            }
            throw ioe;
        }
        return ks;
    }

    public static X509Certificate[] readCertificates(URL certFile) throws IOException, GeneralSecurityException {
        try (InputStream is = certFile.openStream();){
            X509Certificate[] x509CertificateArray = SSLUtil.readCertificates(is);
            return x509CertificateArray;
        }
    }

    public static X509Certificate[] readCertificates(InputStream input) throws IOException, GeneralSecurityException {
        ArrayList<X509Certificate> crt;
        block3: {
            crt = new ArrayList<X509Certificate>();
            try {
                do {
                    crt.add((X509Certificate)SSLUtil.getCertificateFactory().generateCertificate(input));
                } while (input.available() != 0);
            }
            catch (CertificateException e) {
                if (!crt.isEmpty()) break block3;
                throw e;
            }
        }
        return crt.toArray(new X509Certificate[0]);
    }

    public static PrivateKey readPrivateKey(URL url) throws IOException, GeneralSecurityException {
        try (InputStream urlStream = url.openStream();){
            PrivateKey privateKey = SSLUtil.readPrivateKey(urlStream);
            return privateKey;
        }
    }

    public static PrivateKey readPrivateKey(InputStream input) throws IOException, GeneralSecurityException {
        byte[] content = SSLUtil.toByteArray(input);
        String contentAsString = new String(content, StandardCharsets.US_ASCII);
        if (contentAsString.contains("-----BEGIN ") && contentAsString.contains(" PRIVATE KEY-----")) {
            String line;
            BufferedReader lineReader = new BufferedReader(new StringReader(contentAsString));
            while (!((line = lineReader.readLine()) == null || line.startsWith("-----BEGIN ") && line.endsWith(" PRIVATE KEY-----"))) {
            }
            if (line != null) {
                StringBuilder keyBuilder = new StringBuilder();
                while (!((line = lineReader.readLine()) == null || line.startsWith("-----END ") && line.endsWith(" PRIVATE KEY-----"))) {
                    keyBuilder.append(line);
                }
                content = Strings.decodeBase64(keyBuilder.toString());
            }
        }
        return SSLUtil.readPrivateKey(content, "RSA");
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int read;
            byte[] tmp = new byte[1024];
            while ((read = input.read(tmp)) != -1) {
                buffer.write(tmp, 0, read);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    public static PrivateKey readPrivateKey(byte[] content, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey key;
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(content);
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            key = kf.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            RSAPrivateCrtKeySpec keySpec = SSLUtil.getRSAKeySpec(content);
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            try {
                key = kf.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException e2) {
                throw new InvalidKeySpecException("Cannot parse the provided key as either PKCS#1 or PCKS#8 format");
            }
        }
        return key;
    }

    private static RSAPrivateCrtKeySpec getRSAKeySpec(byte[] keyBytes) throws InvalidKeySpecException {
        ByteBuffer buffer = ByteBuffer.wrap(keyBytes);
        try {
            int tag = buffer.get() & 0xFF;
            if ((tag & 0x20) != 32 || (tag & 0x1F) != 16) {
                throw new InvalidKeySpecException("Unable to parse key as PKCS#1 format");
            }
            int length = SSLUtil.getLength(buffer);
            buffer = buffer.slice();
            buffer.limit(length);
            byte versionTag = buffer.get();
            int versionLength = SSLUtil.getLength(buffer);
            buffer.position(buffer.position() + versionLength);
            return new RSAPrivateCrtKeySpec(SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer));
        }
        catch (BufferUnderflowException e) {
            throw new InvalidKeySpecException("Unable to parse key as PKCS#1 format");
        }
    }

    private static int getLength(ByteBuffer buffer) {
        int i = buffer.get() & 0xFF;
        if ((i & 0xFFFFFF80) == 0) {
            return i;
        }
        byte[] bytes = new byte[i & 0x7F];
        buffer.get(bytes);
        return new BigInteger(1, bytes).intValue();
    }

    private static BigInteger getInteger(ByteBuffer buffer) throws InvalidKeySpecException {
        int tag = buffer.get() & 0xFF;
        if ((tag & 0x1F) != 2) {
            throw new InvalidKeySpecException("Unable to parse key as PKCS#1 format");
        }
        byte[] num = new byte[SSLUtil.getLength(buffer)];
        buffer.get(num);
        return new BigInteger(num);
    }

    public static void updateEnabledTlsProtocols(SSLEngine engine, List<String> protocolAllowList, List<String> protocolDenyList) {
        String[] filteredProtocols = SSLUtil.filterEnabledProtocols(engine.getEnabledProtocols(), engine.getSupportedProtocols(), protocolAllowList, protocolDenyList);
        engine.setEnabledProtocols(filteredProtocols);
    }

    public static void updateEnabledTlsProtocols(SSLSocket socket, List<String> protocolAllowList, List<String> protocolDenyList) {
        String[] filteredProtocols = SSLUtil.filterEnabledProtocols(socket.getEnabledProtocols(), socket.getSupportedProtocols(), protocolAllowList, protocolDenyList);
        socket.setEnabledProtocols(filteredProtocols);
    }

    public static String[] filterEnabledProtocols(String[] enabledProtocols, String[] supportedProtocols, List<String> protocolAllowList, List<String> protocolDenyList) {
        return SSLUtil.filterEntries(enabledProtocols, supportedProtocols, protocolAllowList, protocolDenyList);
    }

    public static String[] filterEnabledCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites, List<String> cipherSuiteAllowList, List<String> cipherSuiteDenyList) {
        return SSLUtil.filterEntries(enabledCipherSuites, supportedCipherSuites, cipherSuiteAllowList, cipherSuiteDenyList);
    }

    public static void updateEnabledCipherSuites(SSLEngine engine, List<String> cipherSuitesAllowList, List<String> cipherSuitesDenyList) {
        String[] filteredCipherSuites = SSLUtil.filterEntries(engine.getEnabledCipherSuites(), engine.getSupportedCipherSuites(), cipherSuitesAllowList, cipherSuitesDenyList);
        engine.setEnabledCipherSuites(filteredCipherSuites);
    }

    public static void updateEnabledCipherSuites(SSLSocket socket, List<String> cipherSuitesAllowList, List<String> cipherSuitesDenyList) {
        String[] filteredCipherSuites = SSLUtil.filterEntries(socket.getEnabledCipherSuites(), socket.getSupportedCipherSuites(), cipherSuitesAllowList, cipherSuitesDenyList);
        socket.setEnabledCipherSuites(filteredCipherSuites);
    }

    static String[] filterEntries(String[] enabledEntries, String[] supportedEntries, List<String> allowList, List<String> denyList) {
        ArrayList<String> filteredList;
        if (allowList != null && !allowList.isEmpty()) {
            filteredList = new ArrayList();
            ArrayList<String> supportedList = new ArrayList<String>(Arrays.asList(supportedEntries));
            for (String allowListedRegEx : allowList) {
                Iterator supportedIter = supportedList.iterator();
                while (supportedIter.hasNext()) {
                    String supportedEntry = (String)supportedIter.next();
                    if (!supportedEntry.matches(allowListedRegEx)) continue;
                    filteredList.add(supportedEntry);
                    supportedIter.remove();
                }
            }
        } else {
            filteredList = new ArrayList<String>(Arrays.asList(enabledEntries));
        }
        if (denyList != null && !denyList.isEmpty()) {
            for (String denyListedRegEx : denyList) {
                filteredList.removeIf(s -> s.matches(denyListedRegEx));
            }
        }
        return filteredList.toArray(new String[0]);
    }

    public static SSLContext tryGetSSLContext() throws NoSuchAlgorithmException {
        return SSLUtil.tryGetSSLContext(TLS_PROTOCOL_PREFERENCES);
    }

    public static SSLContext tryGetSSLContext(String[] protocols) throws NoSuchAlgorithmException {
        for (String protocol : protocols) {
            try {
                return SSLContext.getInstance(protocol);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        throw new NoSuchAlgorithmException(String.format("Could not create SSLContext with one of the requested protocols: %s", Arrays.toString(protocols)));
    }

    public static boolean isSufficientToDetermineClientSNIHost(QpidByteBuffer buffer) {
        if (buffer.remaining() < 6) {
            return false;
        }
        if (SSLUtil.looksLikeSSLv3ClientHello(buffer)) {
            int position = buffer.position();
            int recordSize = 5 + ((buffer.get(position + 3) & 0xFF) << 8 | buffer.get(position + 4) & 0xFF);
            return buffer.remaining() >= recordSize;
        }
        return true;
    }

    private static boolean looksLikeSSLv3ClientHello(QpidByteBuffer buffer) {
        byte contentType = buffer.get(buffer.position());
        byte majorVersion = buffer.get(buffer.position() + 1);
        byte minorVersion = buffer.get(buffer.position() + 2);
        byte messageType = buffer.get(buffer.position() + 5);
        return contentType == 22 && majorVersion == 3 && (minorVersion == 0 || minorVersion == 1 || minorVersion == 2 || minorVersion == 3) && messageType == 1;
    }

    public static String getServerNameFromTLSClientHello(QpidByteBuffer source) {
        try (QpidByteBuffer input = source.duplicate();){
            if (!SSLUtil.isSufficientToDetermineClientSNIHost(source)) {
                throw new IllegalArgumentException("Source buffer does not contain enough data to determine the SNI name");
            }
            if (!SSLUtil.looksLikeSSLv3ClientHello(source)) {
                String string = null;
                return string;
            }
            byte contentType = input.get();
            byte majorVersion = input.get();
            byte minorVersion = input.get();
            if (minorVersion != 0) {
                int recordLength = input.getUnsignedShort();
                byte messageType = input.get();
                int length = input.getUnsignedByte() << 16 | input.getUnsignedByte() << 8 | input.getUnsignedByte();
                if (input.remaining() < length) {
                    String string = null;
                    return string;
                }
                input.limit(length + input.position());
                input.position(input.position() + 34);
                int skip = input.get();
                input.position(input.position() + skip);
                skip = input.getUnsignedShort();
                input.position(input.position() + skip);
                skip = input.get();
                input.position(input.position() + skip);
                if (input.hasRemaining()) {
                    int remaining = input.getUnsignedShort();
                    if (input.remaining() < remaining) {
                        String string = null;
                        return string;
                    }
                    input.limit(input.position() + remaining);
                    while (input.hasRemaining()) {
                        int extensionType = input.getUnsignedShort();
                        int extensionLength = input.getUnsignedShort();
                        if (extensionType == 0) {
                            int extensionDataRemaining = extensionLength;
                            if (extensionDataRemaining >= 2) {
                                int listLength = input.getUnsignedShort();
                                if (listLength + 2 != extensionDataRemaining) {
                                    String string = null;
                                    return string;
                                }
                                extensionDataRemaining -= 2;
                                while (extensionDataRemaining > 0) {
                                    byte code = input.get();
                                    int serverNameLength = input.getUnsignedShort();
                                    if (serverNameLength > extensionDataRemaining) {
                                        String string = null;
                                        return string;
                                    }
                                    byte[] encoded = new byte[serverNameLength];
                                    input.get(encoded);
                                    if (code == 0) {
                                        String string = SSLUtil.createSNIHostName(encoded).getAsciiName();
                                        return string;
                                    }
                                    extensionDataRemaining -= serverNameLength + 3;
                                }
                            }
                            String string = null;
                            return string;
                        }
                        if (input.remaining() < extensionLength) {
                            String string = null;
                            return string;
                        }
                        input.position(input.position() + extensionLength);
                    }
                }
            }
            String string = null;
            return string;
        }
    }

    public static SSLContext createSslContext(org.apache.qpid.server.model.KeyStore keyStore, Collection<TrustStore> trustStores, String portName) {
        SSLContext sslContext;
        try {
            TrustManager[] trustManagers;
            sslContext = SSLUtil.tryGetSSLContext();
            KeyManager[] keyManagers = keyStore.getKeyManagers();
            if (trustStores == null || trustStores.isEmpty()) {
                trustManagers = null;
            } else if (trustStores.size() == 1) {
                trustManagers = trustStores.iterator().next().getTrustManagers();
            } else {
                ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
                QpidMultipleTrustManager mulTrustManager = new QpidMultipleTrustManager();
                for (TrustStore ts : trustStores) {
                    TrustManager[] managers = ts.getTrustManagers();
                    if (managers == null) continue;
                    for (TrustManager manager : managers) {
                        if (manager instanceof X509TrustManager) {
                            mulTrustManager.addTrustManager((X509TrustManager)manager);
                            continue;
                        }
                        trustManagerList.add(manager);
                    }
                }
                if (!mulTrustManager.isEmpty()) {
                    trustManagerList.add(mulTrustManager);
                }
                trustManagers = trustManagerList.toArray(new TrustManager[0]);
            }
            sslContext.init(keyManagers, trustManagers, null);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(String.format("Cannot configure TLS on port '%s'", portName), e);
        }
        return sslContext;
    }

    public static boolean canGenerateCerts() {
        return true;
    }

    public static KeyCertPair generateSelfSignedCertificate(String keyAlgorithm, String signatureAlgorithm, int keyLength, long startTime, long endTime, String x500Name, Set<String> dnsNames, Set<InetAddress> addresses) throws NoSuchAlgorithmException, OperatorCreationException, CertificateException, CertIOException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(keyAlgorithm);
        keyPairGenerator.initialize(keyLength);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        final PrivateKey privateKey = keyPair.getPrivate();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(keyPair.getPrivate());
        GeneralName[] sanLocalHost = (GeneralName[])Stream.concat(dnsNames.stream().filter(dnsName -> DNS_NAME_PATTERN.matcher((CharSequence)dnsName).matches()).map(dnaName -> new GeneralName(2, dnaName)), addresses.stream().map(InetAddress::getHostAddress).filter(address -> IPAddress.isValidIPv4((String)address) || IPAddress.isValidIPv4WithNetmask((String)address) || IPAddress.isValidIPv6((String)address) || IPAddress.isValidIPv6WithNetmask((String)address)).map(address -> new GeneralName(7, address))).toArray(GeneralName[]::new);
        X500Principal issuerDn = new X500Principal(x500Name);
        X500Principal subjectDn = new X500Principal(x500Name);
        BigInteger serialNumber = new BigInteger(64, new SecureRandom());
        Date startDate = new Date(startTime);
        Date endDate = new Date(endTime);
        PublicKey publicKey = keyPair.getPublic();
        X509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(issuerDn, serialNumber, startDate, endDate, subjectDn, publicKey).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(sanLocalHost));
        final X509Certificate certificate = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certificateBuilder.build(contentSigner));
        return new KeyCertPair(){

            @Override
            public PrivateKey getPrivateKey() {
                return privateKey;
            }

            @Override
            public X509Certificate getCertificate() {
                return certificate;
            }
        };
    }

    public static Map<String, Certificate> getCertificates(KeyStore ks) throws KeyStoreException {
        HashMap<String, Certificate> certificates = new HashMap<String, Certificate>();
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!ks.isCertificateEntry(alias)) continue;
            certificates.put(alias, ks.getCertificate(alias));
        }
        return certificates;
    }

    public static SNIHostName createSNIHostName(String hostName) {
        try {
            return new SNIHostName(hostName);
        }
        catch (IllegalArgumentException e) {
            throw new ConnectionScopedRuntimeException("Failed to create SNIHostName from string '" + hostName + "'", e);
        }
    }

    public static SNIHostName createSNIHostName(byte[] hostName) {
        try {
            return new SNIHostName(hostName);
        }
        catch (IllegalArgumentException e) {
            throw new ConnectionScopedRuntimeException("Failed to create SNIHostName from byte array '" + new String(hostName) + "'", e);
        }
    }

    static {
        CertificateFactory certificateFactory;
        LOGGER = LoggerFactory.getLogger(SSLUtil.class);
        DNS_NAME_TYPE = 2;
        TLS_PROTOCOL_PREFERENCES = new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLS", "TLSv1"};
        DNS_NAME_PATTERN = Pattern.compile("[\\w&&[^\\d]][\\w\\d.-]*");
        PROVIDER = new BouncyCastleProvider();
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            certificateFactory = null;
        }
        CERTIFICATE_FACTORY = certificateFactory;
    }

    public static interface KeyCertPair {
        public PrivateKey getPrivateKey();

        public X509Certificate getCertificate();
    }
}

